/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.remote;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.DB2Host;
import com.ibm.cics.dbfunc.command.SQLCommand;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.pa.model.AlertElement;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.views.AlertsView;
import com.ibm.cics.pa.ui.views.PerformanceAlerts;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;

public class AlertsCommand
extends SQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AlertsCommand.class.getPackage().getName());
    private List<ColumnDefinition> defns;
    private AlertsView view;
    private Selection selectionObject;
    private Map<String, Object> parameterMap;

    public AlertsCommand(AlertsView view, Selection selectionObject, List<ColumnDefinition> defns, Map<String, Object> parameterMap) {
        this.connectionCategory = "com.ibm.cics.pa.connection";
        this.selectionObject = selectionObject;
        this.defns = defns;
        this.view = view;
        if (!parameterMap.containsKey(":schema")) {
            parameterMap.put(":schema", DB2Host.getDefault((String)"com.ibm.cics.pa.connection").getSchema());
        }
        this.parameterMap = parameterMap;
    }

    public SelectionObject getSelectionObject() {
        return this.selectionObject;
    }

    public Map<String, Object> getParameterMap() {
        return this.parameterMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processRow(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        synchronized (resultSet2) {
            try {
                if (this.defns.isEmpty()) {
                    ArrayList<String> cols = new ArrayList<String>();
                    ResultSetMetaData rsmd = resultSet.getMetaData();
                    int i = 1;
                    while (i <= rsmd.getColumnCount()) {
                        cols.add(rsmd.getColumnName(i));
                        ++i;
                    }
                    String[] headers = cols.toArray(new String[cols.size()]);
                    int i2 = 0;
                    while (i2 < headers.length) {
                        ColumnDefinition defn = ColumnDefinition.getByDBColumnRef(headers[i2]);
                        if (defn != null) {
                            this.defns.add(defn);
                        }
                        ++i2;
                    }
                }
                AlertElement element = new AlertElement(this.view, this.defns, resultSet);
                if (this.view instanceof PerformanceAlerts) {
                    element.setAlias("CMFPLST");
                }
                return element;
            }
            catch (SQLException e) {
                Debug.error((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"tableSelected ", (Throwable)e);
            }
        }
        return null;
    }

    protected void customiseEngine() {
        this.motor.setNotifyOnCount(true);
        int pageSize = Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "ALERT_PAGE_SIZE", 0, null);
        if (pageSize > 0) {
            this.motor.setPageSize(pageSize);
        }
    }
}

