/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.preferences;

import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import java.text.MessageFormat;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class StatisticsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Button check;
    Spinner rowNumberSpinner;
    String text;
    Label guideLabel;

    public StatisticsPreferencePage() {
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, Activator.getDefault().getBundle().getSymbolicName()));
    }

    protected Control createContents(Composite parent) {
        Label l = new Label(parent, 16384);
        l.setText(Messages.getString("PAMainPreferencePage.Alerts.Specific"));
        GridData data1 = new GridData(1, 128, true, false);
        l.setLayoutData((Object)data1);
        Composite clientArea = new Composite(parent, 0);
        clientArea.setLayoutData((Object)new GridData(4, 4, true, true));
        clientArea.setLayout((Layout)new GridLayout());
        Composite radioParent = new Composite(clientArea, 0);
        radioParent.setLayoutData((Object)new GridData(4, 128, true, false));
        radioParent.setLayout((Layout)new GridLayout(2, false));
        this.check = new Button(radioParent, 32);
        this.check.setLayoutData((Object)data1);
        this.check.setText(Messages.getString("PAMainPreferencePage.label.radio"));
        this.check.setLayoutData((Object)new GridData(1, 128, false, false));
        final Link link = new Link(radioParent, 0);
        String target = "com.ibm.cics.dbfunc.DBFuncPreferencePage";
        link.setText(Messages.getString("PAMainPreferencePage.label.dbfunc.link"));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)"com.ibm.cics.dbfunc.DBFuncPreferencePage", null, null);
            }
        });
        link.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Composite sliderParent = new Composite(clientArea, 0);
        sliderParent.setLayoutData((Object)new GridData(4, 128, true, false));
        sliderParent.setLayout((Layout)new GridLayout(2, false));
        this.guideLabel = new Label(sliderParent, 64);
        this.guideLabel.setText(Messages.getString("PAMainPreferencePage.label.toomuchdata"));
        GridData data350 = new GridData(1, 0x1000000, true, false);
        data350.widthHint = 400;
        this.guideLabel.setLayoutData((Object)data350);
        this.rowNumberSpinner = new Spinner(sliderParent, 2048);
        this.rowNumberSpinner.setMinimum(5);
        this.rowNumberSpinner.setMaximum(500);
        this.rowNumberSpinner.setIncrement(25);
        this.rowNumberSpinner.setPageIncrement(100);
        this.rowNumberSpinner.setLayoutData((Object)new GridData(1, 128, true, false));
        this.rowNumberSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = StatisticsPreferencePage.this.rowNumberSpinner.getText();
                StatisticsPreferencePage.this.rowNumberSpinner.setToolTipText(MessageFormat.format(Messages.getString("GeneralPreferencePage.accessible.spinner"), text));
                try {
                    if (Integer.valueOf(text) > StatisticsPreferencePage.this.rowNumberSpinner.getMaximum()) {
                        StatisticsPreferencePage.this.rowNumberSpinner.setSelection(StatisticsPreferencePage.this.rowNumberSpinner.getMaximum());
                    }
                }
                catch (NumberFormatException nfe) {
                    StatisticsPreferencePage.this.rowNumberSpinner.setSelection(StatisticsPreferencePage.this.rowNumberSpinner.getMinimum());
                }
            }
        });
        this.rowNumberSpinner.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = MessageFormat.format(Messages.getString("GeneralPreferencePage.accessible.spinner"), StatisticsPreferencePage.this.rowNumberSpinner.getText());
            }

            public void getDescription(AccessibleEvent e) {
                e.result = MessageFormat.format(Messages.getString("GeneralPreferencePage.accessible.spinner"), StatisticsPreferencePage.this.rowNumberSpinner.getText());
            }
        });
        this.check.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatisticsPreferencePage.this.setSelectionState(!StatisticsPreferencePage.this.check.getSelection());
                if (StatisticsPreferencePage.this.check.getSelection()) {
                    StatisticsPreferencePage.this.getPreferenceStore().setValue("ALERT_PAGE_SIZE", 0);
                } else {
                    StatisticsPreferencePage.this.getPreferenceStore().setValue("ALERT_PAGE_SIZE", StatisticsPreferencePage.this.rowNumberSpinner.getSelection());
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.ibm.cics.pa.ui.preferences_statistics");
        int currentpage = this.getPreferenceStore().getInt("ALERT_PAGE_SIZE");
        this.check.setSelection(currentpage == 0);
        this.setSelectionState(currentpage != 0);
        this.rowNumberSpinner.setSelection(currentpage);
        this.guideLabel.setText(Messages.getString("PAMainPreferencePage.label.toomuchdata"));
        return clientArea;
    }

    void setSelectionState(boolean isEnabled) {
        this.guideLabel.setEnabled(isEnabled);
        this.rowNumberSpinner.setEnabled(isEnabled);
        Control[] controlArray = this.rowNumberSpinner.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setEnabled(isEnabled);
            ++n2;
        }
        this.rowNumberSpinner.setToolTipText(Messages.getString("PAMainPreferencePage.label.toomuchdata"));
    }

    protected void performDefaults() {
        int defvalue = this.getPreferenceStore().getDefaultInt("ALERT_PAGE_SIZE");
        this.rowNumberSpinner.setSelection(defvalue);
        this.check.setSelection(defvalue == 0);
        super.performDefaults();
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("ALERT_PAGE_SIZE", this.check.getSelection() ? 0 : this.rowNumberSpinner.getSelection());
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }
}

