/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.pa.model.AlertElement;
import com.ibm.cics.pa.model.ChartingFile;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.SimpleTreeElement;
import com.ibm.cics.pa.model.TranTreeElement;
import com.ibm.cics.pa.model.definitions.AbstractChartDefinition;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.PieChartSpecificDefinitions;
import com.ibm.cics.pa.ui.ChartManager;
import com.ibm.cics.pa.ui.PAContextTracker;
import com.ibm.cics.pa.ui.figures.ChartSelectable;
import com.ibm.cics.pa.ui.handlers.CommonHandler;
import com.ibm.cics.pa.ui.views.Alerts;
import com.ibm.cics.pa.ui.views.PerformanceAlerts;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class DetailBreakdownHandler
extends CommonHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String label;
        Selection select;
        String id;
        GenericDataProvider provider2;
        Debug.enter((Logger)logger, (String)DetailBreakdownHandler.class.getName(), (String)"execute");
        String resId = null;
        StructuredSelection selection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ChartSpecification chartReference = AbstractChartDefinition.getByName("HST_RMI_pie");
        ((PieChartSpecificDefinitions)chartReference.getSpecificType()).setHeader(true);
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        IUniqueRecord record = null;
        if (selection.getFirstElement() instanceof IUniqueRecord && selection.size() == 1) {
            record = (IUniqueRecord)selection.getFirstElement();
            provider2 = ChartingFile.adaptForSpecific(record.getSourceProvider(), record, chartReference);
            id = ChartManager.getInstance().createChart(chartReference, provider2, record.getReference(), record, null);
            resId = this.display(part, id);
        } else if (selection.getFirstElement() instanceof ChartSelectable && selection.size() == 1) {
            record = ((ChartSelectable)((Object)selection.getFirstElement())).getUniqueRecord();
            provider2 = ChartingFile.adaptForSpecific(record.getSourceProvider(), record, chartReference);
            id = ChartManager.getInstance().createChart(chartReference, provider2, record.getReference(), record, null);
            resId = this.display(part, id);
        } else if (selection.getFirstElement() instanceof TranTreeElement) {
            select = PresentationFactory.getInstance().createSelectAllForTable(PAContextTracker.getInstance().getShortTableReference(), ":schema");
            select.applyTableMapping(ManifestRecord.getAliasMapping());
            ((SimpleTreeElement)selection.getFirstElement()).applyConstraint(select);
            label = ((SimpleTreeElement)selection.getFirstElement()).getContentDescriptionLabel();
            this.dbQuery(part, select, label, new HashMap<String, Object>(), chartReference, null, ManifestRecord.getAlias("CMFPSUM"));
            resId = "";
        } else if (selection.getFirstElement() instanceof AlertElement && part instanceof Alerts) {
            select = PresentationFactory.getInstance().createSelectAllForTable(PAContextTracker.getInstance().getShortTableReference(), ":schema");
            select.applyTableMapping(ManifestRecord.getAliasMapping());
            ((AlertElement)selection.getFirstElement()).applyConstraint(select, Direction.DESC);
            label = "";
            this.dbQuery(part, select, label, new HashMap<String, Object>(), chartReference, null, ManifestRecord.getAlias("CMFPSUM"));
            resId = "";
        } else if (selection.getFirstElement() instanceof AlertElement && part instanceof PerformanceAlerts) {
            select = PresentationFactory.getInstance().createSelectAllForTable(PAContextTracker.getInstance().getShortTableReference(), ":schema");
            select.applyTableMapping(ManifestRecord.getAliasMapping());
            ((AlertElement)selection.getFirstElement()).applyConstraint(select, Direction.DESC);
            label = "";
            this.dbQuery(part, select, label, new HashMap<String, Object>(), chartReference, null, ManifestRecord.getAlias("CMFPSUM"));
            resId = "";
        }
        if (record != null) {
            provider2 = ChartingFile.adaptForSpecific(record.getSourceProvider(), record, chartReference);
            id = ChartManager.getInstance().createChart(chartReference, provider2, record.getReference(), record, null);
            resId = this.display(part, id);
        }
        Debug.exit((Logger)logger, (String)DetailBreakdownHandler.class.getName(), (String)"execute", resId);
        return resId;
    }

    private String display(IWorkbenchPart part, String id) {
        try {
            IViewPart view = part.getSite().getPage().showView("com.ibm.cics.pa.ui.pie_editor", id, 2);
            part.getSite().getPage().bringToTop((IWorkbenchPart)view);
        }
        catch (PartInitException ex) {
            logger.logp(Level.SEVERE, DetailBreakdownHandler.class.getName(), "display", "unable to open viewer", ex);
        }
        return id;
    }
}

