/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.figures;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.WaitAnalysis;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Messages;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonShape;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.SimpleRaisedBorder;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;

public class WaitAnalysisFigure
extends Figure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(WaitAnalysisFigure.class);
    public static final int waitHeight = 125;
    public static final int barHeight = 20;
    private FigureCanvas canvas;
    private WaitAnalysis model;
    private Shape sus;
    private Shape dispatch;
    private Shape cpu;
    private Shape disp;
    private Label oaLabel;
    private Label susLabel;
    private Label dispatchLabel;
    private Label cpuLabel;
    private Label dispLabel;
    String accessibleMessage;
    boolean hasFocus;
    private static final int LEFT_MARGIN = 10;
    private int oaWidth = 600;
    private static final int DIMENSION_START = 15;
    private static final int BAR_START = 70;

    public WaitAnalysisFigure(GraphicalViewer viewer, WaitAnalysis waitAnalysis) {
        debug.enter("WaitAnalysisSection");
        this.model = waitAnalysis;
        this.canvas = (FigureCanvas)viewer.getControl();
        this.accessibleMessage = Messages.getString("Jaws.inaccessible");
        this.canvas.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = WaitAnalysisFigure.this.accessibleMessage;
            }
        });
        this.canvas.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (WaitAnalysisFigure.this.hasFocus) {
                    WaitAnalysisFigure.this.hasFocus = false;
                    WaitAnalysisFigure.this.repaint();
                }
            }

            public void focusGained(FocusEvent e) {
                if (!WaitAnalysisFigure.this.hasFocus) {
                    WaitAnalysisFigure.this.hasFocus = true;
                    WaitAnalysisFigure.this.repaint();
                }
            }
        });
        debug.exit("WaitAnalysisSection");
    }

    public void setModel(WaitAnalysis waitAnalysis) {
        debug.enter("setModel", (Object)waitAnalysis);
        this.model = waitAnalysis;
        Object[] objectArray = this.getChildren().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            this.remove((IFigure)child);
            ++n2;
        }
        if (this.model.isReliable()) {
            this.oaLabel = new Label(this.model.getLabelFor(this.model.isPlist() ? ColumnDefinition.RESPONSE_TIME : ColumnDefinition.RESPONSE_TIME_AVG));
            this.oaLabel.setToolTip((IFigure)new Label(this.oaLabel.getText()));
            this.oaLabel.setLabelAlignment(1);
            this.add((IFigure)this.oaLabel);
            this.sus = new PolygonShape();
            int[] nArray = new int[12];
            nArray[2] = this.model.getPixelLengthFor(this.model.isPlist() ? ColumnDefinition.SUSPEND_TIME : ColumnDefinition.SUSPEND_TIME_AVG);
            nArray[4] = this.model.getPixelLengthFor(this.model.isPlist() ? ColumnDefinition.SUSPEND_TIME : ColumnDefinition.SUSPEND_TIME_AVG);
            nArray[5] = 40;
            nArray[6] = this.model.getPixelLengthFor(this.model.isPlist() ? ColumnDefinition.DISPWAIT_TIME : ColumnDefinition.DISPWAIT_TIME_AVG);
            nArray[7] = 40;
            nArray[8] = this.model.getPixelLengthFor(this.model.isPlist() ? ColumnDefinition.DISPWAIT_TIME : ColumnDefinition.DISPWAIT_TIME_AVG);
            nArray[9] = 20;
            nArray[11] = 20;
            ((PolygonShape)this.sus).setPoints(new PointList(nArray));
            this.sus.setBackgroundColor(Column.getFor(this.model.isPlist() ? ColumnDefinition.SUSPEND_TIME : ColumnDefinition.SUSPEND_TIME_AVG).getColor());
            this.sus.setForegroundColor(ColorConstants.darkGray);
            this.sus.setBorder((Border)new SimpleRaisedBorder());
            this.sus.setPreferredSize(this.model.getPixelLengthFor(this.model.isPlist() ? ColumnDefinition.SUSPEND_TIME : ColumnDefinition.SUSPEND_TIME_AVG), 40);
            this.sus.setToolTip((IFigure)new Label(this.model.getTooltipFor(this.model.isPlist() ? ColumnDefinition.SUSPEND_TIME : ColumnDefinition.SUSPEND_TIME_AVG)));
            this.sus.setAlpha(150);
            this.add((IFigure)this.sus);
            this.susLabel = new Label(this.model.getLabelFor(this.model.isPlist() ? ColumnDefinition.SUSPEND_TIME : ColumnDefinition.SUSPEND_TIME_AVG));
            this.susLabel.setToolTip((IFigure)new Label(this.susLabel.getText()));
            this.susLabel.setLabelAlignment(1);
            this.add((IFigure)this.susLabel);
            this.dispatch = new PolygonShape();
            int[] nArray2 = new int[12];
            nArray2[2] = this.model.getPixelLengthFor(this.model.isPlist() ? ColumnDefinition.DISPATCH_TIME : ColumnDefinition.DISPATCH_TIME_AVG);
            nArray2[4] = this.model.getPixelLengthFor(this.model.isPlist() ? ColumnDefinition.DISPATCH_TIME : ColumnDefinition.DISPATCH_TIME_AVG);
            nArray2[5] = 20;
            nArray2[6] = this.model.getPixelLengthFor(this.model.isPlist() ? ColumnDefinition.DISPATCH_TIME : ColumnDefinition.DISPATCH_TIME_AVG) - this.model.getPixelLengthFor(this.model.isPlist() ? ColumnDefinition.CPU_TIME : ColumnDefinition.CPU_TIME_AVG);
            nArray2[7] = 20;
            nArray2[8] = this.model.getPixelLengthFor(this.model.isPlist() ? ColumnDefinition.DISPATCH_TIME : ColumnDefinition.DISPATCH_TIME_AVG) - this.model.getPixelLengthFor(this.model.isPlist() ? ColumnDefinition.CPU_TIME : ColumnDefinition.CPU_TIME_AVG);
            nArray2[9] = 40;
            nArray2[11] = 40;
            ((PolygonShape)this.dispatch).setPoints(new PointList(nArray2));
            this.dispatch.setForegroundColor(ColorConstants.darkGray);
            this.dispatch.setBackgroundColor(Column.getFor(this.model.isPlist() ? ColumnDefinition.DISPATCH_TIME : ColumnDefinition.DISPATCH_TIME_AVG).getColor());
            this.dispatch.setBorder((Border)new SimpleRaisedBorder());
            this.dispatch.setPreferredSize(this.model.getPixelLengthFor(this.model.isPlist() ? ColumnDefinition.DISPATCH_TIME : ColumnDefinition.DISPATCH_TIME_AVG), 40);
            this.dispatch.setToolTip((IFigure)new Label(this.model.getTooltipFor(this.model.isPlist() ? ColumnDefinition.DISPATCH_TIME : ColumnDefinition.DISPATCH_TIME_AVG)));
            this.dispatch.setAlpha(150);
            this.add((IFigure)this.dispatch);
            this.dispatchLabel = new Label(this.model.getLabelFor(this.model.isPlist() ? ColumnDefinition.DISPATCH_TIME : ColumnDefinition.DISPATCH_TIME_AVG));
            this.dispatchLabel.setToolTip((IFigure)new Label(this.dispatchLabel.getText()));
            this.dispatchLabel.setLabelAlignment(1);
            this.add((IFigure)this.dispatchLabel);
            this.disp = new RectangleFigure();
            this.disp.setBackgroundColor(Column.getFor(this.model.isPlist() ? ColumnDefinition.DISPWAIT_TIME : ColumnDefinition.DISPWAIT_TIME_AVG).getColor());
            this.disp.setForegroundColor(ColorConstants.darkGray);
            this.disp.setBorder((Border)new SimpleRaisedBorder());
            this.disp.setPreferredSize(this.model.getPixelLengthFor(this.model.isPlist() ? ColumnDefinition.DISPWAIT_TIME : ColumnDefinition.DISPWAIT_TIME_AVG), 20);
            this.disp.setToolTip((IFigure)new Label(this.model.getTooltipFor(this.model.isPlist() ? ColumnDefinition.DISPWAIT_TIME : ColumnDefinition.DISPWAIT_TIME_AVG)));
            this.disp.setAlpha(150);
            this.add((IFigure)this.disp);
            this.dispLabel = new Label(this.model.getLabelFor(this.model.isPlist() ? ColumnDefinition.DISPWAIT_TIME : ColumnDefinition.DISPWAIT_TIME_AVG));
            this.dispLabel.setToolTip((IFigure)new Label(this.dispLabel.getText()));
            this.dispLabel.setLabelAlignment(1);
            this.add((IFigure)this.dispLabel);
            this.cpu = new RectangleFigure();
            this.cpu.setBackgroundColor(Column.getFor(this.model.isPlist() ? ColumnDefinition.CPU_TIME : ColumnDefinition.CPU_TIME_AVG).getColor());
            this.cpu.setForegroundColor(ColorConstants.darkGray);
            this.cpu.setBorder((Border)new SimpleRaisedBorder());
            this.cpu.setPreferredSize(this.model.getPixelLengthFor(this.model.isPlist() ? ColumnDefinition.CPU_TIME : ColumnDefinition.CPU_TIME_AVG), 20);
            this.cpu.setToolTip((IFigure)new Label(this.model.getTooltipFor(this.model.isPlist() ? ColumnDefinition.CPU_TIME : ColumnDefinition.CPU_TIME_AVG)));
            this.cpu.setAlpha(150);
            this.add((IFigure)this.cpu);
            this.cpuLabel = new Label(this.model.getLabelFor(this.model.isPlist() ? ColumnDefinition.CPU_TIME : ColumnDefinition.CPU_TIME_AVG));
            this.cpuLabel.setToolTip((IFigure)new Label(this.cpuLabel.getText()));
            this.cpuLabel.setLabelAlignment(1);
            this.add((IFigure)this.cpuLabel);
        } else {
            this.oaLabel = new Label(Messages.getString("PiePage.label.dataissues"));
            this.oaLabel.setLabelAlignment(1);
            this.add((IFigure)this.oaLabel);
        }
        this.accessibleMessage = this.model.getAccessibleMessage();
        debug.exit("setModel");
    }

    public void paintFigure(Graphics g) {
        debug.enter("paintFigure");
        super.paintFigure(g);
        if (this.model.isReliable()) {
            int x;
            Point labelPoint2;
            Point labelPoint1;
            int dimnStartY = 15;
            int barStartY = 70;
            g.setForegroundColor(this.hasFocus ? ColorConstants.black : ColorConstants.gray);
            g.setBackgroundColor(this.hasFocus ? ColorConstants.black : ColorConstants.gray);
            g.drawLine(10, 69, this.oaWidth + 10, 69);
            g.drawLine(9, 69, 9, 109);
            Point position = new Point(10, barStartY);
            if (this.oaLabel.getText().length() > 0) {
                this.oaLabel.setLabelAlignment(2);
                this.oaLabel.setBounds(new Rectangle(new Point(10, 0), new Point(this.oaWidth + 10, 15)));
                g.drawLine(new Point(9, dimnStartY - 5), new Point(9, barStartY));
                g.drawLine(new Point(10 + this.oaWidth - 1, dimnStartY - 5), new Point(10 + this.oaWidth - 1, barStartY));
                g.fillPolygon(new int[]{10, dimnStartY, 13, dimnStartY - 3, 13, dimnStartY + 3});
                labelPoint1 = new Point(10 + this.oaWidth + 5, dimnStartY);
                g.drawLine(new Point(10, dimnStartY), labelPoint1);
                g.fillPolygon(new int[]{10 + this.oaWidth - 1, dimnStartY, 10 + this.oaWidth - 4, dimnStartY - 3, 10 + this.oaWidth - 4, dimnStartY + 3});
                labelPoint1.y -= 10;
                labelPoint1.x += 5;
                labelPoint2 = new Point(labelPoint1);
                labelPoint2.y += 20;
                labelPoint2.x += this.getBounds().width - labelPoint1.x;
                dimnStartY += 20;
                barStartY += 20;
            }
            if (this.susLabel.getText().length() > 0) {
                x = this.sus.getPreferredSize().width - 1;
                g.drawLine(new Point(10 + x, dimnStartY - 5), new Point(10 + x, barStartY));
                g.fillPolygon(new int[]{10, dimnStartY, 13, dimnStartY - 3, 13, dimnStartY + 3});
                labelPoint1 = new Point(10 + this.oaWidth + 5, dimnStartY);
                g.setLineStyle(2);
                g.drawLine(new Point(10, dimnStartY), labelPoint1);
                g.setLineStyle(1);
                labelPoint1.x = 10 + x;
                g.drawLine(new Point(10, dimnStartY), labelPoint1);
                g.fillPolygon(new int[]{10 + x - 1, dimnStartY, 10 + x - 4, dimnStartY - 3, 10 + x - 4, dimnStartY + 3});
                labelPoint1.x = 10 + this.oaWidth + 10;
                labelPoint1.y -= 8;
                g.drawImage(Column.getFor(ColumnDefinition.SUSPEND_TIME_AVG).getImage(), labelPoint1);
                labelPoint1.y -= 2;
                labelPoint1.x += 20;
                labelPoint2 = new Point(labelPoint1);
                labelPoint2.y += 20;
                labelPoint2.x += this.getBounds().width - labelPoint1.x;
                this.susLabel.setBounds(new Rectangle(labelPoint1, labelPoint2));
                dimnStartY += 20;
                barStartY += 20;
            }
            if (this.dispLabel.getText().length() > 0) {
                x = this.disp.getPreferredSize().width;
                g.drawLine(new Point(10 + x, dimnStartY - 5), new Point(10 + x, barStartY));
                g.fillPolygon(new int[]{9, dimnStartY, 13, dimnStartY - 3, 13, dimnStartY + 3});
                labelPoint1 = new Point(10 + this.oaWidth + 5, dimnStartY);
                g.setLineStyle(2);
                g.drawLine(new Point(10, dimnStartY), labelPoint1);
                g.setLineStyle(1);
                labelPoint1.x = 10 + x;
                g.drawLine(new Point(10, dimnStartY), labelPoint1);
                g.fillPolygon(new int[]{10 + x - 1, dimnStartY, 10 + x - 4, dimnStartY - 3, 10 + x - 4, dimnStartY + 3});
                labelPoint1.x = 10 + this.oaWidth + 10;
                labelPoint1.y -= 8;
                g.drawImage(Column.getFor(ColumnDefinition.DISPWAIT_TIME_AVG).getImage(), labelPoint1);
                labelPoint1.y -= 2;
                labelPoint1.x += 20;
                labelPoint2 = new Point(labelPoint1);
                labelPoint2.y += 20;
                labelPoint2.x += this.getBounds().width - labelPoint1.x;
                this.dispLabel.setBounds(new Rectangle(labelPoint1, labelPoint2));
                dimnStartY += 20;
                barStartY += 20;
            }
            this.sus.setBounds(new Rectangle(position, this.sus.getPreferredSize()));
            position.x = 10 + this.oaWidth - this.dispatch.getPreferredSize().width;
            this.dispatch.setBounds(new Rectangle(position, this.dispatch.getPreferredSize()));
            if (this.dispatchLabel.getText().length() > 0) {
                labelPoint1 = new Point(10 + this.oaWidth + 10, position.y);
                labelPoint1.y += 2;
                g.drawImage(Column.getFor(ColumnDefinition.DISPATCH_TIME_AVG).getImage(), labelPoint1);
                labelPoint1.y -= 2;
                labelPoint1.x += 20;
                labelPoint2 = new Point(labelPoint1);
                labelPoint2.y += 20;
                labelPoint2.x += this.getBounds().width - labelPoint1.x;
                this.dispatchLabel.setBounds(new Rectangle(labelPoint1, labelPoint2));
                g.drawLine(new Point(10 + this.oaWidth, position.y + 10), new Point(10 + this.oaWidth + 5, position.y + 10));
            }
            position.y += 20;
            position.x = 10;
            this.disp.setBounds(new Rectangle(position, this.disp.getPreferredSize()));
            position.x = 10 + this.oaWidth - this.cpu.getPreferredSize().width;
            this.cpu.setBounds(new Rectangle(position, this.cpu.getPreferredSize()));
            if (this.cpuLabel != null && this.cpuLabel.getText().length() > 0) {
                g.drawLine(new Point(10 + this.oaWidth, position.y + 10), new Point(10 + this.oaWidth + 5, position.y + 10));
                labelPoint1 = new Point(10 + this.oaWidth + 10, position.y);
                labelPoint1.y += 2;
                g.drawImage(Column.getFor(ColumnDefinition.CPU_TIME_AVG).getImage(), labelPoint1);
                labelPoint1.y -= 2;
                labelPoint1.x += 20;
                labelPoint2 = new Point(labelPoint1);
                labelPoint2.y += 20;
                labelPoint2.x += this.getBounds().width - labelPoint1.x;
                this.cpuLabel.setBounds(new Rectangle(labelPoint1, labelPoint2));
            }
        } else if (this.oaLabel.getText().length() > 0) {
            this.oaLabel.setLabelAlignment(2);
            this.oaLabel.setBounds(new Rectangle(new Point(10, 0), new Point(this.oaWidth + 10, 15)));
        }
        debug.exit("paintFigure");
    }
}

