/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.figures;

import com.ibm.cics.pa.model.Histogram;
import com.ibm.cics.pa.model.definitions.SortedCombinedHistogramLineSpecificDefinitions;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.figures.ChartSelectable;
import com.ibm.cics.pa.ui.figures.CommonHistogram;
import com.ibm.cics.pa.ui.views.ChartView;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class CombinedLineHistogram
extends CommonHistogram {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    protected CombinedLineHistogram histogram = this;
    protected CountFigure[] figures;
    private int maxVal = 0;

    public CombinedLineHistogram(ChartView viewPart, Histogram model, FigureCanvas figureCanvas) {
        super(viewPart, model, figureCanvas);
        SortedCombinedHistogramLineSpecificDefinitions defn = (SortedCombinedHistogramLineSpecificDefinitions)model.getChartReference().getSpecificType();
        int columnPosition = model.getDataProvider().getColumnPosition(defn.getSortColumn());
        this.figures = new CountFigure[model.getPrimaryColumns().size()];
        int ctr = 0;
        for (ChartSelectable column : model.getPrimaryColumns()) {
            Object value = column.getDataRow()[columnPosition];
            if (value instanceof Number) {
                if (((Number)value).intValue() > this.maxVal) {
                    this.maxVal = ((Number)value).intValue();
                }
                this.figures[ctr] = new CountFigure(column, ((Number)value).intValue());
                this.add((IFigure)this.figures[ctr]);
            } else {
                logger.logp(Level.WARNING, CombinedLineHistogram.class.getName(), "CombinedLineHistogram", "Not a number");
            }
            ++ctr;
        }
        this.overlay = true;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.overlay) {
            org.eclipse.swt.graphics.Rectangle viewingClientArea = this.canvas.getClientArea();
            double scalingFactor = (double)(viewingClientArea.height - this.getTopMargin() - this.getBottomMargin() - 16) / new Double(this.maxVal) * (double)this.zoomFactor;
            int ctr = 0;
            int previousX = -1;
            int previousY = -1;
            g.setBackgroundColor(ColorConstants.lightBlue);
            CountFigure[] countFigureArray = this.figures;
            int n = this.figures.length;
            int n2 = 0;
            while (n2 < n) {
                CountFigure chgmodeFigure = countFigureArray[n2];
                int x = ctr * this.model.incrementWidth + this.getLeftMargin() + this.model.barWidth / 2 - 8;
                int y = this.preferrerdPixelHeight - this.bottomMargin - 16 - Math.round(Math.round(scalingFactor * (double)chgmodeFigure.getValue().intValue()));
                int width = 32;
                int height = 32;
                Rectangle bounds = new Rectangle(x, y, width, height);
                this.setConstraint((IFigure)chgmodeFigure, bounds);
                if (ctr > 0 && chgmodeFigure.getValue() > 0) {
                    g.setAlpha(100);
                    g.setLineStyle(3);
                    g.setForegroundColor(ColorConstants.blue);
                    g.drawLine(previousX, previousY, x, y + 8);
                }
                previousX = x + 16;
                previousY = y + 8;
                ++ctr;
                ++n2;
            }
        }
    }

    @Override
    public Button[] getAdditionalButtons(Canvas basicSWT) {
        Button button = new Button((Composite)basicSWT, 2);
        button.setImage(this.getCounterIcon());
        button.setToolTipText(Messages.getString("CombinedLineHistogram.Toggle"));
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CombinedLineHistogram.this.overlay = !CombinedLineHistogram.this.overlay;
                CombinedLineHistogram.this.histogram.repaint();
            }

            public void widgetSelected(SelectionEvent e) {
                CombinedLineHistogram.this.overlay = !CombinedLineHistogram.this.overlay;
                CombinedLineHistogram.this.histogram.repaint();
            }
        });
        button.setSelection(this.overlay);
        return new Button[]{button};
    }

    public class CountFigure
    extends Figure {
        private int value;
        private String ref;
        private ChartSelectable column;

        public CountFigure(ChartSelectable column, int value) {
            this.column = column;
            this.ref = column.getLabel();
            this.value = value;
            this.setToolTip((IFigure)new Label(this.toString()));
        }

        public ChartSelectable getSelectableColumn() {
            return this.column;
        }

        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.ref) + ": " + this.value + ' ' + Messages.getString("CombinedLineHistogram.Changemodes");
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (CombinedLineHistogram.this.overlay && this.value > 0) {
                Rectangle clientArea = this.getClientArea();
                g.drawImage(CombinedLineHistogram.this.getCounterIcon(), clientArea.x, clientArea.y);
                g.setForegroundColor(ColorConstants.black);
                g.drawString(this.getValue().toString(), clientArea.x, clientArea.y + clientArea.height / 2);
            }
        }
    }
}

