/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.dialogs;

import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionState;
import com.ibm.cics.eclipse.common.ui.TextInput;
import com.ibm.cics.pa.model.DateCaveat;
import com.ibm.cics.pa.model.PostRangeDateCaveat;
import com.ibm.cics.pa.model.PreRangeDateCaveat;
import com.ibm.cics.pa.model.RangeDateCaveat;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.PluginConstants;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class TimelineAssistDialog
extends SelectionStatusDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String BEFORE = Messages.getString("TimelineAssistDialog.4");
    private static final String AFTER = Messages.getString("TimelineAssistDialog.5");
    IEclipsePreferences pluginPreferences = Activator.getDefault().getPluginInstancePreferences();
    private Composite afterGroup;
    private Composite beforeGroup;
    Calendar afterCalendar;
    Calendar beforeCalendar;
    Button beforeButton;
    Button afterButton;
    Button autoButton;
    DateTime afterCalendarComposite;
    DateTime afterDateComposite;
    DateTime afterTimeComposite;
    DateTime beforeCalendarComposite;
    DateTime beforeDateComposite;
    DateTime beforeTimeComposite;
    private String id = "";
    private String defaultInstance = null;
    private Text containerText;
    private boolean sourceRequired = false;
    private static TimelineAssistDialog instance;
    private boolean isInitialized = false;
    private DateCaveat dateCaveat = null;
    Combo periodComboDropDown = null;
    private Collection<DateChangeListener> listeners = new ArrayList<DateChangeListener>();

    private TimelineAssistDialog() {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        long alltime;
        Image image = Activator.getDefault().getImageDescriptor(Activator.IMGD_DATE).createImage();
        this.setTitle(Messages.getString("TimelineAssistDialog.6"));
        this.setImage(image);
        this.afterCalendar = Calendar.getInstance();
        this.afterCalendar.add(6, -1);
        this.beforeCalendar = Calendar.getInstance();
        if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), String.valueOf(this.id) + "AFTER_CHECK", false, null)) {
            alltime = Platform.getPreferencesService().getLong(Activator.getDefault().getBundle().getSymbolicName(), String.valueOf(this.id) + PluginConstants.AFTER_CALENDAR, 0L, null);
            if (alltime > 0L) {
                this.afterCalendar.setTimeInMillis(alltime);
            }
            this.isInitialized = true;
        }
        if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), String.valueOf(this.id) + "BEFORE_CHECK", false, null)) {
            alltime = Platform.getPreferencesService().getLong(Activator.getDefault().getBundle().getSymbolicName(), String.valueOf(this.id) + PluginConstants.BEFORE_CALENDAR, 0L, null);
            if (alltime > 0L) {
                this.beforeCalendar.setTimeInMillis(alltime);
            }
            this.isInitialized = true;
        }
        this.dateCaveat = DateCaveat.createRangeDateCaveat(Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), String.valueOf(this.id) + "AFTER_CHECK", false, null) ? this.afterCalendar.getTime() : null, Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), String.valueOf(this.id) + "BEFORE_CHECK", false, null) ? this.beforeCalendar.getTime() : null);
        this.initialiseDates();
    }

    public static TimelineAssistDialog getInstance() {
        if (instance == null) {
            instance = new TimelineAssistDialog();
        }
        return instance;
    }

    protected void computeResult() {
        ArrayList<Calendar> calendars = new ArrayList<Calendar>();
        calendars.add(this.afterButton.getSelection() ? this.afterCalendar : null);
        calendars.add(this.beforeButton.getSelection() ? this.beforeCalendar : null);
        this.isInitialized = true;
        this.dateCaveat = DateCaveat.createRangeDateCaveat(calendars.get(0) == null ? null : ((Calendar)calendars.get(0)).getTime(), calendars.get(1) == null ? null : ((Calendar)calendars.get(1)).getTime());
        this.persistDateCaveat();
        if (!this.autoButton.getSelection()) {
            this.pluginPreferences.putInt("com.ibm.cics.pa.ui.overview", 0);
        } else if (this.periodComboDropDown.getText().equals(Messages.getString("DateDialog.yesterday"))) {
            this.pluginPreferences.putInt("com.ibm.cics.pa.ui.overview", 6);
        } else if (this.periodComboDropDown.getText().equals(Messages.getString("DateDialog.week"))) {
            this.pluginPreferences.putInt("com.ibm.cics.pa.ui.overview", 4);
        } else if (this.periodComboDropDown.getText().equals(Messages.getString("DateDialog.month"))) {
            this.pluginPreferences.putInt("com.ibm.cics.pa.ui.overview", 2);
        } else if (this.periodComboDropDown.getText().equals(Messages.getString("DateDialog.quarter"))) {
            this.pluginPreferences.putInt("com.ibm.cics.pa.ui.overview", 3);
        } else if (this.periodComboDropDown.getText().equals(Messages.getString("DateDialog.year"))) {
            this.pluginPreferences.putInt("com.ibm.cics.pa.ui.overview", 1);
        }
        this.setResult(calendars);
    }

    private void persistDateCaveat() {
        if (this.dateCaveat instanceof PostRangeDateCaveat || this.dateCaveat instanceof RangeDateCaveat) {
            this.pluginPreferences.putBoolean(String.valueOf(this.id) + "AFTER_CHECK", true);
            this.pluginPreferences.putLong(String.valueOf(this.id) + PluginConstants.AFTER_CALENDAR, this.dateCaveat.getStartTimeInMillis());
        } else {
            this.pluginPreferences.putBoolean(String.valueOf(this.id) + "AFTER_CHECK", false);
        }
        if (this.dateCaveat instanceof PreRangeDateCaveat || this.dateCaveat instanceof RangeDateCaveat) {
            this.pluginPreferences.putBoolean(String.valueOf(this.id) + "BEFORE_CHECK", true);
            this.pluginPreferences.putLong(String.valueOf(this.id) + PluginConstants.BEFORE_CALENDAR, this.dateCaveat.getEndTimeInMillis());
        } else {
            this.pluginPreferences.putBoolean(String.valueOf(this.id) + "BEFORE_CHECK", false);
        }
    }

    public Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.sourceRequired && (this.defaultInstance == null || this.defaultInstance.length() == 0)) {
            this.getOkButton().setEnabled(false);
            this.updateStatus((IStatus)new Status(4, "com.ibm.cics.pa.ui", Messages.getString("TimelineAssistDialog.7")));
            this.setMessage(Messages.getString("TimelineAssistDialog.7"));
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpContextId());
        return control;
    }

    public Composite createDialogArea(Composite parent) {
        super.createDialogArea(parent);
        Group automateComposite = new Group(parent, 0);
        automateComposite.setText(Messages.getString("Timeline.Restrict.automate"));
        GridLayout automatedLayout = new GridLayout(2, false);
        GridData automatedData = new GridData(4, 4, true, false);
        automateComposite.setLayout((Layout)automatedLayout);
        automateComposite.setLayoutData((Object)automatedData);
        this.autoButton = new Button((Composite)automateComposite, 32);
        this.autoButton.setText(Messages.getString("Timeline.Restrict.date"));
        int dateChoice = Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.pa.ui.overview", 0, null);
        this.autoButton.setSelection(dateChoice > 0);
        this.autoButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.periodComboDropDown = new Combo((Composite)automateComposite, 2060);
        this.periodComboDropDown.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.periodComboDropDown.setItems(new String[]{Messages.getString("DateDialog.yesterday"), Messages.getString("DateDialog.week"), Messages.getString("DateDialog.month"), Messages.getString("DateDialog.quarter"), Messages.getString("DateDialog.year")});
        if (dateChoice == 6) {
            this.periodComboDropDown.setText(Messages.getString("DateDialog.yesterday"));
        } else if (dateChoice == 4) {
            this.periodComboDropDown.setText(Messages.getString("DateDialog.week"));
        } else if (dateChoice == 2) {
            this.periodComboDropDown.setText(Messages.getString("DateDialog.month"));
        } else if (dateChoice == 3) {
            this.periodComboDropDown.setText(Messages.getString("DateDialog.quarter"));
        } else if (dateChoice == 1) {
            this.periodComboDropDown.setText(Messages.getString("DateDialog.year"));
        } else {
            this.periodComboDropDown.setText(Messages.getString("DateDialog.yesterday"));
        }
        this.periodComboDropDown.setEnabled(dateChoice > 0);
        this.periodComboDropDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TimelineAssistDialog.this.autoButton.getSelection()) {
                    TimelineAssistDialog.this.pluginPreferences.putInt("com.ibm.cics.pa.ui.overview", 0);
                } else if (TimelineAssistDialog.this.periodComboDropDown.getText().equals(Messages.getString("DateDialog.yesterday"))) {
                    TimelineAssistDialog.this.pluginPreferences.putInt("com.ibm.cics.pa.ui.overview", 6);
                } else if (TimelineAssistDialog.this.periodComboDropDown.getText().equals(Messages.getString("DateDialog.week"))) {
                    TimelineAssistDialog.this.pluginPreferences.putInt("com.ibm.cics.pa.ui.overview", 4);
                } else if (TimelineAssistDialog.this.periodComboDropDown.getText().equals(Messages.getString("DateDialog.month"))) {
                    TimelineAssistDialog.this.pluginPreferences.putInt("com.ibm.cics.pa.ui.overview", 2);
                } else if (TimelineAssistDialog.this.periodComboDropDown.getText().equals(Messages.getString("DateDialog.quarter"))) {
                    TimelineAssistDialog.this.pluginPreferences.putInt("com.ibm.cics.pa.ui.overview", 3);
                } else if (TimelineAssistDialog.this.periodComboDropDown.getText().equals(Messages.getString("DateDialog.year"))) {
                    TimelineAssistDialog.this.pluginPreferences.putInt("com.ibm.cics.pa.ui.overview", 1);
                }
                TimelineAssistDialog.this.initialiseDates();
                TimelineAssistDialog.this.initialiseVisuals();
                TimelineAssistDialog.this.refresh();
            }
        });
        this.autoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimelineAssistDialog.this.periodComboDropDown.setEnabled(TimelineAssistDialog.this.autoButton.getSelection());
                if (!TimelineAssistDialog.this.autoButton.getSelection()) {
                    TimelineAssistDialog.this.pluginPreferences.putInt("com.ibm.cics.pa.ui.overview", 0);
                } else if (TimelineAssistDialog.this.periodComboDropDown.getText().equals(Messages.getString("DateDialog.yesterday"))) {
                    TimelineAssistDialog.this.pluginPreferences.putInt("com.ibm.cics.pa.ui.overview", 6);
                } else if (TimelineAssistDialog.this.periodComboDropDown.getText().equals(Messages.getString("DateDialog.week"))) {
                    TimelineAssistDialog.this.pluginPreferences.putInt("com.ibm.cics.pa.ui.overview", 4);
                } else if (TimelineAssistDialog.this.periodComboDropDown.getText().equals(Messages.getString("DateDialog.month"))) {
                    TimelineAssistDialog.this.pluginPreferences.putInt("com.ibm.cics.pa.ui.overview", 2);
                } else if (TimelineAssistDialog.this.periodComboDropDown.getText().equals(Messages.getString("DateDialog.quarter"))) {
                    TimelineAssistDialog.this.pluginPreferences.putInt("com.ibm.cics.pa.ui.overview", 3);
                } else if (TimelineAssistDialog.this.periodComboDropDown.getText().equals(Messages.getString("DateDialog.year"))) {
                    TimelineAssistDialog.this.pluginPreferences.putInt("com.ibm.cics.pa.ui.overview", 1);
                }
                TimelineAssistDialog.this.initialiseDates();
                TimelineAssistDialog.this.initialiseVisuals();
                TimelineAssistDialog.this.refresh();
            }
        });
        Composite occursComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        occursComposite.setLayout((Layout)gridLayout);
        if (this.sourceRequired) {
            Label label = new Label(occursComposite, 0);
            label.setText(Messages.getString("TimelineAssistDialog.9"));
            this.containerText = new Text(occursComposite, 2052);
            TextInput.setAccessibleLabel((Text)this.containerText, (Label)label);
            GridData gd = new GridData(768);
            this.containerText.setLayoutData((Object)gd);
            this.defaultInstance = this.getLastPAConnectionId();
            this.containerText.setEnabled(false);
        }
        this.afterButton = new Button(occursComposite, 32);
        this.afterButton.setData((Object)AFTER);
        this.afterButton.setText(AFTER);
        this.beforeButton = new Button(occursComposite, 32);
        this.beforeButton.setData((Object)BEFORE);
        this.beforeButton.setText(BEFORE);
        this.beforeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TimelineAssistDialog.this.setBeforeGroupEnabled(TimelineAssistDialog.this.beforeButton.isEnabled() && ((Button)e.getSource()).getSelection() && !TimelineAssistDialog.this.autoButton.getSelection());
                TimelineAssistDialog.this.refresh();
            }

            public void widgetSelected(SelectionEvent e) {
                TimelineAssistDialog.this.setBeforeGroupEnabled(TimelineAssistDialog.this.beforeButton.isEnabled() && ((Button)e.getSource()).getSelection() && !TimelineAssistDialog.this.autoButton.getSelection());
                TimelineAssistDialog.this.refresh();
            }
        });
        this.afterButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TimelineAssistDialog.this.setAfterGroupEnabled(TimelineAssistDialog.this.afterButton.isEnabled() && ((Button)e.getSource()).getSelection() && !TimelineAssistDialog.this.autoButton.getSelection());
                TimelineAssistDialog.this.refresh();
            }

            public void widgetSelected(SelectionEvent e) {
                TimelineAssistDialog.this.setAfterGroupEnabled(TimelineAssistDialog.this.afterButton.isEnabled() && ((Button)e.getSource()).getSelection() && !TimelineAssistDialog.this.autoButton.getSelection());
                TimelineAssistDialog.this.refresh();
            }
        });
        GridData data2 = new GridData(0x1000000, 128, false, true);
        data2.widthHint = 110;
        this.afterGroup = new Group(occursComposite, 0);
        this.beforeGroup = new Group(occursComposite, 0);
        gridLayout = new GridLayout(1, false);
        this.afterGroup.setLayout((Layout)gridLayout);
        this.beforeGroup.setLayout((Layout)gridLayout);
        this.afterCalendarComposite = new DateTime(this.afterGroup, 3072);
        this.afterCalendarComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimelineAssistDialog.this.afterCalendar.set(1, TimelineAssistDialog.this.afterCalendarComposite.getYear());
                TimelineAssistDialog.this.afterCalendar.set(2, TimelineAssistDialog.this.afterCalendarComposite.getMonth());
                TimelineAssistDialog.this.afterCalendar.set(5, TimelineAssistDialog.this.afterCalendarComposite.getDay());
                TimelineAssistDialog.this.refresh();
            }
        });
        this.afterCalendarComposite.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.getString("Jaws.inaccessible");
            }
        });
        Composite afterDateTimeComposite = new Composite(this.afterGroup, 0);
        gridLayout = new GridLayout(2, false);
        afterDateTimeComposite.setLayout((Layout)gridLayout);
        GridData data = new GridData(0x1000000, 4, true, true);
        afterDateTimeComposite.setLayoutData((Object)data);
        this.afterDateComposite = new DateTime(afterDateTimeComposite, 2080);
        this.afterDateComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimelineAssistDialog.this.afterCalendar.set(1, TimelineAssistDialog.this.afterDateComposite.getYear());
                TimelineAssistDialog.this.afterCalendar.set(2, TimelineAssistDialog.this.afterDateComposite.getMonth());
                TimelineAssistDialog.this.afterCalendar.set(5, TimelineAssistDialog.this.afterDateComposite.getDay());
                TimelineAssistDialog.this.refresh();
            }
        });
        this.afterDateComposite.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.getString("Jaws.date.after");
            }
        });
        this.afterDateComposite.setLayoutData((Object)data2);
        this.afterTimeComposite = new DateTime(afterDateTimeComposite, 2176);
        this.afterTimeComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimelineAssistDialog.this.afterCalendar.set(11, TimelineAssistDialog.this.afterTimeComposite.getHours());
                TimelineAssistDialog.this.afterCalendar.set(12, TimelineAssistDialog.this.afterTimeComposite.getMinutes());
                TimelineAssistDialog.this.afterCalendar.set(13, TimelineAssistDialog.this.afterTimeComposite.getSeconds());
                TimelineAssistDialog.this.refresh();
            }
        });
        this.afterTimeComposite.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.getString("Jaws.time.after");
            }
        });
        this.afterTimeComposite.setLayoutData((Object)data2);
        this.beforeCalendarComposite = new DateTime(this.beforeGroup, 3072);
        this.beforeCalendarComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimelineAssistDialog.this.beforeCalendar.set(1, TimelineAssistDialog.this.beforeCalendarComposite.getYear());
                TimelineAssistDialog.this.beforeCalendar.set(2, TimelineAssistDialog.this.beforeCalendarComposite.getMonth());
                TimelineAssistDialog.this.beforeCalendar.set(5, TimelineAssistDialog.this.beforeCalendarComposite.getDay());
                TimelineAssistDialog.this.refresh();
            }
        });
        this.beforeCalendarComposite.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.getString("Jaws.inaccessible");
            }
        });
        Composite beforeDateTimeComposite = new Composite(this.beforeGroup, 0);
        gridLayout = new GridLayout(2, false);
        beforeDateTimeComposite.setLayout((Layout)gridLayout);
        data = new GridData(0x1000000, 4, true, true);
        beforeDateTimeComposite.setLayoutData((Object)data);
        this.beforeDateComposite = new DateTime(beforeDateTimeComposite, 2080);
        this.beforeDateComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimelineAssistDialog.this.beforeCalendar.set(1, TimelineAssistDialog.this.beforeDateComposite.getYear());
                TimelineAssistDialog.this.beforeCalendar.set(2, TimelineAssistDialog.this.beforeDateComposite.getMonth());
                TimelineAssistDialog.this.beforeCalendar.set(5, TimelineAssistDialog.this.beforeDateComposite.getDay());
                TimelineAssistDialog.this.refresh();
            }
        });
        this.beforeDateComposite.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.getString("Jaws.date.before");
            }
        });
        this.beforeDateComposite.setLayoutData((Object)data2);
        this.beforeTimeComposite = new DateTime(beforeDateTimeComposite, 2176);
        this.beforeTimeComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimelineAssistDialog.this.beforeCalendar.set(11, TimelineAssistDialog.this.beforeTimeComposite.getHours());
                TimelineAssistDialog.this.beforeCalendar.set(12, TimelineAssistDialog.this.beforeTimeComposite.getMinutes());
                TimelineAssistDialog.this.beforeCalendar.set(13, TimelineAssistDialog.this.beforeTimeComposite.getSeconds());
                TimelineAssistDialog.this.refresh();
            }
        });
        this.beforeTimeComposite.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.getString("Jaws.time.before");
            }
        });
        this.beforeTimeComposite.setLayoutData((Object)data2);
        this.setStatusLineAboveButtons(true);
        this.initialiseVisuals();
        this.refresh();
        return parent;
    }

    private String getLastPAConnectionId() {
        IConnectionState connectionState = ConnectionsPlugin.getDefault().getConnectionService().getConnectionState("com.ibm.cics.pa.connection");
        if (connectionState.getID() != null) {
            return connectionState.getID();
        }
        return "";
    }

    void initialiseVisuals() {
        this.beforeButton.setEnabled(!this.autoButton.getSelection());
        this.afterButton.setEnabled(!this.autoButton.getSelection());
        if (this.dateCaveat instanceof PostRangeDateCaveat || this.dateCaveat instanceof RangeDateCaveat) {
            this.afterCalendar.setTimeInMillis(this.dateCaveat.getStartTimeInMillis());
            this.afterButton.setSelection(true);
        }
        if (this.dateCaveat instanceof PreRangeDateCaveat || this.dateCaveat instanceof RangeDateCaveat) {
            this.beforeCalendar.setTimeInMillis(this.dateCaveat.getEndTimeInMillis());
            this.beforeButton.setSelection(true);
        }
        if (!this.sourceRequired || this.defaultInstance != null && this.defaultInstance.length() > 0) {
            if (this.containerText != null) {
                this.containerText.setText(this.defaultInstance);
            }
            this.setAfterGroupEnabled(this.afterButton.getSelection() && !this.autoButton.getSelection());
            this.setBeforeGroupEnabled(this.beforeButton.getSelection() && !this.autoButton.getSelection());
        } else {
            if (this.containerText != null) {
                this.containerText.setText(Messages.getString("TimelineAssistDialog.10"));
            }
            this.beforeButton.setEnabled(false);
            this.afterButton.setEnabled(false);
            this.setAfterGroupEnabled(false);
            this.setBeforeGroupEnabled(false);
        }
        this.setHelpAvailable(true);
    }

    void refresh() {
        if (this.afterCalendar == null) {
            this.initialiseVisuals();
        }
        this.afterCalendarComposite.setDate(this.afterCalendar.get(1), this.afterCalendar.get(2), this.afterCalendar.get(5));
        this.afterTimeComposite.setTime(this.afterCalendar.get(11), this.afterCalendar.get(12), this.afterCalendar.get(13));
        this.afterDateComposite.setDate(this.afterCalendar.get(1), this.afterCalendar.get(2), this.afterCalendar.get(5));
        this.beforeCalendarComposite.setDate(this.beforeCalendar.get(1), this.beforeCalendar.get(2), this.beforeCalendar.get(5));
        this.beforeTimeComposite.setTime(this.beforeCalendar.get(11), this.beforeCalendar.get(12), this.beforeCalendar.get(13));
        this.beforeDateComposite.setDate(this.beforeCalendar.get(1), this.beforeCalendar.get(2), this.beforeCalendar.get(5));
        if (this.afterCalendar.after(Calendar.getInstance())) {
            this.updateStatus((IStatus)new Status(4, "com.ibm.cics.pa.ui", Messages.getString("TimelineAssistDialog.11")));
        }
        if (this.beforeButton.isEnabled() && this.beforeButton.getSelection() && this.afterButton.isEnabled() && this.afterButton.getSelection()) {
            if (this.beforeCalendar.before(this.afterCalendar)) {
                this.updateStatus((IStatus)new Status(4, "com.ibm.cics.pa.ui", Messages.getString("TimelineAssistDialog.12")));
            } else {
                this.updateStatus(Status.OK_STATUS);
            }
        } else {
            this.updateStatus(Status.OK_STATUS);
        }
    }

    void setAfterGroupEnabled(boolean enabled) {
        this.afterGroup.setEnabled(enabled);
        this.afterCalendarComposite.setEnabled(enabled);
        this.afterDateComposite.setEnabled(enabled);
        this.afterTimeComposite.setEnabled(enabled);
    }

    void setBeforeGroupEnabled(boolean enabled) {
        this.beforeGroup.setEnabled(enabled);
        this.beforeCalendarComposite.setEnabled(enabled);
        this.beforeDateComposite.setEnabled(enabled);
        this.beforeTimeComposite.setEnabled(enabled);
    }

    private String getHelpContextId() {
        return "com.ibm.cics.pa.ui.date_dialog";
    }

    public boolean openDialog() {
        if (this.checkDateDialog()) {
            this.forceDateCaveat(this.dateCaveat);
            return true;
        }
        return false;
    }

    private boolean checkDateDialog() {
        final boolean[] isGoodToGo = new boolean[]{true};
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TimelineAssistDialog.this.create();
                TimelineAssistDialog.this.refresh();
                isGoodToGo[0] = TimelineAssistDialog.this.open() == 0;
            }
        });
        return isGoodToGo[0];
    }

    public DateCaveat checkTransientDateDialog() {
        if (this.checkDateDialog()) {
            return this.dateCaveat;
        }
        return null;
    }

    public boolean isInitialised() {
        return this.isInitialized;
    }

    public DateCaveat getDateCaveat() {
        return this.dateCaveat;
    }

    public void forceDateCaveat(DateCaveat caveat) {
        this.dateCaveat = caveat;
        this.persistDateCaveat();
        for (DateChangeListener listener : this.listeners) {
            listener.datesUpdated(this.dateCaveat);
        }
    }

    protected void setDateCaveat(DateCaveat caveat) {
        this.dateCaveat = caveat;
    }

    protected boolean isResizable() {
        return false;
    }

    void initialiseDates() {
        int dateChoice = Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.pa.ui.overview", 0, null);
        if (dateChoice == 1) {
            Calendar beforeCalendar = Calendar.getInstance();
            beforeCalendar.add(1, -1);
            DateCaveat caveat = DateCaveat.createRangeDateCaveat(beforeCalendar.getTime(), null);
            this.forceDateCaveat(caveat);
        } else if (dateChoice == 3) {
            Calendar beforeCalendar = Calendar.getInstance();
            beforeCalendar.add(2, -3);
            DateCaveat caveat = DateCaveat.createRangeDateCaveat(beforeCalendar.getTime(), null);
            this.forceDateCaveat(caveat);
        } else if (dateChoice == 2) {
            Calendar beforeCalendar = Calendar.getInstance();
            beforeCalendar.add(2, -1);
            DateCaveat caveat = DateCaveat.createRangeDateCaveat(beforeCalendar.getTime(), null);
            this.forceDateCaveat(caveat);
        } else if (dateChoice == 4) {
            Calendar beforeCalendar = Calendar.getInstance();
            beforeCalendar.add(4, -1);
            DateCaveat caveat = DateCaveat.createRangeDateCaveat(beforeCalendar.getTime(), null);
            this.forceDateCaveat(caveat);
        } else if (dateChoice == 6) {
            Calendar beforeCalendar = Calendar.getInstance();
            beforeCalendar.add(6, -1);
            DateCaveat caveat = DateCaveat.createRangeDateCaveat(beforeCalendar.getTime(), null);
            this.forceDateCaveat(caveat);
        }
    }

    public void addDateChangeListener(DateChangeListener part) {
        this.listeners.add(part);
    }

    public void removeDateChangeListener(DateChangeListener part) {
        this.listeners.remove(part);
    }

    public static interface DateChangeListener {
        public void datesUpdated(DateCaveat var1);
    }
}

