/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.eclipse.common.Utilities;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.pa.model.ChartType;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.PersistedChartDefinition;
import com.ibm.cics.pa.model.definitions.TableCategorisationEnum;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.builder.ResourceChangeListener;
import com.ibm.cics.pa.ui.views.ReportList;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class QueryCache {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    public static final String QUERYS_DIR = "/queries";
    public static final String PATTERN_NAME = "HST*.xml";
    public static final String DTD_NAME = "presentation.dtd";
    private static QueryCache instance = null;
    public static final String FOLDER_QUERIES = "queries";
    public static final String QUERY_FILE_EXTENSIUON = "xml";
    private Map<String, List<QueryCacheKey>> versionedKeyMap = new HashMap<String, List<QueryCacheKey>>();
    private Map<QueryCacheKey, Presentation> versionedQueryMap = new HashMap<QueryCacheKey, Presentation>();
    private Map<String, Map<ColumnReference, String>> columnsMap = new HashMap<String, Map<ColumnReference, String>>();
    private Map<String, Collection<String>> tablesMap = new HashMap<String, Collection<String>>();
    private Collection<String> intervalAliasList;

    public static QueryCache getInstance() {
        if (instance == null) {
            instance = new QueryCache();
        }
        return instance;
    }

    public static void resetInstance() {
        instance = null;
    }

    /*
     * Unable to fully structure code
     */
    private QueryCache() {
        super();
        Debug.enter((Logger)QueryCache.logger, (String)this.getClass().getName(), (String)"QueryCache()");
        mapping = ManifestRecord.getAliasMapping();
        urls = Activator.getDefault().getBundle().findEntries("/queries", "HST*.xml", true);
        if (urls != null) ** GOTO lbl19
        return;
lbl-1000:
        // 1 sources

        {
            element = (URL)urls.nextElement();
            pres = this.createPresentationFromInput(this.openContentStream(element), null);
            if (pres != null) {
                pres.applyTableMapping(mapping);
                PersistedChartDefinition.updateDefinition(pres);
                continue;
            }
            Debug.warning((Logger)QueryCache.logger, (String)this.getClass().getName(), (String)"QueryCache()", (Object)element);
lbl19:
            // 3 sources

            ** while (urls.hasMoreElements())
        }
lbl20:
        // 1 sources

        this.analyseProjects(this.getExternalProjects(), mapping);
        Debug.exit((Logger)QueryCache.logger, (String)this.getClass().getName(), (String)"QueryCache()");
    }

    private void analyseProjects(List<IProject> externalProjects, Map<String, String> mapping) {
        for (IProject project : externalProjects) {
            this.analyseSubFolder((IContainer)project, mapping);
        }
    }

    private List<IProject> getExternalProjects() {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)new ResourceChangeListener());
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject aProject = iProjectArray[n2];
            try {
                if (aProject.isAccessible() && aProject.hasNature("com.ibm.cics.pa.ui.panature")) {
                    projects.add(aProject);
                }
            }
            catch (CoreException e) {
                Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"getExternalProjects", (Throwable)e);
            }
            ++n2;
        }
        return projects;
    }

    private void analyseSubFolder(IContainer folder, Map<String, String> mapping) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"analyseSubFolder", (Object)folder);
        if (folder != null && folder.isAccessible()) {
            try {
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    if (resource.getType() == 2) {
                        this.analyseSubFolder((IContainer)((IFolder)resource), mapping);
                    } else if (resource.getType() == 1 && ((IFile)resource).getFileExtension().equalsIgnoreCase(QUERY_FILE_EXTENSIUON)) {
                        String code = ((IFile)resource).getFullPath().toString();
                        Presentation pres = this.createPresentationFromInput(((IFile)resource).getContents(), code);
                        if (pres != null) {
                            pres.applyTableMapping(mapping);
                            PersistedChartDefinition.updateDefinition(pres);
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                logger.logp(Level.SEVERE, QueryCache.class.getName(), "analyseSubFolder", "Core exception", e);
            }
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"analyseSubFolder");
    }

    private Presentation createPresentationFromInput(InputStream stream, String code) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"createPresentationFromInput");
        Presentation pres = (Presentation)PresentationFactory.getInstance().getPresentation(stream);
        if (pres != null) {
            if (code != null) {
                pres.setCode(code);
            }
            QueryCacheKey advancedKey = new QueryCacheKey(pres.getCode(), pres.getMinimumVersion(), pres.getMaximumVersion());
            this.versionedQueryMap.put(advancedKey, pres);
            if (!this.versionedKeyMap.containsKey(pres.getCode())) {
                this.versionedKeyMap.put(pres.getCode(), new ArrayList());
            }
            List<QueryCacheKey> keyCache = this.versionedKeyMap.get(pres.getCode());
            keyCache.add(advancedKey);
            this.columnsMap.put(pres.getCode(), pres.getInputColumns());
            this.tablesMap.put(pres.getCode(), pres.getTargetTables());
            for (ColumnReference ref : pres.getInputColumns().keySet()) {
                if (ref.getType() != ColumnDefinition.getByDBColumnRef(ref.getColumnName()).getType()) {
                    logger.warning("QueryCache, invalid types in " + pres.getCode() + " column " + ref.getColumnName() + " type " + ref.getType().name());
                }
                Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"createPresentationFromInput", (Object)("Parsed " + pres.getTitle()));
            }
        } else {
            ViewHelper.setStatusErrorMessage((IWorkbenchPart)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart(), (String)"An error message with a code");
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"createPresentationFromInput", (Object)(pres != null ? pres.getCode() : "?"));
        return pres;
    }

    private InputStream openContentStream(URL aFile) {
        return this.getClass().getResourceAsStream(aFile.getPath());
    }

    public Presentation[] getAllPresentations() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"getAllPresentations");
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getAllPresentations", this.versionedQueryMap.values());
        Presentation[] array = this.versionedQueryMap.values().toArray(new Presentation[this.versionedQueryMap.size()]);
        Arrays.sort(array, new Comparator<Presentation>(){

            @Override
            public int compare(Presentation pres1, Presentation pres2) {
                return pres1.getMenu().compareTo(pres2.getMenu());
            }
        });
        return array;
    }

    public Set<String> findPossbleLinks(ColumnDefinition[] columnHeadings, String currentTable, Collection<ColumnDefinition> restrictMutations, String vrm) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"findPossbleLinks");
        HashSet<String> links = new HashSet<String>();
        for (String key : this.columnsMap.keySet()) {
            Map<ColumnReference, String> mapping = this.columnsMap.get(key);
            boolean matchedSoFar = !mapping.isEmpty();
            for (ColumnReference ref : mapping.keySet()) {
                boolean innerMatch = false;
                int i = 0;
                while (i < columnHeadings.length && !innerMatch) {
                    innerMatch = columnHeadings[i].getDBColumnRef().equals(ref.getColumnName()) || columnHeadings[i].canMutateTo(ref.getColumnName()) && (restrictMutations == null || restrictMutations.contains(ColumnDefinition.getByDBColumnRef(ref.getColumnName())));
                    ++i;
                }
                boolean bl = matchedSoFar = matchedSoFar ? innerMatch : false;
            }
            if (!matchedSoFar) continue;
            if (Utilities.hasContent((String)currentTable)) {
                Collection col;
                Presentation presentation = this.getAppropriatePresentation(key, vrm);
                if (presentation == null || currentTable.equals((col = this.getAppropriatePresentation(key, vrm).getTargetTables()).iterator().next()) || !this.getAppropriatePresentation(key, vrm).getImplType().equals("Link")) continue;
                links.add(key);
                continue;
            }
            if (!this.getAppropriatePresentation(key, vrm).getImplType().equals("Link")) continue;
            links.add(key);
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"findPossbleLinks", links);
        return links;
    }

    public String getCategorizationFor(String code) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"getCategorizationFor");
        String ctg = null;
        Presentation presentation = this.getAppropriatePresentation(code, null);
        if (presentation != null) {
            ctg = presentation.getCategorization();
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getCategorizationFor", (Object)ctg);
        return ctg;
    }

    public Presentation getAppropriatePresentation(String code, String version) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"getAppropriatePresentation", (Object)code, (Object)version);
        QueryCacheKey bestKey = null;
        Presentation presentation = null;
        List<QueryCacheKey> options = this.versionedKeyMap.get(code);
        if (options != null) {
            if (options.size() == 1) {
                bestKey = options.get(0);
            } else {
                int bestScore = -1;
                for (QueryCacheKey key : options) {
                    int score = key.evaluate(version);
                    if (score <= bestScore) continue;
                    bestKey = key;
                    bestScore = score;
                }
            }
            presentation = this.versionedQueryMap.get(bestKey);
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getAppropriatePresentation", presentation);
        return presentation;
    }

    public Presentation[] getPresentationsForCategories(Set<String> allCheckedEnums) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"getPresentationsForCategories");
        ArrayList<Presentation> subset = new ArrayList<Presentation>();
        Presentation[] presentationArray = this.getAllPresentations();
        int n = presentationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Presentation presentation = presentationArray[n2];
            if (allCheckedEnums.contains(presentation.getCategorization())) {
                subset.add(presentation);
            }
            ++n2;
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getPresentationsForCategories", subset);
        return subset.toArray(new Presentation[subset.size()]);
    }

    public void removeReference(String key) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"removeReference");
        this.columnsMap.remove(key);
        this.tablesMap.remove(key);
        for (QueryCacheKey myKey : this.versionedKeyMap.get(key)) {
            this.versionedQueryMap.remove(myKey);
        }
        this.reassess();
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"removeReference", (Object)key);
    }

    public void updateReference(InputStream inputStream, IFile resource) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"updateReference");
        Presentation presentation = this.createPresentationFromInput(inputStream, resource.getFullPath().toString());
        if (presentation != null) {
            presentation.applyTableMapping(ManifestRecord.getAliasMapping());
            PersistedChartDefinition.updateDefinition(presentation);
        }
        this.correctCategorization(presentation, resource);
        this.reassess();
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"updateReference", (Object)presentation.getCode());
    }

    private void reassess() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ReportList mainview = (ReportList)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.ibm.cics.pa.ui.reportview");
                if (mainview != null) {
                    mainview.reassess();
                }
            }
        });
    }

    private void correctCategorization(Presentation presentation, IFile resource) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"correctCategorization", (Object)resource);
        String cat = null;
        IPath path = resource.getProjectRelativePath();
        for (TableCategorisationEnum en : EnumSet.allOf(TableCategorisationEnum.class)) {
            if (path.toString().toUpperCase().indexOf(en.getLabel().toUpperCase()) <= -1) continue;
            cat = en.getId();
            if (presentation.getCategorization().equals(cat)) {
                Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"correctCategorization", null);
                return;
            }
            presentation.setCategorization(cat);
            this.reassess();
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"correctCategorization", (Object)cat);
            return;
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"correctCategorization", null);
    }

    public Collection<Presentation> getPossibleTops() {
        ArrayList<Presentation> pressies = new ArrayList<Presentation>();
        for (Presentation presentation : this.versionedQueryMap.values()) {
            if (!presentation.getImplType().startsWith("Snippet")) continue;
            pressies.add(presentation);
        }
        return pressies;
    }

    public Collection<String> getIntervalAliasList() {
        if (this.intervalAliasList == null) {
            this.intervalAliasList = new ArrayList<String>();
            for (Presentation presentation : this.versionedQueryMap.values()) {
                if (PersistedChartDefinition.getDefinition(presentation).getType() != ChartType.INTERVAL_PLOT) continue;
                this.intervalAliasList.add((String)presentation.getSelection().getTargetTables().iterator().next());
            }
        }
        return this.intervalAliasList;
    }

    class QueryCacheKey {
        private static final int MIN = 0;
        private static final int MAX = 99999;
        private String code;
        private int min_version = 0;
        private int max_version = 99999;

        public QueryCacheKey(String code, String min_version, String max_version) {
            this.code = code;
            if (StringUtil.hasContent((String)min_version)) {
                this.min_version = new Integer(min_version);
            }
            if (StringUtil.hasContent((String)max_version)) {
                this.max_version = new Integer(max_version);
            }
        }

        String getCode() {
            return this.code;
        }

        int getMin_version() {
            return this.min_version;
        }

        int getMax_version() {
            return this.max_version;
        }

        public String toString() {
            if (this.max_version == 99999 && this.min_version == 0) {
                return String.valueOf(this.code) + " generic";
            }
            return String.valueOf(this.code) + " minimum " + this.min_version + " maximum " + this.max_version;
        }

        int evaluate(String ver) {
            int version;
            int result = -1;
            if (this.max_version == 99999 && this.min_version == 0) {
                return 0;
            }
            if (StringUtil.hasContent((String)ver) && this.min_version <= (version = new Integer(ver).intValue()) && this.max_version >= version) {
                return 1;
            }
            return result;
        }
    }
}

