/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.dbfunc.command.Engine;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.command.RowProcessor;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.eclipse.common.Utilities;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.model.definitions.TableCategorisationEnum;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.remote.ConnectivityToken;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.utilities.PredefinedTemplate;
import com.ibm.cics.pa.ui.views.Navigator;
import com.ibm.cics.pa.ui.views.Overview;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ManifestRecord {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2022 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    private static final String NAME = "NAME";
    private static final String ALIAS = "ALIAS";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String VERSION = "VERSION";
    private static final String KEYS = "KEYS";
    private static final String DATE1 = "TO";
    private static final String DATE2 = "FROM";
    private static final String CICSPA = "CICSPA";
    public static final String LAST_TABLE = "LAST_TABLE";
    public static final String PERFORMANCE_SUMMARY_ALIAS = "CMFPSUM";
    public static final String PERFORMANCE_LIST_ALIAS = "CMFPLST";
    public static final String APPLICATION_SUMMARY_ALIAS = "CMFACSUM";
    public static final String NEW_MANIFEST_TABLE_NAME = "CPA_MANIFEST";
    public static final String OLD_LOCAL_SUMMARY_TABLE = Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "PRE32_TABLE", "EXPLORER_SUMMARY", null);
    public static final ManifestRecord OLD_PERFORMANCE_SUMMARY_MANIFEST = new ManifestRecord(OLD_LOCAL_SUMMARY_TABLE, "CMFPSUM", OLD_LOCAL_SUMMARY_TABLE, 0, "START_DATE,START_TIME,APPLID,TRAN", null, null, null);
    public static final String TRANSACTIONS = "HST011A";
    public static final String TRANSACTION_CLASSES = "HST012A";
    public static boolean limitManifestRead = "true".equals(System.getProperty("LimitDateRange"));
    private String name;
    private String alias;
    private String description;
    private DataProviderKey key;
    private int version;
    private java.util.Date date1;
    private java.util.Date date2;
    private Time time;
    private Time interval_duration;
    private String cicsPA;
    private java.util.Date latestRecord;
    private java.util.Date earliestRecord;
    boolean dateChecked = false;
    private ConnectivityToken token = null;
    private String vrm;
    static List<ManifestRecord> datePendingRecords = Collections.synchronizedList(new ArrayList());
    static List<ManifestRecord> allPendingRecords = null;
    private static Map<String, ManifestRecord> allRecords = null;
    static Navigator treeDialog1;
    static Overview treeDialog2;
    static int submitcount;
    static int submitcountTotal;
    boolean submitted = false;

    static {
        submitcount = 0;
        submitcountTotal = 0;
    }

    static Map<String, ManifestRecord> getAllRecords() {
        if (allRecords == null) {
            allRecords = new HashMap<String, ManifestRecord>();
        }
        return allRecords;
    }

    private ManifestRecord(String name, String alias, String description, int version, String keyString, java.util.Date date1, java.util.Date date2, String cicsPA) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"ManifestRecord");
        this.name = name.trim();
        this.alias = alias.trim();
        this.description = description.trim();
        this.version = version;
        this.key = DataProviderKey.parse(keyString.toUpperCase());
        if (this.key == DataProviderKey.NONE) {
            logger.log(Level.WARNING, this.getClass().getName(), "ManifestRecord No key found for " + alias + ' ' + this.description + ' ' + keyString);
            if (alias.equals(PERFORMANCE_SUMMARY_ALIAS)) {
                this.key = DataProviderKey.STARTTIME_APPLID_TRAN;
            }
        }
        this.date1 = date1;
        this.date2 = date2;
        String string = this.cicsPA = Utilities.hasContent((String)cicsPA) ? cicsPA.trim() : "";
        if (this.getImage() == null) {
            logger.log(Level.WARNING, this.getClass().getName(), "ManifestRecord image for " + this.description + " " + this.name);
        }
        this.dateChecked = false;
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"ManifestRecord", (Object)this);
    }

    public static ManifestRecord createManifestRecord(ResultSet resultSet) throws SQLException {
        Debug.enter((Logger)logger, (String)"ManifestRecord", (String)"createManifestRecord");
        String alias1 = resultSet.getString(ALIAS).trim();
        ManifestRecord rec = ManifestRecord.getAllRecords().get(alias1);
        if (rec == null) {
            if (TableCategorisationEnum.isValidAlias(alias1)) {
                rec = new ManifestRecord(resultSet.getString(NAME).trim(), resultSet.getString(ALIAS).trim(), resultSet.getString(DESCRIPTION).trim(), resultSet.getInt(VERSION), resultSet.getString(KEYS), resultSet.getDate(DATE1), resultSet.getDate(DATE2), resultSet.getString(CICSPA));
                ManifestRecord.getAllRecords().put(rec.alias, rec);
                logger.logp(Level.INFO, ManifestRecord.class.getName(), "ManifestRecord", "NAME " + rec.getName() + " ALIAS " + rec.getAlias() + " DESCRIPTION " + rec.getDescription());
            } else {
                Debug.warning((Logger)logger, (String)"ManifestRecord", (String)"createManifestRecord", (Object)("Invalid alias label found " + alias1));
            }
        } else {
            Debug.warning((Logger)logger, (String)"ManifestRecord", (String)"createManifestRecord", (Object)("Duplicates in manifest table " + rec.alias));
        }
        Debug.exit((Logger)logger, (String)"ManifestRecord", (String)"createManifestRecord", (Object)rec);
        return rec;
    }

    public static Collection<String> getAliasList() {
        return new TreeSet<String>(ManifestRecord.getAllRecords().keySet());
    }

    public static ManifestRecord getAlias(String alias) {
        ManifestRecord record = ManifestRecord.getAllRecords().get(alias);
        if (record == null) {
            for (ManifestRecord record1 : ManifestRecord.getAllRecords().values()) {
                if (!record1.name.endsWith(alias)) continue;
                return record1;
            }
        }
        return record;
    }

    public static ManifestRecord getName(String name) {
        for (ManifestRecord record : ManifestRecord.getAllRecords().values()) {
            if (!record.name.endsWith(name)) continue;
            return record;
        }
        return ManifestRecord.getAlias(name);
    }

    public static ManifestRecord getLastOrDefault() {
        Debug.enter((Logger)logger, (String)ManifestRecord.class.getName(), (String)"getLastOrDefault");
        String alias = Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), LAST_TABLE, PERFORMANCE_SUMMARY_ALIAS, null);
        ManifestRecord record = ManifestRecord.getAlias(alias);
        if (record == null && (record = ManifestRecord.getAlias(PERFORMANCE_SUMMARY_ALIAS)) == null && ManifestRecord.getAllRecords().size() > 0) {
            record = ManifestRecord.getAllRecords().values().iterator().next();
        }
        if (record == null) {
            logger.logp(Level.SEVERE, ManifestRecord.class.getName(), "getLastOrDefault", "No Manifest record established");
        }
        Debug.exit((Logger)logger, (String)ManifestRecord.class.getName(), (String)"getLastOrDefault", (Object)record);
        return record;
    }

    public static void resetList() {
        allRecords = null;
        allPendingRecords = null;
        submitcountTotal = 0;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getDescription() {
        if (this.isPerformanceSummaryRecord()) {
            return Messages.getString("SpreadSheet.Spreadsheet");
        }
        if (this.isApplicationSummaryRecord()) {
            return Messages.getString("SpreadSheet.Application");
        }
        return this.description;
    }

    public int getVersion() {
        return this.version;
    }

    public java.util.Date getDate1() {
        return this.date1;
    }

    public java.util.Date getDate2() {
        return this.date2;
    }

    public String getCicsPA() {
        return this.cicsPA;
    }

    public DataProviderKey getKey() {
        return this.key;
    }

    public String toString() {
        return String.valueOf(this.alias) + ' ' + this.getDescription() + '(' + this.name + ')';
    }

    public ImageDescriptor getImageDescriptor() {
        ImageDescriptor id = ManifestRecord.getImageDescriptor(this.getAlias());
        if (id == null) {
            if (this.isApplicationSummaryRecord()) {
                return Activator.getDefault().getImageDescriptor("anal_history");
            }
            for (TableCategorisationEnum en : EnumSet.allOf(TableCategorisationEnum.class)) {
                Object[] objectArray = en.getChildren();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object alias1 = objectArray[n2];
                    if (this.alias.equals(alias1)) {
                        return en.getImageDescriptor();
                    }
                    ++n2;
                }
            }
            return this.key == DataProviderKey.NONE ? null : Activator.getDefault().getImageDescriptor(this.key.getColumnDefinitions()[Math.min(this.key.getColumnDefinitions().length - 1, 3)].getDBColumnRef());
        }
        return id;
    }

    public static ImageDescriptor getImageDescriptor(String alias) {
        if (alias.equals("HST087A") || alias.equals("HST090A")) {
            return Activator.getDefault().getImageDescriptor(ColumnDefinition.DUMP_CODE.getDBColumnRef());
        }
        if (alias.equals("HST140A") || alias.equals("HST142A")) {
            return Activator.getDefault().getImageDescriptor("event");
        }
        if (alias.equals("HST021A")) {
            return Activator.getDefault().getImageDescriptor("sna");
        }
        if (alias.equals("HST101A")) {
            return Activator.getDefault().getImageDescriptor("idmap");
        }
        if (alias.equals("HST023A")) {
            return Activator.getDefault().getImageDescriptor(ColumnDefinition.PROGRAM_NAME.getDBColumnRef());
        }
        if (alias.equals("HST024A")) {
            return Activator.getDefault().getImageDescriptor(ColumnDefinition.TERMINAL_ID.getDBColumnRef());
        }
        if (alias.equals("HST010A") || alias.equals(TRANSACTIONS)) {
            return Activator.getDefault().getImageDescriptor(ColumnDefinition.TRAN.getDBColumnRef());
        }
        if (alias.equals("HST028A")) {
            return Activator.getDefault().getImageDescriptor(ColumnDefinition.DB2CONN_NAME.getDBColumnRef());
        }
        if (alias.equals("HST054A")) {
            return Activator.getDefault().getImageDescriptor(ColumnDefinition.APPC_SYSTEM_NAME.getDBColumnRef());
        }
        if (alias.equals("HST117A")) {
            return Activator.getDefault().getImageDescriptor(ColumnDefinition.JVM_PROFILE_NAME.getDBColumnRef());
        }
        if (alias.equals("HST107A")) {
            return Activator.getDefault().getImageDescriptor(ColumnDefinition.TCB_ADDRESS.getDBColumnRef());
        }
        if (alias.equals("HST014A")) {
            return Activator.getDefault().getImageDescriptor(ColumnDefinition.SUBPOOL_NAME.getDBColumnRef());
        }
        if (alias.equals("HST097A")) {
            return Activator.getDefault().getImageDescriptor("tsq");
        }
        if (alias.equals("HST092A")) {
            return Activator.getDefault().getImageDescriptor(ColumnDefinition.LOGSTREAM_NAME.getDBColumnRef());
        }
        if (alias.equals("HST060A") || alias.equals("HST060B") || alias.equals("HST060C") || alias.equals("HST064A")) {
            return Activator.getDefault().getImageDescriptor(ColumnDefinition.DISPATCHER_START_G.getDBColumnRef());
        }
        if (alias.equals("HST045A") || alias.equals("HST048A")) {
            return Activator.getDefault().getImageDescriptor("transient");
        }
        if (alias.equals("HST081A")) {
            return Activator.getDefault().getImageDescriptor("monitor");
        }
        if (alias.equals("HST046A")) {
            return Activator.getDefault().getImageDescriptor("security");
        }
        return null;
    }

    public static Image getImage(String alias) {
        if (alias.equals("HST087A") || alias.equals("HST090A")) {
            return Activator.getDefault().getImage(ColumnDefinition.DUMP_CODE.getDBColumnRef());
        }
        if (alias.equals("HST140A") || alias.equals("HST142A")) {
            return Activator.getDefault().getImage("event");
        }
        if (alias.equals("HST021A")) {
            return Activator.getDefault().getImage("sna");
        }
        if (alias.equals("HST101A")) {
            return Activator.getDefault().getImage("idmap");
        }
        if (alias.equals("HST023A")) {
            return Activator.getDefault().getImage(ColumnDefinition.PROGRAM_NAME.getDBColumnRef());
        }
        if (alias.equals("HST024A")) {
            return Activator.getDefault().getImage(ColumnDefinition.TERMINAL_ID.getDBColumnRef());
        }
        if (alias.equals("HST010A") || alias.equals(TRANSACTIONS)) {
            return Activator.getDefault().getImage(ColumnDefinition.TRAN.getDBColumnRef());
        }
        if (alias.equals("HST028A")) {
            return Activator.getDefault().getImage(ColumnDefinition.DB2CONN_NAME.getDBColumnRef());
        }
        if (alias.equals("HST054A")) {
            return Activator.getDefault().getImage(ColumnDefinition.APPC_SYSTEM_NAME.getDBColumnRef());
        }
        if (alias.equals("HST117A")) {
            return Activator.getDefault().getImage(ColumnDefinition.JVM_PROFILE_NAME.getDBColumnRef());
        }
        if (alias.equals("HST107A")) {
            return Activator.getDefault().getImage(ColumnDefinition.TCB_ADDRESS.getDBColumnRef());
        }
        if (alias.equals("HST014A")) {
            return Activator.getDefault().getImage(ColumnDefinition.SUBPOOL_NAME.getDBColumnRef());
        }
        if (alias.equals("HST097A")) {
            return Activator.getDefault().getImage("tsq");
        }
        if (alias.equals("HST092A")) {
            return Activator.getDefault().getImage(ColumnDefinition.LOGSTREAM_NAME.getDBColumnRef());
        }
        if (alias.equals("HST060A") || alias.equals("HST060B") || alias.equals("HST060C") || alias.equals("HST064A")) {
            return Activator.getDefault().getImage(ColumnDefinition.DISPATCHER_START_G.getDBColumnRef());
        }
        if (alias.equals("HST045A") || alias.equals("HST048A")) {
            return Activator.getDefault().getImage("transient");
        }
        if (alias.equals(APPLICATION_SUMMARY_ALIAS)) {
            return Activator.getDefault().getImage("anal_history");
        }
        if (alias.equals("HST081A")) {
            return Activator.getDefault().getImage("monitor");
        }
        if (alias.equals("PERFORMANCE_LIST_ALIAS")) {
            return Activator.getDefault().getImage(ColumnDefinition.TRAN.getDBColumnRef());
        }
        if (alias.equals("HST046A") || alias.equals("HST151A")) {
            return Activator.getDefault().getImage("security");
        }
        return null;
    }

    public Image getImage() {
        Image image = ManifestRecord.getImage(this.getAlias());
        if (image == null) {
            for (TableCategorisationEnum en : EnumSet.allOf(TableCategorisationEnum.class)) {
                Object[] objectArray = en.getChildren();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object alias1 = objectArray[n2];
                    if (this.getAlias().equals(alias1)) {
                        return en.getImage();
                    }
                    ++n2;
                }
            }
            return this.key == DataProviderKey.NONE ? null : Activator.getDefault().getImage(this.key.getColumnDefinitions()[Math.min(this.key.getColumnDefinitions().length - 1, 3)].getDBColumnRef());
        }
        return image;
    }

    public ColumnDefinition getFinalColumnDefn() {
        return this.key.getColumnDefinitions().length > 0 ? this.key.getColumnDefinitions()[this.key.getColumnDefinitions().length - 1] : null;
    }

    public ConnectivityToken retrieveTokenFor(Object listener) {
        return this.token;
    }

    public void setLatestRecord(java.util.Date earliestdate, java.util.Date latestRecord) {
        this.latestRecord = latestRecord;
        this.earliestRecord = earliestdate;
        this.dateChecked = true;
    }

    public java.util.Date getLatestRecord() {
        return this.latestRecord;
    }

    public java.util.Date getEarliestRecord() {
        return this.earliestRecord;
    }

    public boolean isDateChecked() {
        return this.dateChecked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPresent() {
        if (!this.dateChecked) {
            if (!PAConnectionTracker.getInstance().getDiscoveredTables().isEmpty() && !PAConnectionTracker.getInstance().getDiscoveredTables().contains(this.getName())) {
                this.dateChecked = true;
                Debug.warning((Logger)logger, (String)ManifestRecord.class.getName(), (String)"Manifest entry when table does not exist", (Object)this);
                return false;
            }
            List<ManifestRecord> list = datePendingRecords;
            synchronized (list) {
                if (!datePendingRecords.contains(this)) {
                    datePendingRecords.add(this);
                    ManifestRecord.submitCheck();
                }
            }
        }
        return this.latestRecord != null;
    }

    public boolean isRecent() {
        if (this.isPresent()) {
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(this.latestRecord);
            cal1.add(6, 1);
            return cal1.after(Calendar.getInstance());
        }
        return false;
    }

    static ManifestRecord getAManifestRecord1() {
        ManifestRecord manifestRecord = null;
        if (!datePendingRecords.isEmpty()) {
            manifestRecord = datePendingRecords.get(0);
            datePendingRecords.remove(manifestRecord);
            if (allPendingRecords != null) {
                allPendingRecords.remove(manifestRecord);
            }
        }
        return manifestRecord;
    }

    static ManifestRecord getAManifestRecord2() {
        ManifestRecord manifestRecord = null;
        if (allPendingRecords != null && !allPendingRecords.isEmpty()) {
            manifestRecord = allPendingRecords.get(0);
            allPendingRecords.remove(manifestRecord);
        }
        return manifestRecord;
    }

    static void submitCheck() {
        Job job = new Job(Messages.getString("PAOutlinePage.ExpandingJob")){

            protected IStatus run(IProgressMonitor monitor) {
                boolean refreshRequired;
                ManifestRecord manifestRecord1 = ManifestRecord.getAManifestRecord1();
                final ManifestRecord manifestRecord = manifestRecord1 != null ? manifestRecord1 : ManifestRecord.getAManifestRecord2();
                boolean bl = refreshRequired = manifestRecord == manifestRecord1 || allPendingRecords.isEmpty();
                if (allPendingRecords != null) {
                    do {
                        Thread.yield();
                    } while (submitcount > 1);
                }
                if (manifestRecord != null && !manifestRecord.isDateChecked() && !manifestRecord.submitted) {
                    manifestRecord.submitted = true;
                    Debug.enter((Logger)logger, (String)ManifestRecord.class.getName(), (String)"submitCheckFor", (Object)manifestRecord.getAlias());
                    final Selection selection = PresentationFactory.getInstance().createSelectForTable(manifestRecord.getName(), ":schema");
                    if (manifestRecord.isPerformanceAlert() || manifestRecord.isPerformanceList()) {
                        if (limitManifestRead) {
                            selection.getSelect().addSelectionColumn(ColumnDefinition.START.getDBColumnRef(), manifestRecord.getName(), ColumnReference.DataType.Date, ColumnReference.Function.NONE);
                            selection.addOrderByCondition(ColumnDefinition.START.getDBColumnRef(), manifestRecord.getName(), Direction.ASC);
                        } else {
                            selection.getSelect().addSelectionColumn(ColumnDefinition.START.getDBColumnRef(), manifestRecord.getName(), ColumnReference.DataType.Date, ColumnReference.Function.MIN);
                            selection.getSelect().addSelectionColumn(ColumnDefinition.START.getDBColumnRef(), manifestRecord.getName(), ColumnReference.DataType.Date, ColumnReference.Function.MAX);
                        }
                    } else if (limitManifestRead) {
                        selection.getSelect().addSelectionColumn(ColumnDefinition.START_DATE.getDBColumnRef(), manifestRecord.getName(), ColumnReference.DataType.Date, ColumnReference.Function.NONE);
                        selection.addOrderByCondition(ColumnDefinition.START_DATE.getDBColumnRef(), manifestRecord.getName(), Direction.ASC);
                    } else {
                        selection.getSelect().addSelectionColumn(ColumnDefinition.START_DATE.getDBColumnRef(), manifestRecord.getName(), ColumnReference.DataType.Date, ColumnReference.Function.MIN);
                        selection.getSelect().addSelectionColumn(ColumnDefinition.START_DATE.getDBColumnRef(), manifestRecord.getName(), ColumnReference.DataType.Date, ColumnReference.Function.MAX);
                    }
                    selection.firstRowOnly();
                    if (!PAConnectionTracker.getInstance().isConnected()) {
                        return Status.CANCEL_STATUS;
                    }
                    final Engine engine = new Engine("com.ibm.cics.pa.connection", new RowProcessor(){

                        public Map<String, Object> getParameterMap() {
                            return new HashMap<String, Object>();
                        }

                        public SelectionObject getSelectionObject() {
                            return selection;
                        }

                        public Object processRow(ResultSet resultSet) {
                            Object[] date = new Object[3];
                            try {
                                if (manifestRecord.isPerformanceAlert() || manifestRecord.isPerformanceList()) {
                                    if (resultSet.getTimestamp(1) != null && resultSet.getTimestamp(2) != null) {
                                        date[0] = new Date(resultSet.getTimestamp(1).getTime());
                                        date[1] = limitManifestRead ? date[0] : new Date(resultSet.getTimestamp(2).getTime());
                                    }
                                } else {
                                    date[0] = resultSet.getDate(1);
                                    date[1] = limitManifestRead ? date[0] : resultSet.getDate(2);
                                }
                            }
                            catch (SQLException e) {
                                Debug.error((Logger)logger, (String)ManifestRecord.class.getName(), (String)"submitCheckFor processRow", (Throwable)e);
                            }
                            return date;
                        }
                    });
                    engine.addListener(new EngineShell.EngineListener(){

                        public void dataAvailable(Collection<Object> items) {
                            if (items.size() == 1) {
                                manifestRecord.setLatestRecord((java.util.Date)((Object[])items.toArray()[0])[0], (java.util.Date)((Object[])items.toArray()[0])[1]);
                                if (manifestRecord == PAConnectionTracker.getInstance().getAlertManifest() || manifestRecord == PAConnectionTracker.getInstance().getPerformanceAlertManifest()) {
                                    PAConnectionTracker.getInstance().manifestRead(manifestRecord);
                                }
                            } else {
                                manifestRecord.setLatestRecord(null, null);
                            }
                            if (refreshRequired && treeDialog1 != null) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        treeDialog1.refresh(manifestRecord);
                                    }
                                });
                            }
                            if (refreshRequired && treeDialog2 != null) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        treeDialog2.refresh(manifestRecord);
                                    }
                                });
                            }
                        }

                        public void notifyResultCount(int count) {
                        }

                        public void statusUpdate(EngineShell.EngineStatus es) {
                            switch (es) {
                                case Cancelled: {
                                    --submitcount;
                                    engine.removeListener((EngineShell.EngineListener)this);
                                    break;
                                }
                                case Complete: 
                                case Error: {
                                    --submitcount;
                                    engine.removeListener((EngineShell.EngineListener)this);
                                    ManifestRecord.submitCheck();
                                    manifestRecord.dateChecked = true;
                                    break;
                                }
                            }
                        }
                    });
                    ++submitcount;
                    engine.setNotifyOnCount(false);
                    engine.start();
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(50);
        job.schedule();
        Debug.exit((Logger)logger, (String)ManifestRecord.class.getName(), (String)"submitCheckFor");
    }

    void setVRM(String vrm) {
        if (StringUtil.hasContent((String)vrm)) {
            this.vrm = vrm;
        }
    }

    public String getVRM() {
        return this.vrm;
    }

    public static boolean validateActive(Collection<String> targetTables) {
        for (String tableAlias : targetTables) {
            if (ManifestRecord.getAlias(tableAlias).isPresent()) continue;
            return false;
        }
        return true;
    }

    public static Map<String, String> getAliasMapping() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (String alias : ManifestRecord.getAliasList()) {
            mapping.put(alias, ManifestRecord.getAlias(alias).getName());
        }
        return mapping;
    }

    public boolean isPerformanceSummaryRecord() {
        return this.alias.equals(PERFORMANCE_SUMMARY_ALIAS) || this.alias.equals(OLD_LOCAL_SUMMARY_TABLE);
    }

    public boolean isApplicationSummaryRecord() {
        return this.alias.equals(APPLICATION_SUMMARY_ALIAS);
    }

    public boolean isTransactions() {
        return this.alias.equals(TRANSACTIONS);
    }

    public boolean isTransactionClassess() {
        return this.alias.equals(TRANSACTION_CLASSES);
    }

    public static ManifestRecord old() {
        Debug.enter((Logger)logger, (String)ManifestRecord.class.getName(), (String)"old");
        ManifestRecord rec = OLD_PERFORMANCE_SUMMARY_MANIFEST;
        if (!ManifestRecord.getAllRecords().containsKey(rec.alias)) {
            ManifestRecord.getAllRecords().put(rec.alias, rec);
        }
        Debug.exit((Logger)logger, (String)ManifestRecord.class.getName(), (String)"old", (Object)rec);
        return rec;
    }

    public static boolean isPerformanceSummaryRecord(String table) {
        return PERFORMANCE_SUMMARY_ALIAS.equals(table) || ManifestRecord.getAlias(PERFORMANCE_SUMMARY_ALIAS) != null && ManifestRecord.getAlias(PERFORMANCE_SUMMARY_ALIAS).getName().equals(table);
    }

    public static boolean isPerformanceList(String table) {
        return PERFORMANCE_LIST_ALIAS.equals(table) || ManifestRecord.getAlias(PERFORMANCE_LIST_ALIAS) != null && ManifestRecord.getAlias(PERFORMANCE_LIST_ALIAS).getName().equals(table);
    }

    public static boolean isApplicationSummaryRecord(String table) {
        return APPLICATION_SUMMARY_ALIAS.equals(table) || ManifestRecord.getAlias(APPLICATION_SUMMARY_ALIAS) != null && ManifestRecord.getAlias(APPLICATION_SUMMARY_ALIAS).getName().equals(table);
    }

    public boolean isAlert() {
        return this.getAlias().equals("HST0SAA") || this.getAlias().equals("HSTG0SAA");
    }

    public boolean isPerformanceAlert() {
        return this.getAlias().equals("CMFALERT");
    }

    public boolean isPerformanceList() {
        return this.getAlias().equals(PERFORMANCE_LIST_ALIAS);
    }

    public boolean isStatTable() {
        return !this.isAlert() && !this.isPerformanceList() && !this.isApplicationSummaryRecord() && !this.isPerformanceSummaryRecord();
    }

    protected void updateTime(Time time, Time duration) {
        this.time = time;
        this.interval_duration = duration;
    }

    public boolean isTimeChecked() {
        return this.isPerformanceSummaryRecord() || this.isApplicationSummaryRecord() || this.time != null;
    }

    public Time getIntervalDuration() {
        return this.interval_duration;
    }

    public Time getLatestTime() {
        return this.time;
    }

    public PredefinedTemplate getDefaultTemplate() {
        if (this.alias.equals("HST060A")) {
            return PredefinedTemplate.Default_Dispatcher;
        }
        if (this.alias.equals("HST060B")) {
            return PredefinedTemplate.Default_Dispatcher_TCB_Modes;
        }
        if (this.alias.equals("HST060C")) {
            return PredefinedTemplate.Default_Dispatcher_TCB_Pools;
        }
        if (this.alias.equals(TRANSACTIONS)) {
            return PredefinedTemplate.Default_Transactions;
        }
        if (this.alias.equals("HST090A")) {
            return PredefinedTemplate.Default_System_Dump_Overview;
        }
        if (this.alias.equals("HST088A")) {
            return PredefinedTemplate.Default_System_Dumps;
        }
        if (this.alias.equals("HST087A")) {
            return PredefinedTemplate.Default_Transaction_Dump_Overview;
        }
        if (this.alias.equals("HST085A")) {
            return PredefinedTemplate.Default_Transaction_Dumps;
        }
        if (this.alias.equals("HST023A")) {
            return PredefinedTemplate.Default_Program_Autoinstall;
        }
        if (this.alias.equals("HST052A")) {
            return PredefinedTemplate.Default_ISCMRO;
        }
        if (this.alias.equals("HST092A")) {
            return PredefinedTemplate.Default_Logstream_Overview;
        }
        if (this.alias.equals("HST006A")) {
            return PredefinedTemplate.Default_Task_Subpools;
        }
        if (this.alias.equals("HST005A")) {
            return PredefinedTemplate.Default_Domain_Subpools;
        }
        if (this.alias.equals("HST094A")) {
            return PredefinedTemplate.Default_MVS_Logstreams;
        }
        if (this.alias.equals("HST066A")) {
            return PredefinedTemplate.Default_Statistics;
        }
        if (this.alias.equals("HST081A")) {
            return PredefinedTemplate.Default_Monitoring;
        }
        if (this.alias.equals("HST099A")) {
            return PredefinedTemplate.Default_Recovery_Manager;
        }
        if (this.alias.equals("HST045A")) {
            return PredefinedTemplate.Default_Transient_Data_Overview;
        }
        if (this.alias.equals("HST042A")) {
            return PredefinedTemplate.Default_Transient_Data_Queues;
        }
        if (this.alias.equals("HST031A")) {
            return PredefinedTemplate.Default_Library_Resources;
        }
        if (this.alias.equals("HST039B")) {
            return PredefinedTemplate.Default_VSAM_LSR_POOL_BUFFERS;
        }
        if (this.alias.equals("HST048A")) {
            return PredefinedTemplate.Default_Temporary_Storage_Overview;
        }
        if (this.alias.equals("HST120A")) {
            return PredefinedTemplate.Default_ProgramDef_Resources;
        }
        if (this.alias.equals("HST025A")) {
            return PredefinedTemplate.Default_Programs;
        }
        if (this.alias.equals("HST030B")) {
            return PredefinedTemplate.Default_Loader_DSAs;
        }
        if (this.alias.equals("HST101A")) {
            return PredefinedTemplate.Default_URIMAP_Global;
        }
        if (this.alias.equals("HST010A")) {
            return PredefinedTemplate.Default_Transaction_Manager;
        }
        if (this.alias.equals("HST104A")) {
            return PredefinedTemplate.Default_URIMAP_Resources;
        }
        if (this.alias.equals("HST106A")) {
            return PredefinedTemplate.Default_Webservice_Resources;
        }
        if (this.alias.equals("HST112A")) {
            return PredefinedTemplate.Default_DOCTemplate_Resources;
        }
        if (this.alias.equals("HST107A")) {
            return PredefinedTemplate.Default_TCPIP_Overview;
        }
        if (this.alias.equals("HST108A")) {
            return PredefinedTemplate.Default_TCPIPService_resources;
        }
        if (this.alias.equals("HST102A")) {
            return PredefinedTemplate.Default_DB2_Connections;
        }
        return null;
    }

    public static String validateAliasName(String tableName) {
        ManifestRecord record = ManifestRecord.getAlias(tableName);
        if (record != null) {
            return tableName;
        }
        record = ManifestRecord.getName(tableName);
        if (record != null) {
            return record.getAlias();
        }
        return null;
    }

    public static ManifestRecord getRecordFromDescription(String table) {
        for (ManifestRecord record : ManifestRecord.getAllRecords().values()) {
            if (!record.description.equals(table)) continue;
            return record;
        }
        return null;
    }

    public static void registerNavigator(Navigator navigator) {
        treeDialog1 = navigator;
    }

    public static void registerNavigator(Overview navigator) {
        treeDialog2 = navigator;
    }

    public static boolean tablesInitialised() {
        return allPendingRecords != null && allPendingRecords.isEmpty();
    }

    public static void lookThemAllUp() {
        if (allPendingRecords == null) {
            allPendingRecords = new ArrayList<ManifestRecord>();
            Job job = new Job(Messages.getString("PAOutlinePage.ExpandingJob")){

                protected IStatus run(IProgressMonitor monitor) {
                    for (ManifestRecord record : ManifestRecord.getAllRecords().values()) {
                        if (record.dateChecked || datePendingRecords.contains(record) || allPendingRecords == null) continue;
                        Thread.yield();
                        allPendingRecords.add(record);
                    }
                    ManifestRecord.submitCheck();
                    return Status.OK_STATUS;
                }
            };
            job.schedule(500L);
        }
    }

    public static ManifestRecord deriveFromSelection(Presentation presentation) {
        return ManifestRecord.getAlias((String)presentation.getTargetTables().toArray()[0]);
    }
}

