/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.pa.model.ChartingFile;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.IModelChangeListener;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;

public abstract class Chart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static Map<String, Chart> references = new HashMap<String, Chart>();
    public static final String CHART_REF = "ChartRef";
    public static final String CHART_KEY = "ChartKey";
    Collection<IModelChangeListener> modelListeners = new HashSet<IModelChangeListener>();
    private String chartId = null;
    protected String chartTitle;
    private String dataProviderReference;
    private ChartSpecification uniqueChartId;
    protected String primaryDescription;
    private String toolTipText = null;

    public static Chart getReference(String id) {
        return references.get(id);
    }

    public static Chart getReference(IFile id) {
        return references.get(id.getLocation());
    }

    public Chart(ChartSpecification chartDefinition, GenericDataProvider dataProvider) {
        this.uniqueChartId = chartDefinition;
        this.dataProviderReference = dataProvider.getFileReference();
        this.chartTitle = chartDefinition.getTitle();
    }

    public boolean equals(Object object) {
        return object instanceof Chart && ((Chart)object).getChartId().equals(this.getChartId());
    }

    public boolean exists() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public String getChartId() {
        return this.chartId;
    }

    public String getPrimaryLabel() {
        return this.primaryDescription;
    }

    public ChartSpecification getChartReference() {
        return this.uniqueChartId;
    }

    public GenericDataProvider getDataProvider() {
        return ChartingFile.getReference(this.dataProviderReference);
    }

    public String getName() {
        String name = "";
        if (this.getDataProvider() != null) {
            name = this.getDataProvider().getAbridgedReference();
        }
        return name;
    }

    public String getTitle() {
        return this.chartTitle;
    }

    public String getToolTipText() {
        if (this.toolTipText == null) {
            this.toolTipText = String.valueOf(this.chartTitle) + " ";
            if (this.getDataProvider() != null) {
                this.toolTipText = String.valueOf(this.toolTipText) + this.getDataProvider().getTabName();
            }
        }
        return this.toolTipText;
    }

    protected void setToolTipText(String text) {
        this.toolTipText = text;
    }

    public void remove() {
        references.remove(this.getChartId());
    }

    public void setChartId(String chartId) {
        this.chartId = chartId;
    }

    public String toString() {
        return String.valueOf(this.getClass().toString()) + " " + this.getChartId();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static String calculateReference(ChartSpecification chartDefinition, String contentdesc) {
        return String.valueOf(chartDefinition.name()) + '-' + contentdesc.hashCode();
    }

    public void addModelChangeListener(IModelChangeListener aView) {
        this.modelListeners.add(aView);
    }

    public void removeModelChangeListener(IModelChangeListener aView) {
        this.modelListeners.remove(aView);
    }
}

