/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.AlertElement;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class AlertBucket {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(AlertBucket.class);
    private List<AlertElement> bucket = new ArrayList<AlertElement>();
    private SEVERITY severity;
    public static final String SEVERE = "Critical";
    public static final String WARNING = "Warning";
    public static final String INFO = "Info";

    public AlertBucket(SEVERITY severity) {
        debug.enter("AlertBucket", (Object)severity);
        this.severity = severity;
        debug.exit("AlertBucket", this.bucket);
    }

    public Image getImage() {
        switch (this.severity) {
            case WARNING: {
                return Activator.getDefault().getImage("warning");
            }
            case INFORMATION: {
                return Activator.getDefault().getImage("information");
            }
        }
        return Activator.getDefault().getImage("critical");
    }

    public synchronized Object[] getBucket() {
        return this.bucket.toArray();
    }

    public String getLabel() {
        switch (this.severity) {
            case WARNING: {
                return Messages.getString("AlertBucket.warning");
            }
            case INFORMATION: {
                return Messages.getString("AlertBucket.information");
            }
        }
        return Messages.getString("AlertBucket.critical");
    }

    public void add(AlertElement alertElement) {
        this.bucket.add(alertElement);
        alertElement.setParent(this);
    }

    public void remove(AlertElement alertElement) {
        this.bucket.remove(alertElement);
    }

    public boolean isEmpty() {
        return this.bucket.isEmpty();
    }

    public void clear() {
        int i = 0;
        while (i < this.bucket.size()) {
            this.bucket.get(i).setParent(null);
            ++i;
        }
        this.bucket = new ArrayList<AlertElement>();
    }

    public static enum SEVERITY {
        CRITICAL,
        WARNING,
        INFORMATION;

    }
}

