/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.comm;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.connections.AbstractConnectionCustomizer;
import com.ibm.cics.core.connections.IConnectionCustomizerListener;
import com.ibm.cics.dbfunc.Messages;
import com.ibm.cics.eclipse.common.Utilities;
import com.ibm.cics.eclipse.common.ui.EnsureUppercaseListener;
import com.ibm.cics.eclipse.common.ui.TextInput;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class DB2ConnectionCustomizer2
extends AbstractConnectionCustomizer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String BLANK = "";
    Text databaseNameText;
    private Text schemaText;
    private ConnectionConfiguration configuration;
    String PROPERTY_ID = "PROPERTY_ID";
    boolean synchronizingUIToModel = false;

    public void clear() {
        this.configuration = null;
        this.databaseNameText.setText(BLANK);
        this.schemaText.setText(BLANK);
    }

    public void createControl(Composite parent) {
        Label db2Label = new Label(parent, 0);
        db2Label.setText(Messages.getString((String)"PreferencePage.txt.database"));
        this.databaseNameText = new Text(parent, 2048);
        TextInput.setAccessibleLabel((Text)this.databaseNameText, (Label)db2Label);
        this.databaseNameText.setData(this.PROPERTY_ID, (Object)"DATABASE_NAME");
        GridData data = new GridData(4, 0x1000000, true, false);
        this.databaseNameText.setLayoutData((Object)data);
        EnsureUppercaseListener.attach((Text)this.databaseNameText);
        Label schemaLabel = new Label(parent, 0);
        schemaLabel.setText(Messages.getString((String)"PreferencePage.txt.schema"));
        this.schemaText = new Text(parent, 2048);
        TextInput.setAccessibleLabel((Text)this.schemaText, (Label)schemaLabel);
        data = new GridData();
        data.widthHint = 60;
        this.schemaText.setLayoutData((Object)data);
        this.schemaText.setData(this.PROPERTY_ID, (Object)"SCHEMA_NAME");
        EnsureUppercaseListener.attach((Text)this.schemaText);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!DB2ConnectionCustomizer2.this.synchronizingUIToModel) {
                    for (IConnectionCustomizerListener listener : DB2ConnectionCustomizer2.this.getListeners()) {
                        listener.propertyChanged((String)e.widget.getData(DB2ConnectionCustomizer2.this.PROPERTY_ID), (Object)((Text)e.widget).getText());
                    }
                }
            }
        };
        this.databaseNameText.addModifyListener(modifyListener);
        this.schemaText.addModifyListener(modifyListener);
    }

    public void updateCurrentConfiguration() {
        if (this.configuration != null) {
            this.configuration.setExtendedAttribute("DATABASE_NAME", this.databaseNameText.getText().trim());
            this.configuration.setExtendedAttribute("SCHEMA_NAME", this.schemaText.getText().trim());
        }
    }

    public void setConfiguration(ConnectionConfiguration connectionConfiguration) {
        try {
            this.synchronizingUIToModel = true;
            if (connectionConfiguration == null) {
                this.databaseNameText.setText(BLANK);
                this.schemaText.setText(BLANK);
            } else {
                String ourDatabaseName = connectionConfiguration.getExtendedAttribute("DATABASE_NAME");
                String ourSchemaName = connectionConfiguration.getExtendedAttribute("SCHEMA_NAME");
                if (ourDatabaseName != null && !ourDatabaseName.toUpperCase().equals(this.databaseNameText.getText())) {
                    this.databaseNameText.setText(ourDatabaseName);
                }
                if (ourSchemaName != null && !ourSchemaName.toUpperCase().equals(this.schemaText.getText())) {
                    this.schemaText.setText(ourSchemaName);
                }
            }
            this.configuration = connectionConfiguration;
        }
        finally {
            this.synchronizingUIToModel = false;
        }
    }

    public void performDefaults() {
        this.databaseNameText.setText(BLANK);
        this.schemaText.setText(BLANK);
    }

    public String validateEnteredData() {
        String name = this.databaseNameText.getText().trim();
        if (!Utilities.hasContent((String)name)) {
            return Messages.getString((String)"DB2PreferencePage_invalid_name_message");
        }
        String schema = this.schemaText.getText().trim();
        if (!Utilities.hasContent((String)schema)) {
            return Messages.getString((String)"DB2PreferencePage_invalid_schema_message");
        }
        return null;
    }
}

