/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.utilities;

import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.core.ui.UIHelper;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Control;

public class Utilities
extends UIHelper
implements Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Comparator textSorter;
    private static Comparator textComparator;
    private static Comparator ebcdicComparator;
    private static int lastInsertion;

    static {
        ebcdicComparator = new EBCDICStringComparator();
        textSorter = new Comparator(){

            public int compare(Object firstItem, Object secondItem) {
                return ebcdicComparator.compare(firstItem, secondItem);
            }
        };
        textComparator = new Comparator(){

            public int compare(Object existingItem, Object textOfItemToInsert) {
                return ebcdicComparator.compare(existingItem, textOfItemToInsert);
            }
        };
    }

    public static int getIndexForEBCDICSortedTreeItem(Collection<String> existingElements, String text) {
        int compareToLast;
        String[] treeItems = existingElements.toArray(new String[existingElements.size()]);
        if (treeItems.length == 0) {
            return 0;
        }
        if (treeItems.length > 0 && (compareToLast = textComparator.compare(treeItems[treeItems.length - 1], text)) < 0) {
            return treeItems.length;
        }
        int indexToInsert = Arrays.binarySearch(treeItems, text, textComparator);
        if (indexToInsert == -1) {
            return 0;
        }
        if (indexToInsert < 0) {
            return 0 - indexToInsert - 1;
        }
        return indexToInsert;
    }

    public static String asTrailingWild(String text) {
        if (text.trim().endsWith("*")) {
            return text;
        }
        return String.valueOf(text.trim()) + "*";
    }

    public static ControlDecoration addMandatoryField(Control control) {
        final ControlDecoration controlDecoration = new ControlDecoration(control, 131200);
        controlDecoration.hide();
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED");
        controlDecoration.setImage(fieldDecoration.getImage());
        controlDecoration.setDescriptionText(fieldDecoration.getDescription());
        control.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (controlDecoration != null) {
                    controlDecoration.show();
                }
            }
        });
        return controlDecoration;
    }

    public static class EBCDICStringComparator
    implements Comparator {
        public int compare(Object firstString, Object secondString) {
            if (firstString == null) {
                return 1;
            }
            if (secondString == null) {
                return -1;
            }
            try {
                byte[] b1 = ((String)firstString).getBytes("CP1047");
                char[] c1 = new char[b1.length];
                int i = 0;
                while (i < b1.length) {
                    c1[i] = (char)b1[i];
                    ++i;
                }
                byte[] b2 = ((String)secondString).getBytes("CP1047");
                char[] c2 = new char[b2.length];
                int i2 = 0;
                while (i2 < b2.length) {
                    c2[i2] = (char)b2[i2];
                    ++i2;
                }
                int n = Math.min(b1.length, b2.length);
                int i3 = 0;
                int j = 0;
                while (n-- != 0) {
                    char char2;
                    char char1;
                    if ((char1 = c1[i3++]) == (char2 = c2[j++])) continue;
                    return char1 - char2;
                }
                return b1.length - b2.length;
            }
            catch (UnsupportedEncodingException e) {
                return 0;
            }
        }

        @Override
        public boolean equals(Object o) {
            return this == o;
        }
    }
}

