/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.utilities;

import com.ibm.cics.cm.utilities.SelectionProvider;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeSelectionProvider
extends SelectionProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String dataKey;
    private SelectionListener treeSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Object resource = null;
            ArrayList<Object> selectedResources = new ArrayList<Object>();
            Tree tree = (Tree)e.widget;
            if (tree.getSelectionCount() == 1) {
                resource = TreeSelectionProvider.this.dataKey == null ? tree.getSelection()[0].getData() : tree.getSelection()[0].getData(TreeSelectionProvider.this.dataKey);
            } else if (TreeSelectionProvider.this.multipleSelections && tree.getSelectionCount() > 1) {
                TreeItem[] selection;
                TreeItem[] treeItemArray = selection = tree.getSelection();
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeItem = treeItemArray[n2];
                    Object object = resource = TreeSelectionProvider.this.dataKey == null ? treeItem.getData() : treeItem.getData(TreeSelectionProvider.this.dataKey);
                    if (resource != null) {
                        selectedResources.add(resource);
                    }
                    ++n2;
                }
            }
            if (resource == null) {
                TreeSelectionProvider.this.setSelection((ISelection)StructuredSelection.EMPTY);
            } else if (selectedResources.size() > 0) {
                TreeSelectionProvider.this.setSelection((ISelection)new StructuredSelection(selectedResources));
            } else {
                TreeSelectionProvider.this.setSelection((ISelection)new StructuredSelection(resource));
            }
        }
    };
    private SelectionListener tableSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Object resource = null;
            Table table = (Table)e.widget;
            if (table.getSelectionCount() == 1) {
                Object object = resource = TreeSelectionProvider.this.dataKey == null ? table.getSelection()[0].getData() : table.getSelection()[0].getData(TreeSelectionProvider.this.dataKey);
            }
            if (resource == null) {
                TreeSelectionProvider.this.setSelection((ISelection)StructuredSelection.EMPTY);
            } else {
                TreeSelectionProvider.this.setSelection((ISelection)new StructuredSelection(resource));
            }
        }
    };
    private boolean multipleSelections;

    public TreeSelectionProvider(Tree aTree) {
        this(aTree, null);
    }

    public TreeSelectionProvider(Tree aTree, String aDataKey) {
        this.dataKey = aDataKey;
        this.registerTree(aTree);
    }

    public void registerTree(Tree aTree) {
        aTree.addSelectionListener(this.treeSelectionListener);
    }

    public void registerTable(Table aTable) {
        aTable.addSelectionListener(this.tableSelectionListener);
    }

    public void allowMultipleSelections(boolean allowMultipleSelections) {
        this.multipleSelections = allowMultipleSelections;
    }
}

