/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.utilities;

import com.ibm.cics.cm.utilities.SelectionProvider;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;

public class TableSelectionProvider
extends SelectionProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Table table;
    private String dataKey;
    private boolean multipleSelections;

    public TableSelectionProvider(Table aTable) {
        this(aTable, null);
    }

    public TableSelectionProvider(Table aTable, String aDataKey) {
        this.table = aTable;
        this.dataKey = aDataKey;
        aTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object resource = null;
                ArrayList<Object> resources = null;
                if (TableSelectionProvider.this.table.getSelectionCount() == 1) {
                    resource = TableSelectionProvider.this.dataKey == null ? TableSelectionProvider.this.table.getSelection()[0].getData() : TableSelectionProvider.this.table.getSelection()[0].getData(TableSelectionProvider.this.dataKey);
                } else if (TableSelectionProvider.this.multipleSelections) {
                    int selectionCount = TableSelectionProvider.this.table.getSelectionCount();
                    resources = new ArrayList<Object>();
                    int i = 0;
                    while (i < selectionCount) {
                        Object selection = TableSelectionProvider.this.dataKey == null ? TableSelectionProvider.this.table.getSelection()[i].getData() : TableSelectionProvider.this.table.getSelection()[i].getData(TableSelectionProvider.this.dataKey);
                        resources.add(selection);
                        ++i;
                    }
                }
                if (resource == null) {
                    if (resources != null) {
                        TableSelectionProvider.this.setSelection((ISelection)new StructuredSelection(resources));
                    } else {
                        TableSelectionProvider.this.setSelection((ISelection)StructuredSelection.EMPTY);
                    }
                } else {
                    TableSelectionProvider.this.setSelection((ISelection)new StructuredSelection(resource));
                }
            }
        });
    }

    public void allowMultipleSelections(boolean allowMultipleSelections) {
        this.multipleSelections = allowMultipleSelections;
    }
}

