/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.utilities;

import com.ibm.cics.common.util.Debug;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public abstract class SelectionProvider
implements ISelectionProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger("com.ibm.cics.cm.ui");
    private static final Debug debug = new Debug(SelectionProvider.class);
    List listeners = new ArrayList();
    ISelection theSelection = StructuredSelection.EMPTY;

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        return this.theSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        Debug.enter((Logger)logger, (String)SelectionProvider.class.getName(), (String)"setSelection", (Object)this, (Object)selection);
        this.theSelection = selection;
        final SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] listenersArray = this.listeners.toArray();
        int i = 0;
        while (i < listenersArray.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listenersArray[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    l.selectionChanged(e);
                }
            });
            ++i;
        }
        Debug.exit((Logger)logger, (String)SelectionProvider.class.getName(), (String)"setSelection", (Object)this);
    }
}

