/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListeningArrayList<E>
extends ArrayList<E> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long serialVersionUID = 7291398959673754272L;
    private List<ArrayListListener> listeners = new ArrayList<ArrayListListener>();

    @Override
    public boolean add(E e) {
        boolean ret = super.add(e);
        this.notifyListeners(true);
        return ret;
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        this.notifyListeners(true);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean ret = super.addAll(c);
        this.notifyListeners(true);
        return ret;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean ret = super.addAll(index, c);
        this.notifyListeners(true);
        return ret;
    }

    @Override
    public void clear() {
        super.clear();
        this.notifyListeners(true);
    }

    @Override
    public E remove(int index) {
        Object obj = super.remove(index);
        this.notifyListeners(true);
        return obj;
    }

    @Override
    public boolean remove(Object o) {
        boolean ret = super.remove(o);
        this.notifyListeners(true);
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret = this.removeAll(c);
        this.notifyListeners(true);
        return ret;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
        this.notifyListeners(true);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean ret = super.retainAll(c);
        this.notifyListeners(true);
        return ret;
    }

    @Override
    public E set(int index, E element) {
        E e = super.set(index, element);
        this.notifyListeners(true);
        return e;
    }

    public boolean addListener(ArrayListListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(ArrayListListener arrayListListener) {
        return this.listeners.remove(arrayListListener);
    }

    private void notifyListeners(boolean changed) {
        for (ArrayListListener next : this.listeners) {
            next.notify(changed, this);
        }
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    public abstract class ArrayListListener {
        private ListeningArrayList<E> host;

        public ArrayListListener(ListeningArrayList<E> next) {
            this.host = next;
        }

        public abstract void notify(boolean var1, ListeningArrayList<?> var2);

        public void dispose() {
            this.host.removeListener(this);
        }
    }
}

