/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.utilities;

import com.ibm.cics.cm.model.CSDConfiguration;
import com.ibm.cics.cm.model.ConfigurationConnection;
import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class CSDConnectionsForConfigurationContentProposalProvider
implements IContentProposalProvider,
Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Thread fetchingThread;
    List<Listener> listeners = new ArrayList<Listener>();
    private CSDConfiguration configuration;

    public void addListener(Listener aListener) {
        this.listeners.add(aListener);
    }

    public void remoteListener(Listener aListener) {
        this.listeners.remove(aListener);
    }

    public IContentProposal[] getProposals(String contents, int position) {
        if (this.configuration != null && ConfigurationManager.getCurrent().getConnection() != null && ConfigurationManager.getCurrent().getConnection().isConnected()) {
            ArrayList<1> result = new ArrayList<1>();
            List connections = this.configuration.getConnections();
            for (final ConfigurationConnection connection : connections) {
                if (!connection.getName().startsWith(contents)) continue;
                IContentProposal proposal = new IContentProposal(){

                    public String getContent() {
                        return connection.getName();
                    }

                    public int getCursorPosition() {
                        return connection.getName().length();
                    }

                    public String getDescription() {
                        return null;
                    }

                    public String getLabel() {
                        return String.valueOf(connection.getName()) + " (" + connection.getApplid() + ")";
                    }
                };
                result.add(proposal);
            }
            Collections.sort(result, new CSDConnectionProposalComparator());
            return result.toArray(new IContentProposal[0]);
        }
        return new IContentProposal[0];
    }

    public void setConfiguration(CSDConfiguration configuration) {
        this.configuration = configuration;
    }

    private class CSDConnectionProposalComparator
    implements Comparator<IContentProposal> {
        private CSDConnectionProposalComparator() {
        }

        @Override
        public int compare(IContentProposal prop0, IContentProposal prop1) {
            return prop0.getLabel().compareTo(prop1.getLabel());
        }
    }

    public static interface Listener {
        public void dataAvailable();
    }
}

