/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.wizards;

import com.ibm.cics.cm.model.ZfsDefinition;
import com.ibm.cics.cm.model.builder.ZfsDefinitionBuilder;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.editors.ZfsDefinitionEditorInput;
import com.ibm.cics.cm.ui.views.ZfsDefinitionsView;
import com.ibm.cics.cm.ui.wizards.NewZfsDefinitionPage;
import com.ibm.cics.cm.ui.wizards.NoConnectionPage;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class NewZfsDefinitionWizard
extends Wizard
implements INewWizard {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2017, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected NewZfsDefinitionPage basicPage = null;
    protected ZfsDefinition newFromZfsDefinition = null;
    private boolean complete = false;
    private NoConnectionPage noConnectionPage;

    public NewZfsDefinitionWizard() {
        this.setWindowTitle(Messages.getString("ZfsDefinitionWizard.new"));
    }

    public NewZfsDefinitionWizard(ZfsDefinition newFromZfsDefinition) {
        this.newFromZfsDefinition = newFromZfsDefinition;
        this.setWindowTitle(MessageFormat.format(Messages.getString("ZfsDefinitionWizard.newfrom"), newFromZfsDefinition.getName()));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        if (ConfigurationManager.getCurrent().getConnection() == null || !ConfigurationManager.getCurrent().getConnection().isConnected()) {
            this.noConnectionPage = new NoConnectionPage();
            this.addPage((IWizardPage)this.noConnectionPage);
        } else {
            this.basicPage = this.newFromZfsDefinition != null ? new NewZfsDefinitionPage(this.newFromZfsDefinition) : new NewZfsDefinitionPage();
            this.addPage((IWizardPage)this.basicPage);
        }
    }

    public boolean canFinish() {
        return this.complete;
    }

    public boolean performFinish() {
        ZfsDefinition newDef;
        block6: {
            newDef = null;
            try {
                newDef = this.createZfsDefinition();
            }
            catch (CMServerException e) {
                if (!e.isError()) break block6;
                this.basicPage.setServerError(e);
                return false;
            }
        }
        final ZfsDefinition zfsDef = newDef;
        final ZfsDefinitionsView zfsDefinitionsView = UIActivator.getZfsDefinitionsView();
        if (zfsDef != null && zfsDefinitionsView != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    zfsDefinitionsView.add(zfsDef);
                    IWorkbenchPartSite wPartSite = zfsDefinitionsView.getSite();
                    if (wPartSite != null && wPartSite instanceof IViewSite) {
                        ((IViewSite)wPartSite).getActionBars().getStatusLineManager().setMessage(null);
                    }
                }
            });
        }
        if (this.basicPage.getOpenEditor() && newDef != null) {
            ZfsDefinitionEditorInput input = new ZfsDefinitionEditorInput(newDef);
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, "com.ibm.cics.cm.ui.zfsdefinition.editor");
            }
            catch (PartInitException pie) {
                throw new RuntimeException(pie);
            }
        }
        return true;
    }

    public boolean needsPreviousAndNextButtons() {
        return false;
    }

    protected void setCanFinish(boolean finish) {
        this.complete = finish;
    }

    private ZfsDefinition createZfsDefinition() throws CMServerException {
        ZfsDefinitionBuilder builder = new ZfsDefinitionBuilder(this.basicPage.getDefinitionName(), this.basicPage.getDefinitionDescription(), this.basicPage.getConfigurationName(), this.basicPage.getRelativePath());
        if (this.newFromZfsDefinition != null) {
            builder.setData1(this.newFromZfsDefinition.getData1());
            builder.setData2(this.newFromZfsDefinition.getData2());
            builder.setData3(this.newFromZfsDefinition.getData3());
            builder.setData4(this.newFromZfsDefinition.getData4());
        }
        return builder.create(ConfigurationManager.getCurrent());
    }
}

