/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.wizards;

import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.ZfsConfiguration;
import com.ibm.cics.cm.model.ZfsDefinition;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.composites.NameDescriptionComposite;
import com.ibm.cics.cm.ui.composites.OpenEditorComposite;
import com.ibm.cics.cm.ui.dialogs.BrowseZfsDialog;
import com.ibm.cics.cm.ui.wizards.NewZfsDefinitionWizard;
import com.ibm.cics.cm.utilities.Utilities;
import com.ibm.cics.core.ui.UIHelper;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewZfsDefinitionPage
extends WizardPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2017, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ZfsDefinition newFromDefinition;
    private List<String> zfsDefinitionsList;
    private Composite base;
    private Combo configurationCombo;
    private ZfsConfiguration selectedConfig;
    private Text nameText;
    private Text descText;
    private Text pathText;
    private Button openEditor;
    boolean haveConfigs = true;

    protected NewZfsDefinitionPage() {
        super("Details");
        this.setImageDescriptor(UIActivator.IMG_ZFS_DEFINITION_NEW_WIZARD);
    }

    protected NewZfsDefinitionPage(ZfsDefinition def) {
        this();
        this.newFromDefinition = def;
    }

    protected String getDefinitionName() {
        return this.nameText.getText();
    }

    protected String getDefinitionDescription() {
        return this.descText.getText();
    }

    protected String getConfigurationName() {
        return this.configurationCombo.getText();
    }

    protected String getRelativePath() {
        return this.pathText.getText();
    }

    protected boolean getOpenEditor() {
        return this.openEditor.getSelection();
    }

    public void createControl(Composite parent) {
        this.base = new Composite(parent, 0);
        GridLayout gLayout = new GridLayout(3, false);
        gLayout.marginTop = 5;
        gLayout.marginRight = 5;
        gLayout.marginLeft = 5;
        gLayout.horizontalSpacing = 10;
        this.base.setLayout((Layout)gLayout);
        this.setPageComplete(false);
        NameDescriptionComposite nameDesc = new NameDescriptionComposite(this.base, 0);
        nameDesc.setLayoutData(new GridData(4, -1, true, false, 3, 1));
        this.nameText = nameDesc.nameText;
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewZfsDefinitionPage.this.validateInputs();
            }
        });
        this.nameText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                NewZfsDefinitionPage.this.validateInputs();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.descText = nameDesc.descText;
        Label label = new Label(this.base, 0);
        label.setText(Messages.getString("zfsDefinition.configuration"));
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Utilities.addMandatoryField((Control)label);
        this.configurationCombo = new Combo(this.base, 8);
        this.configurationCombo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        IFilteredCollection confs = ConfigurationManager.getCurrent().getConfigurations();
        ArrayList<String> confNames = new ArrayList<String>();
        for (Configuration conf : confs) {
            if (!(conf instanceof ZfsConfiguration)) continue;
            confNames.add(conf.getName());
        }
        Collections.sort(confNames);
        for (String confName : confNames) {
            this.configurationCombo.add(confName);
        }
        if (this.configurationCombo.getItemCount() < 1) {
            this.haveConfigs = false;
            this.configurationCombo.add(Messages.getString("MigrationPath.dialog.no_configurations"));
        }
        label = new Label(this.base, 0);
        label.setText(Messages.getString("zfsDefinition.location"));
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        final Label loc = new Label(this.base, 0);
        loc.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.configurationCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewZfsDefinitionPage.this.selectedConfig = (ZfsConfiguration)ConfigurationManager.getCurrent().getConfiguration(NewZfsDefinitionPage.this.configurationCombo.getText());
                loc.setText(NewZfsDefinitionPage.this.selectedConfig.getZfsRootDir());
                NewZfsDefinitionPage.this.getZfsDefinitionsList(NewZfsDefinitionPage.this.configurationCombo.getText());
                NewZfsDefinitionPage.this.validateInputs();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label(this.base, 0);
        label.setText(Messages.getString("zfsDefinition.path"));
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Utilities.addMandatoryField((Control)label);
        TextInput input = new TextInput(this.base, label);
        input.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pathText = input.text;
        this.pathText.setTextLimit(255);
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewZfsDefinitionPage.this.validateInputs();
            }
        });
        Button zfsBrowseButton = new Button(this.base, 8);
        zfsBrowseButton.setText(Messages.getString("BrowseZfs.buttonText"));
        zfsBrowseButton.setLayoutData((Object)new GridData(16384, -1, false, false));
        zfsBrowseButton.setEnabled(true);
        zfsBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowseZfsDialog dialog = new BrowseZfsDialog(NewZfsDefinitionPage.this.getShell(), NewZfsDefinitionPage.this.selectedConfig, "RelativePath");
                if (dialog.open() == 0) {
                    NewZfsDefinitionPage.this.pathText.setText(dialog.getSelectedPath());
                }
            }
        });
        this.openEditor = new OpenEditorComposite((Composite)this.base, (int)0).openEditor;
        this.openEditor.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        this.setTitle(Messages.getString("ZfsDefinitionWizardDetailsPage.title"));
        this.setDescription(Messages.getString("ZfsDefinitionWizardDetailsPage.description"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), this.getHelpContextID());
        this.setControl((Control)this.base);
        if (this.newFromDefinition != null) {
            this.nameText.setText(this.newFromDefinition.getName());
            this.descText.setText(this.newFromDefinition.getDescription());
            this.pathText.setText(this.newFromDefinition.getRelPath());
            this.configurationCombo.setText(this.newFromDefinition.getConfigurationName());
        } else {
            Object firstElement;
            ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection("com.ibm.cics.cm.view.configurations");
            if (selection != null && selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof ZfsConfiguration) {
                this.configurationCombo.setText(((ZfsConfiguration)firstElement).getName());
            }
        }
        if (this.haveConfigs) {
            this.selectedConfig = (ZfsConfiguration)ConfigurationManager.getCurrent().getConfiguration(this.configurationCombo.getText());
            loc.setText(this.selectedConfig.getZfsRootDir());
            this.getZfsDefinitionsList(this.configurationCombo.getText());
            this.validateInputs();
        } else {
            zfsBrowseButton.setEnabled(false);
        }
        this.validateInputs();
        if (this.newFromDefinition == null) {
            this.setErrorMessage(null);
            UIHelper.clearError((Control)this.nameText);
        }
    }

    private String getHelpContextID() {
        return "com.ibm.cics.cm.ui.wizard_newconfiguration";
    }

    private void getZfsDefinitionsList(String configName) {
        List zfsDefs = ConfigurationManager.getCurrent().getZfsDefinitions(LocationCriteria.newConfigurationLocationCriteria((String)configName)).getResults();
        this.zfsDefinitionsList = new ArrayList<String>();
        if (zfsDefs != null) {
            for (ZfsDefinition zfsDef : zfsDefs) {
                this.zfsDefinitionsList.add(zfsDef.getName());
            }
        }
    }

    protected void validateInputs() {
        String errorMessage = null;
        String name = this.nameText.getText();
        if (name.isEmpty() || !name.matches("[A-Z0-9$@#]{1,8}")) {
            errorMessage = Messages.getString("ZfsDefinitionWizardDetailsPage.errorMessage.name");
            this.setErrorMessage(errorMessage);
            UIHelper.errorControl((Control)this.nameText, (String)errorMessage);
        } else {
            UIHelper.clearError((Control)this.nameText);
            if (this.zfsDefinitionsList != null && this.zfsDefinitionsList.contains(name)) {
                errorMessage = Messages.getString("ZfsDefinitionWizardDetailsPage.errorMessage.duplicateName");
                this.setErrorMessage(errorMessage);
                UIHelper.errorControl((Control)this.nameText, (String)errorMessage);
            } else {
                String relativePath = this.pathText.getText();
                if (relativePath.isEmpty()) {
                    errorMessage = Messages.getString("ZfsDefinitionWizardDetailsPage.errorMessage.relativePath.empty");
                    this.setErrorMessage(errorMessage);
                    UIHelper.errorControl((Control)this.pathText, (String)errorMessage);
                } else if (!relativePath.matches("[A-Za-z0-9$@#\\./-_%&?!:|\"=,;<> ]{1,255}")) {
                    errorMessage = MessageFormat.format(Messages.getString("ZfsDirectoryDefinitions.errorMessage.chars"), Messages.getString("ZfsDefinitionsView.column.path"));
                    this.setErrorMessage(errorMessage);
                    UIHelper.errorControl((Control)this.pathText, (String)errorMessage);
                } else if (relativePath.startsWith("/")) {
                    errorMessage = Messages.getString("ZfsDefinitionWizardDetailsPage.errorMessage.mustNotStart");
                    this.setErrorMessage(errorMessage);
                    UIHelper.errorControl((Control)this.pathText, (String)errorMessage);
                } else if (relativePath.matches(".*//.*")) {
                    errorMessage = MessageFormat.format(Messages.getString("ZfsDirectoryDefinitions.errorMessage.slash"), Messages.getString("ZfsDefinitionsView.column.path"));
                    this.setErrorMessage(errorMessage);
                    UIHelper.errorControl((Control)this.pathText, (String)errorMessage);
                } else {
                    UIHelper.clearError((Control)this.pathText);
                }
            }
        }
        NewZfsDefinitionWizard wizard = (NewZfsDefinitionWizard)this.getWizard();
        if (errorMessage == null) {
            if (this.haveConfigs) {
                this.setPageComplete(true);
                wizard.setCanFinish(true);
            }
            this.setErrorMessage(null);
        } else {
            this.setPageComplete(false);
            wizard.setCanFinish(false);
        }
        wizard.getContainer().updateButtons();
    }

    public void setServerError(CMServerException e) {
        String errorMessage;
        Text field = null;
        if (e.isZfsFileNotFound()) {
            errorMessage = Messages.getString("ZfsDefinitionWizardDetailsPage.errorMessage.relativePath.notFound");
            field = this.pathText;
        } else if (e.isZfsPathAlreadyDefined()) {
            errorMessage = Messages.getString("ZfsDefinitionWizardDetailsPage.errorMessage.relativePath.alreadyDefined");
            field = this.pathText;
        } else {
            UIHelper.clearError((Control)this.pathText);
            errorMessage = MessageFormat.format(Messages.getString("ZfsDefinitionWizardDetailsPage.errorMessage.genericServer"), e.getMessage());
        }
        this.setErrorMessage(errorMessage);
        if (field != null) {
            UIHelper.errorControl((Control)this.pathText, (String)errorMessage);
        }
    }
}

