/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.wizards;

import com.ibm.cics.cm.model.MigrationPath;
import com.ibm.cics.cm.model.MigrationScheme;
import com.ibm.cics.cm.model.TransformationVariable;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.composites.MigrationPathsComposite;
import com.ibm.cics.cm.ui.composites.NameDescriptionComposite;
import com.ibm.cics.cm.ui.composites.OpenEditorComposite;
import com.ibm.cics.cm.ui.wizards.MigrationSchemeWizardPage;
import com.ibm.cics.cm.utilities.ListeningArrayList;
import com.ibm.cics.core.ui.UIHelper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewMigrationSchemePage
extends MigrationSchemeWizardPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Composite base;
    private Text nameText;
    private Text descText;
    private Button openEditor;
    private MigrationScheme scheme;
    private List<String> currentMigrationSchemeNames;
    private Button approval;
    private MigrationPathsComposite paths;
    private ArrayList<TransformationVariable> x_variables;

    protected NewMigrationSchemePage() {
        super("Details");
        this.setImageDescriptor(UIActivator.IMGD520_MIGRATION_SCHEME_NEW_WIZARD);
        this.currentMigrationSchemeNames = ConfigurationManager.getCurrent().getMigrationSchemeNameList();
    }

    protected NewMigrationSchemePage(MigrationScheme scheme) {
        this();
        this.scheme = scheme;
    }

    protected String getMigrationSchemeName() {
        return this.nameText.getText();
    }

    protected String getMigrationSchemeDescription() {
        return this.descText.getText();
    }

    protected boolean getApproval() {
        return this.approval.getSelection();
    }

    protected ArrayList<MigrationPath> getMigrationPaths() {
        return this.paths.getMigrationPaths();
    }

    protected ArrayList<TransformationVariable> getTransformationVariables() {
        return this.x_variables;
    }

    public void createControl(Composite parent) {
        this.base = new Composite(parent, 0);
        GridLayout gLayout = new GridLayout(1, false);
        gLayout.marginTop = 5;
        gLayout.marginBottom = 5;
        gLayout.marginRight = 5;
        gLayout.marginLeft = 5;
        gLayout.marginWidth = 0;
        gLayout.horizontalSpacing = 10;
        this.base.setLayout((Layout)gLayout);
        this.base.setLayoutData((Object)new GridData(4, 4, true, false));
        this.setPageComplete(false);
        NameDescriptionComposite nameDesc = new NameDescriptionComposite(this.base, 0);
        nameDesc.setLayoutData(new GridData(4, -1, true, false));
        this.nameText = nameDesc.nameText;
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMigrationSchemePage.this.validateInputs();
            }
        });
        this.nameText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                NewMigrationSchemePage.this.validateInputs();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.descText = nameDesc.descText;
        Label approvalDescription = new Label(this.base, 64);
        approvalDescription.setText(Messages.getString("MigrationSchemeWizardPage.field.approval.description"));
        GridData rd = new GridData(4, 16384, true, false);
        rd.widthHint = 100;
        approvalDescription.setLayoutData((Object)rd);
        this.approval = new Button(this.base, 32);
        this.approval.setLayoutData((Object)new GridData(16384, 128, true, false));
        this.approval.setText(Messages.getString("MigrationSchemeWizardPage.field.approval"));
        this.approval.setSelection(false);
        this.paths = new MigrationPathsComposite(this.base, 0);
        this.paths.setLayoutData(new GridData(4, 4, true, true));
        ArrayList<MigrationPath> migrationPaths = this.paths.getMigrationPaths();
        if (migrationPaths instanceof ListeningArrayList) {
            ListeningArrayList lMigrationPaths;
            ListeningArrayList listeningArrayList = lMigrationPaths = (ListeningArrayList)migrationPaths;
            listeningArrayList.getClass();
            lMigrationPaths.addListener(new ListeningArrayList.ArrayListListener(listeningArrayList, lMigrationPaths){

                @Override
                public void notify(boolean changed, ListeningArrayList<?> source) {
                    NewMigrationSchemePage.this.validateInputs();
                }
            });
        }
        this.openEditor = new OpenEditorComposite((Composite)this.base, (int)0).openEditor;
        this.openEditor.setLayoutData((Object)new GridData(4, 128, true, false));
        this.openEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewMigrationSchemePage.this.getMigrationSchemeWizard().setOpenEditor(NewMigrationSchemePage.this.openEditor.getSelection());
            }
        });
        this.setTitle(Messages.getString("MigrationSchemeWizard.new"));
        this.setDescription(Messages.getString("MigrationSchemeWizardPage.description"));
        if (this.scheme != null) {
            this.descText.setText(this.scheme.getDescription());
            this.approval.setSelection(this.scheme.getApproval());
            this.paths.setInput(this.scheme.getMigrationPaths());
            this.x_variables = this.scheme.getTranformationVariables();
        }
        this.validateInputs();
        this.setErrorMessage(null);
        UIHelper.clearError((Control)this.nameText);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), this.getHelpContextID());
        this.setControl((Control)this.base);
    }

    private String getHelpContextID() {
        return "com.ibm.cics.cm.ui.wizard_newmigrationscheme";
    }

    protected void validateInputs() {
        if (this.getMigrationSchemeName().isEmpty() || !this.getMigrationSchemeName().matches("[A-Z0-9$@#_-]{1,8}")) {
            this.setErrorMessage(Messages.getString("MigrationSchemeWizardPage.errorMessage.configurationName"));
            UIHelper.errorControl((Control)this.nameText, (String)Messages.getString("MigrationSchemeWizardPage.errorMessage.configurationName"));
        } else if (this.currentMigrationSchemeNames.contains(this.getMigrationSchemeName())) {
            this.setErrorMessage(Messages.getString("MigrationSchemeWizardPage.errorMessage.duplicateName"));
            UIHelper.errorControl((Control)this.nameText, (String)Messages.getString("MigrationSchemeWizardPage.errorMessage.duplicateName"));
        } else {
            UIHelper.clearError((Control)this.nameText);
            if (this.paths == null || this.getMigrationPaths().isEmpty()) {
                this.setErrorMessage(Messages.getString("MigrationSchemeWizardPage.errorMessage.noMigrationPaths"));
                UIHelper.errorControl((Control)this.paths.viewer.getTable(), (String)Messages.getString("MigrationSchemeWizardPage.errorMessage.noMigrationPaths"));
            } else {
                UIHelper.clearError((Control)this.paths.viewer.getTable());
            }
        }
        if (!UIHelper.hasError((Control)this.nameText) && !UIHelper.hasError((Control)this.paths.viewer.getTable())) {
            this.setPageComplete(true);
            this.getMigrationSchemeWizard().setCanFinish(true);
            this.setErrorMessage(null);
        } else {
            this.setPageComplete(false);
            this.getMigrationSchemeWizard().setCanFinish(false);
        }
        this.getMigrationSchemeWizard().getContainer().updateButtons();
    }
}

