/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.wizards;

import com.ibm.cics.cm.model.CPSMConfiguration;
import com.ibm.cics.cm.model.CSDConfiguration;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ZfsConfiguration;
import com.ibm.cics.cm.model.runtime.CMConnection;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.EnsureUppercaseListener;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.composites.NameDescriptionComposite;
import com.ibm.cics.cm.ui.composites.OpenEditorComposite;
import com.ibm.cics.cm.ui.composites.ZfsBackupControls;
import com.ibm.cics.cm.ui.dialogs.BrowseZfsDialog;
import com.ibm.cics.cm.ui.wizards.ConfigurationWizardPage;
import com.ibm.cics.cm.ui.wizards.NewConfigurationWizard;
import com.ibm.cics.cm.utilities.Utilities;
import com.ibm.cics.core.ui.UIHelper;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewConfigurationPage
extends ConfigurationWizardPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Composite base;
    private Text nameText;
    private Text descText;
    private Text cpsmText;
    private Text csdText;
    private Text zfsText;
    private TextInput cpsmInput;
    private TextInput csdInput;
    private TextInput zfsInput;
    private Combo csdRLSCombo;
    private Label csdFileLabel;
    private Label rlsLabel;
    private Button backup;
    private Spinner backupCount;
    private Text backupDirText;
    private Button openEditor;
    private Configuration configuration;
    private List<String> currentConfigurationNames;
    private ControlDecoration cpsmDec;
    private ControlDecoration csdFileDec;
    private ControlDecoration rlsDec;
    private ControlDecoration zfsDec;

    protected NewConfigurationPage() {
        super("Details");
        this.setImageDescriptor(UIActivator.IMGD520_CONFIGURATIONS_NEW_WIZARD);
        this.currentConfigurationNames = ConfigurationManager.getCurrent().getConfigurationsNameList();
    }

    protected NewConfigurationPage(Configuration config) {
        this();
        this.configuration = config;
    }

    protected String getConfigName() {
        return this.nameText.getText();
    }

    protected String getConfigDescription() {
        return this.descText.getText();
    }

    protected String getConfigCPSMContext() {
        return this.cpsmText.getText();
    }

    protected String getConfigCSDName() {
        return this.csdText.getText();
    }

    protected String getConfigZfsName() {
        return this.zfsText.getText();
    }

    protected String getConfigCSDRLS() {
        return this.csdRLSCombo.getText();
    }

    protected boolean getConfigZfsBackup() {
        return this.backup.getSelection();
    }

    protected int getConfigZfsBackupCount() {
        return this.backupCount.getSelection();
    }

    protected String getConfigZfsBackupDir() {
        return this.backupDirText.getText();
    }

    public void createControl(Composite parent) {
        this.base = new Composite(parent, 0);
        GridLayout gLayout = new GridLayout(2, false);
        gLayout.marginTop = 5;
        gLayout.marginRight = 5;
        gLayout.marginLeft = 5;
        gLayout.horizontalSpacing = 10;
        this.base.setLayout((Layout)gLayout);
        this.setPageComplete(false);
        NameDescriptionComposite nameDesc = new NameDescriptionComposite(this.base, 0);
        nameDesc.setLayoutData(new GridData(4, -1, true, false, 2, 1));
        this.nameText = nameDesc.nameText;
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewConfigurationPage.this.validateInputs();
            }
        });
        this.nameText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                NewConfigurationPage.this.validateInputs();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.descText = nameDesc.descText;
        Group typeGroup = new Group(this.base, 1);
        typeGroup.setText(Messages.getString("ConfigurationWizard.typeGroupText"));
        GridData typeGroupGridData = new GridData(4, 0x1000000, true, false, 2, 1);
        typeGroupGridData.verticalIndent = 10;
        typeGroup.setLayoutData((Object)typeGroupGridData);
        GridLayout groupLayout = new GridLayout(3, false);
        groupLayout.marginLeft = 10;
        groupLayout.marginRight = 10;
        groupLayout.marginTop = 10;
        groupLayout.marginBottom = 10;
        groupLayout.horizontalSpacing = 10;
        typeGroup.setLayout((Layout)groupLayout);
        final Button cpsmButton = new Button((Composite)typeGroup, 16);
        cpsmButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.cpsmDec = Utilities.addMandatoryField((Control)cpsmButton);
        cpsmButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (cpsmButton.getSelection()) {
                    NewConfigurationPage.this.cpsmInput.setEnabled(true);
                    NewConfigurationPage.this.cpsmDec.show();
                    NewConfigurationPage.this.getConfigWizard().setConfigurationType(NewConfigurationWizard.ConfigurationType.CPSM);
                    NewConfigurationPage.this.validateInputs();
                } else {
                    NewConfigurationPage.this.cpsmInput.setEnabled(false);
                    NewConfigurationPage.this.cpsmDec.hide();
                }
            }
        });
        cpsmButton.setText(Messages.getString("Configuration.cpsm.context"));
        cpsmButton.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (NewConfigurationPage.this.cpsmInput.isEnabled()) {
                    NewConfigurationPage.this.cpsmDec.show();
                } else {
                    NewConfigurationPage.this.cpsmDec.hide();
                }
            }
        });
        this.cpsmInput = new TextInput((Composite)typeGroup, cpsmButton.getText());
        this.cpsmInput.setEnabled(false);
        int cpsmBoxLimit = 8;
        this.cpsmInput.setNumberOfCharacters(cpsmBoxLimit);
        this.cpsmInput.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.cpsmText = this.cpsmInput.text;
        this.cpsmText.setTextLimit(cpsmBoxLimit);
        this.cpsmText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewConfigurationPage.this.validateInputs();
            }
        });
        this.cpsmText.addVerifyListener((VerifyListener)EnsureUppercaseListener.getSingleton());
        final Button csdButton = new Button((Composite)typeGroup, 16);
        csdButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        csdButton.setSelection(false);
        csdButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (csdButton.getSelection()) {
                    NewConfigurationPage.this.csdFileLabel.setEnabled(true);
                    NewConfigurationPage.this.csdFileDec.show();
                    NewConfigurationPage.this.csdInput.setEnabled(true);
                    NewConfigurationPage.this.rlsLabel.setEnabled(true);
                    NewConfigurationPage.this.rlsDec.show();
                    NewConfigurationPage.this.csdRLSCombo.setEnabled(true);
                    NewConfigurationPage.this.getConfigWizard().setConfigurationType(NewConfigurationWizard.ConfigurationType.CSD);
                    NewConfigurationPage.this.validateInputs();
                } else {
                    NewConfigurationPage.this.csdFileLabel.setEnabled(false);
                    NewConfigurationPage.this.csdFileDec.hide();
                    NewConfigurationPage.this.csdInput.setEnabled(false);
                    NewConfigurationPage.this.rlsLabel.setEnabled(false);
                    NewConfigurationPage.this.rlsDec.hide();
                    NewConfigurationPage.this.csdRLSCombo.setEnabled(false);
                }
            }
        });
        csdButton.setText(Messages.getString("ConfigurationWizard.csdText"));
        this.csdFileLabel = new Label((Composite)typeGroup, 0);
        this.csdFileLabel.setText(Messages.getString("Configuration.csd.file"));
        GridData csdFileLabelGridData = new GridData(16384, 0x1000000, false, false);
        csdFileLabelGridData.horizontalIndent = 20;
        this.csdFileLabel.setLayoutData((Object)csdFileLabelGridData);
        this.csdFileLabel.setEnabled(false);
        this.csdFileDec = Utilities.addMandatoryField((Control)this.csdFileLabel);
        this.csdFileLabel.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (NewConfigurationPage.this.csdFileLabel.isEnabled()) {
                    NewConfigurationPage.this.csdFileDec.show();
                } else {
                    NewConfigurationPage.this.csdFileDec.hide();
                }
            }
        });
        this.csdInput = new TextInput((Composite)typeGroup, this.csdFileLabel);
        this.csdInput.setEnabled(false);
        int csdBoxLimit = 44;
        this.csdInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.csdText = this.csdInput.text;
        this.csdText.setTextLimit(csdBoxLimit);
        this.csdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewConfigurationPage.this.validateInputs();
            }
        });
        this.csdText.addVerifyListener((VerifyListener)EnsureUppercaseListener.getSingleton());
        this.rlsLabel = new Label((Composite)typeGroup, 0);
        this.rlsLabel.setText(Messages.getString("Configuration.csd.rlsaccess"));
        GridData csdRLSLabelGridData = new GridData(16384, 0x1000000, false, false);
        csdRLSLabelGridData.horizontalIndent = 20;
        this.rlsLabel.setLayoutData((Object)csdRLSLabelGridData);
        this.rlsLabel.setEnabled(false);
        this.rlsDec = Utilities.addMandatoryField((Control)this.rlsLabel);
        this.rlsLabel.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (NewConfigurationPage.this.rlsLabel.isEnabled()) {
                    NewConfigurationPage.this.rlsDec.show();
                } else {
                    NewConfigurationPage.this.rlsDec.hide();
                }
            }
        });
        this.csdRLSCombo = new Combo((Composite)typeGroup, 8);
        this.csdRLSCombo.setItems(new String[]{"DYNAMIC", "NOTRLS", "RLS"});
        this.csdRLSCombo.setEnabled(false);
        this.csdRLSCombo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.csdRLSCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewConfigurationPage.this.validateInputs();
            }
        });
        final Button zfsButton = new Button((Composite)typeGroup, 16);
        zfsButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.zfsDec = Utilities.addMandatoryField((Control)zfsButton);
        zfsButton.setText(Messages.getString("Configuration.zfs.configType"));
        zfsButton.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (NewConfigurationPage.this.zfsInput.isEnabled()) {
                    NewConfigurationPage.this.zfsDec.show();
                } else {
                    NewConfigurationPage.this.zfsDec.hide();
                }
            }
        });
        this.zfsInput = new TextInput((Composite)typeGroup, zfsButton.getText());
        this.zfsInput.setEnabled(false);
        int zfsBoxLimit = 255;
        this.zfsInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.zfsText = this.zfsInput.text;
        this.zfsText.setTextLimit(zfsBoxLimit);
        this.zfsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewConfigurationPage.this.validateInputs();
            }
        });
        this.zfsText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                String text;
                if (!UIHelper.hasError((Control)NewConfigurationPage.this.zfsText) && !(text = NewConfigurationPage.this.zfsText.getText()).endsWith("/")) {
                    NewConfigurationPage.this.zfsText.setText(String.valueOf(text) + "/");
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        final Button zfsBrowseButton = new Button((Composite)typeGroup, 8);
        zfsBrowseButton.setText(Messages.getString("BrowseZfs.buttonText"));
        zfsBrowseButton.setLayoutData((Object)new GridData(16384, -1, false, false));
        zfsBrowseButton.setEnabled(false);
        zfsBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowseZfsDialog dialog = new BrowseZfsDialog(NewConfigurationPage.this.getShell(), null, "RootDir");
                if (dialog.open() == 0) {
                    NewConfigurationPage.this.zfsText.setText(dialog.getSelectedPath());
                }
            }
        });
        Composite zfsOptionsArea = new Composite((Composite)typeGroup, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 15;
        zfsOptionsArea.setLayout((Layout)layout);
        GridData zfsOptionsGrid = new GridData(4, -1, true, false, 3, 1);
        zfsOptionsGrid.horizontalIndent = 20;
        zfsOptionsArea.setLayoutData((Object)zfsOptionsGrid);
        final ZfsBackupControls backupComposite = new ZfsBackupControls(zfsOptionsArea, 0, null);
        this.backup = backupComposite.backup;
        this.backup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewConfigurationPage.this.validateInputs();
            }
        });
        this.backupCount = backupComposite.backupCount;
        this.backupDirText = backupComposite.backupDirText;
        this.backupDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewConfigurationPage.this.validateInputs();
            }
        });
        backupComposite.setEnabled(false);
        if (CMConnection.apiLevel.compareTo("CCV540") < 0) {
            zfsButton.setEnabled(false);
        } else {
            zfsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (zfsButton.getSelection()) {
                        NewConfigurationPage.this.zfsInput.setEnabled(true);
                        zfsBrowseButton.setEnabled(true);
                        backupComposite.setEnabled(true);
                        NewConfigurationPage.this.zfsDec.show();
                        NewConfigurationPage.this.getConfigWizard().setConfigurationType(NewConfigurationWizard.ConfigurationType.ZFS);
                        NewConfigurationPage.this.validateInputs();
                    } else {
                        NewConfigurationPage.this.zfsInput.setEnabled(false);
                        zfsBrowseButton.setEnabled(false);
                        backupComposite.setEnabled(false);
                        NewConfigurationPage.this.zfsDec.hide();
                    }
                }
            });
        }
        this.openEditor = new OpenEditorComposite((Composite)this.base, (int)0).openEditor;
        this.openEditor.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        this.openEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewConfigurationPage.this.getConfigWizard().setOpenEditor(NewConfigurationPage.this.openEditor.getSelection());
            }
        });
        this.setTitle(Messages.getString("ConfigurationWizardDetailsPage.title"));
        this.setDescription(Messages.getString("ConfigurationWizardDetailsPage.description"));
        if (this.configuration != null) {
            this.descText.setText(this.configuration.getDescription());
            if (this.configuration instanceof CPSMConfiguration) {
                cpsmButton.setSelection(true);
                this.cpsmInput.setEnabled(true);
                this.cpsmText.setText(((CPSMConfiguration)this.configuration).getCPSMContext());
                this.csdRLSCombo.select(0);
                this.getConfigWizard().setConfigurationType(NewConfigurationWizard.ConfigurationType.CPSM);
            } else if (this.configuration instanceof CSDConfiguration) {
                CSDConfiguration csd = (CSDConfiguration)this.configuration;
                csdButton.setSelection(true);
                this.csdFileLabel.setEnabled(true);
                this.csdInput.setEnabled(true);
                this.csdText.setText(csd.getCSDName());
                this.rlsLabel.setEnabled(true);
                this.csdRLSCombo.setEnabled(true);
                this.csdRLSCombo.select(this.csdRLSCombo.indexOf((String)csd.getAttributes().get("CSDRLS")));
                this.getConfigWizard().setConfigurationType(NewConfigurationWizard.ConfigurationType.CSD);
            } else if (this.configuration instanceof ZfsConfiguration) {
                ZfsConfiguration zfs = (ZfsConfiguration)this.configuration;
                zfsButton.setSelection(true);
                this.zfsInput.setEnabled(true);
                this.zfsText.setText(zfs.getZfsRootDir());
                this.backup.setEnabled(true);
                boolean initialBackup = zfs.getZfsBackup();
                this.backup.setSelection(initialBackup);
                backupComposite.setEnabled(true);
                if (initialBackup) {
                    this.backupCount.setSelection(zfs.getZfsBackupCount());
                    this.backupDirText.setText(zfs.getZfsBackupDir());
                }
                this.getConfigWizard().setConfigurationType(NewConfigurationWizard.ConfigurationType.ZFS);
            }
        } else {
            cpsmButton.setSelection(true);
            this.cpsmInput.setEnabled(true);
            this.csdRLSCombo.select(0);
            this.getConfigWizard().setConfigurationType(NewConfigurationWizard.ConfigurationType.CPSM);
        }
        this.validateInputs();
        this.setErrorMessage(null);
        UIHelper.clearError((Control)this.nameText);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), this.getHelpContextID());
        this.setControl((Control)this.base);
    }

    private String getHelpContextID() {
        return "com.ibm.cics.cm.ui.wizard_newconfiguration";
    }

    protected void validateInputs() {
        if (this.getConfigName().isEmpty() || !this.getConfigName().matches("[A-Z0-9$@#_-]{1,8}")) {
            this.setErrorMessage(Messages.getString("ConfigurationWizardDetailsPage.errorMessage.configurationName"));
            UIHelper.errorControl((Control)this.nameText, (String)Messages.getString("ConfigurationWizardDetailsPage.errorMessage.configurationName"));
        } else if (this.currentConfigurationNames != null && this.currentConfigurationNames.contains(this.getConfigName())) {
            this.setErrorMessage(Messages.getString("ConfigurationWizardDetailsPage.errorMessage.duplicateName"));
            UIHelper.errorControl((Control)this.nameText, (String)Messages.getString("ConfigurationWizardDetailsPage.errorMessage.duplicateName"));
        } else {
            UIHelper.clearError((Control)this.nameText);
            if (!(this.getConfigWizard().isCPSM() || this.getConfigWizard().isCSD() || this.getConfigWizard().isZFS())) {
                this.setErrorMessage(Messages.getString("ConfigurationWizardDetailsPage.errorMessage.selectType"));
            } else {
                if (this.getConfigWizard().isCPSM() && (this.getConfigCPSMContext().isEmpty() || !this.getConfigCPSMContext().matches("[A-Z0-9$@#]{1,8}"))) {
                    this.setErrorMessage(Messages.getString("ConfigurationWizardDetailsPage.errorMessage.cpsmName"));
                    UIHelper.errorControl((Control)this.cpsmText, (String)Messages.getString("ConfigurationWizardDetailsPage.errorMessage.cpsmName"));
                } else {
                    UIHelper.clearError((Control)this.cpsmText);
                }
                if (this.getConfigWizard().isCSD() && (this.getConfigCSDName().isEmpty() || !this.getConfigCSDName().matches("[A-Z0-9$@#]{1,8}+(\\.[A-Z0-9$@#]{1,8}){0,43}"))) {
                    this.setErrorMessage(Messages.getString("ConfigurationWizardDetailsPage.errorMessage.csdName"));
                    UIHelper.errorControl((Control)this.csdText, (String)Messages.getString("ConfigurationWizardDetailsPage.errorMessage.csdName"));
                } else {
                    UIHelper.clearError((Control)this.csdText);
                }
                if (this.getConfigWizard().isZFS()) {
                    if (this.validateDirectoryField(this.zfsText, "Configuration.zfs.configType")) {
                        if (this.backup.getSelection()) {
                            this.validateDirectoryField(this.backupDirText, "Configuration.zfs.backupdirectory");
                        } else {
                            UIHelper.clearError((Control)this.backupDirText);
                        }
                    } else {
                        UIHelper.clearError((Control)this.backupDirText);
                    }
                } else {
                    UIHelper.clearError((Control)this.zfsText);
                    UIHelper.clearError((Control)this.backupDirText);
                }
            }
        }
        if (!UIHelper.hasError((Control)this.nameText) && (this.getConfigWizard().isCPSM() && !UIHelper.hasError((Control)this.cpsmText) || this.getConfigWizard().isCSD() && !UIHelper.hasError((Control)this.csdText) && this.csdRLSCombo.getSelectionIndex() != -1 || this.getConfigWizard().isZFS() && !UIHelper.hasError((Control)this.zfsText) && (!this.getConfigZfsBackup() || !UIHelper.hasError((Control)this.backupDirText)))) {
            this.setPageComplete(true);
            this.getConfigWizard().setCanFinish(true);
            this.setErrorMessage(null);
        } else {
            this.setPageComplete(false);
            this.getConfigWizard().setCanFinish(false);
        }
        this.getConfigWizard().getContainer().updateButtons();
    }

    protected boolean validateDirectoryField(Text directoryText, String propertyName) {
        String fieldName = Messages.getString(propertyName);
        String errorMessage = null;
        String directory = directoryText.getText();
        if (directory.isEmpty()) {
            errorMessage = Messages.getString(String.valueOf(propertyName) + ".errorMessage.empty");
        } else if (!directory.startsWith("/")) {
            errorMessage = MessageFormat.format(Messages.getString("ZfsDirectoryDefinitions.errorMessage.mustStart"), fieldName);
        } else if (!directory.matches("[A-Za-z0-9$@#\\./-_%&?!:|\"=,;<> ]{1,255}")) {
            errorMessage = MessageFormat.format(Messages.getString("ZfsDirectoryDefinitions.errorMessage.chars"), fieldName);
        } else if (directory.matches(".*//.*")) {
            errorMessage = MessageFormat.format(Messages.getString("ZfsDirectoryDefinitions.errorMessage.slash"), fieldName);
        } else if (directory.length() == 255 && !directory.endsWith("/")) {
            errorMessage = MessageFormat.format(Messages.getString("ZfsDirectoryDefinitions.errorMessage.mustEnd"), fieldName);
        }
        if (errorMessage != null) {
            this.setErrorMessage(errorMessage);
            UIHelper.errorControl((Control)directoryText, (String)errorMessage);
            return false;
        }
        UIHelper.clearError((Control)directoryText);
        return true;
    }

    public void setServerError(CMServerException e) {
        String errorMessage;
        if (e.isZfsFileNotFound()) {
            boolean backupSpecified = this.backup.getSelection();
            String fieldName = Messages.getString("Configuration.zfs.configType");
            if (backupSpecified) {
                fieldName = String.valueOf(fieldName) + "/" + Messages.getString("Configuration.zfs.backupdirectory");
            }
            errorMessage = MessageFormat.format(Messages.getString("ZfsDirectoryDefinitions.errorMessage.notFound"), fieldName);
            UIHelper.errorControl((Control)this.zfsText, (String)errorMessage);
            if (backupSpecified) {
                UIHelper.errorControl((Control)this.backupDirText, (String)errorMessage);
            }
        } else {
            errorMessage = MessageFormat.format(Messages.getString("ConfigurationWizardDetailsPage.errorMessage.genericServer"), e.getMessage());
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(false);
        this.getConfigWizard().setCanFinish(false);
    }
}

