/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.wizards;

import com.ibm.cics.cm.model.CMSystemOptions;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.EnsureUppercaseListener;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.composites.OpenEditorComposite;
import com.ibm.cics.cm.utilities.Utilities;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewChangePackagePage
extends WizardPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String CM_VALID_CHARACTERS = "[\\w@$#-]";
    private Composite container;
    private Text cpNameText;
    private Text cpDescText;
    private Text cpExtRefText;
    private Button openEditor;

    protected NewChangePackagePage() {
        super("Basic");
    }

    public void createControl(Composite parent) {
        String autoNum;
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout = new GridLayout(2, false);
        layout.horizontalSpacing = 15;
        this.container.setLayout((Layout)layout);
        CMSystemOptions cmSysOpt = ConfigurationManager.getCurrent().getSystemOptions(false);
        boolean autoNumbering = false;
        if (cmSysOpt != null && (autoNum = cmSysOpt.getAttribute("PKGAUTNUM")) != null && autoNum.equalsIgnoreCase("YES")) {
            autoNumbering = true;
        }
        if (autoNumbering) {
            Label optional = new Label(this.container, 64);
            optional.setText(Messages.getString("BasicNewChangePackagePage.label.description.optional"));
            GridData rd = new GridData(4, 16384, true, false, 2, 1);
            rd.widthHint = 300;
            optional.setLayoutData((Object)rd);
        }
        Label cpNameLabel = new Label(this.container, 0);
        cpNameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        cpNameLabel.setText(Messages.getString("BasicNewChangePackagePage.label.packname"));
        if (!autoNumbering) {
            Utilities.addMandatoryField((Control)cpNameLabel);
        }
        TextInput nameInput = new TextInput(this.container, cpNameLabel);
        cpNameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        int boxLimit = 8;
        nameInput.setNumberOfCharacters(boxLimit);
        this.cpNameText = nameInput.text;
        this.cpNameText.setTextLimit(boxLimit);
        this.cpNameText.addVerifyListener((VerifyListener)EnsureUppercaseListener.getSingleton());
        this.cpNameText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                char typedChar = e.character;
                if (typedChar == '\u007f' || typedChar == '\b') {
                    e.doit = true;
                    return;
                }
                Pattern p = Pattern.compile("[\\w@$#-]");
                Matcher matcher = p.matcher(Character.toString(typedChar));
                e.doit = matcher.find();
            }
        });
        this.cpNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewChangePackagePage.this.getWizard().getContainer().updateButtons();
            }
        });
        if (autoNumbering) {
            final ControlDecoration cpNameOptionalInformation = new ControlDecoration((Control)this.cpNameText, 0x1004000);
            cpNameOptionalInformation.hide();
            FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
            cpNameOptionalInformation.setImage(fieldDecoration.getImage());
            cpNameOptionalInformation.setDescriptionText(Messages.getString("BasicNewChangePackagePage.label.nameOptional"));
            this.cpNameText.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    cpNameOptionalInformation.show();
                }
            });
        }
        Label cpDescLabel = new Label(this.container, 0);
        cpDescLabel.setText(Messages.getString("BasicNewChangePackagePage.label.packdesc"));
        cpDescLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        TextInput descInput = new TextInput(this.container, cpDescLabel);
        descInput.setNumberOfCharacters(32);
        descInput.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.cpDescText = descInput.text;
        this.cpDescText.setTextLimit(80);
        Label cpExtRefLabel = new Label(this.container, 0);
        cpExtRefLabel.setText(Messages.getString("BasicNewChangePackagePage.label.extref"));
        cpExtRefLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        TextInput extrefInput = new TextInput(this.container, cpExtRefLabel);
        extrefInput.setNumberOfCharacters(32);
        extrefInput.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.cpExtRefText = extrefInput.text;
        this.cpExtRefText.setTextLimit(32);
        this.cpExtRefText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                char typedChar = e.character;
                if (typedChar == '\u007f' || typedChar == '\b') {
                    e.doit = true;
                    return;
                }
                Pattern p = Pattern.compile("[\\w@$#-]");
                Matcher matcher = p.matcher(Character.toString(typedChar));
                e.doit = matcher.find();
            }
        });
        this.openEditor = new OpenEditorComposite((Composite)this.container, (int)0).openEditor;
        this.openEditor.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.setTitle(Messages.getString("NewChangePackageWizard.title"));
        this.setDescription(Messages.getString("NewChangePackageWizard.description"));
        this.setImageDescriptor(UIActivator.IMGD520_CHANGE_PACKAGE_NEW_WIZARD);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpContextID());
        this.setControl((Control)this.container);
    }

    protected String getHelpContextID() {
        return "com.ibm.cics.cm.ui.wizard_newpackage";
    }

    protected String getPackageName() {
        String text;
        try {
            text = this.cpNameText.getText();
        }
        catch (SWTException e) {
            text = "";
        }
        return text;
    }

    protected String getPackageDescription() {
        String text;
        try {
            text = this.cpDescText.getText();
        }
        catch (SWTException e) {
            text = "";
        }
        return text;
    }

    protected String getExternalReference() {
        String text;
        try {
            text = this.cpExtRefText.getText();
        }
        catch (SWTException e) {
            text = "";
        }
        return text;
    }

    public boolean getOpenEditor() {
        return this.openEditor.getSelection();
    }
}

