/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.wizards;

import com.ibm.cics.cm.model.ChangePackage;
import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.definitions.CICSRegionGroupDefinition;
import com.ibm.cics.cm.model.definitions.CPSMNoGroupDefinition;
import com.ibm.cics.cm.model.definitions.ResourceDefinition;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.wizards.CPSMNoGroupDefinitionTreeItem;
import com.ibm.cics.cm.ui.wizards.CPTopologyConfirmMembersPage;
import com.ibm.cics.cm.ui.wizards.CPTopologyLoadingMembersPage;
import com.ibm.cics.cm.ui.wizards.CPTopologySelectMembersPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ChangePackageTopologyWizard
extends Wizard
implements Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String LOADING_PAGE_NAME = "page.loading";
    protected static final String SELECT_PAGE_NAME = "page.select";
    protected static final String ADD_PAGE_NAME = "page.add";
    private CPTopologyLoadingMembersPage loading;
    private CPTopologySelectMembersPage select;
    private List<CICSRegionGroupDefinition> systemGroups;
    private ArrayList<CPSMNoGroupDefinitionTreeItem> treeItems;
    private ChangePackage targetPackage;
    private CPTopologyConfirmMembersPage confirm;
    private ArrayList<ResourceDefinition> returnDefs;

    public ChangePackageTopologyWizard(List<CICSRegionGroupDefinition> cSysGrp, ChangePackage targetPackage) {
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(UIActivator.IMGD_CPWIZ);
        this.setWindowTitle(Messages.getString("PackageTopologyWizard.wizard.title"));
        this.systemGroups = cSysGrp;
        this.targetPackage = targetPackage;
    }

    public IWizardPage getStartingPage() {
        return this.loading;
    }

    public void addPages() {
        this.loading = new CPTopologyLoadingMembersPage(this);
        this.addPage((IWizardPage)this.loading);
        this.select = new CPTopologySelectMembersPage(this);
        this.addPage((IWizardPage)this.select);
        this.confirm = new CPTopologyConfirmMembersPage(this);
        this.addPage((IWizardPage)this.confirm);
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.confirm;
    }

    public boolean performFinish() {
        if (this.confirm != null) {
            this.returnDefs = this.confirm.getDefinitions();
        }
        return true;
    }

    protected void retrieveMembers() {
        final Listener callback = new Listener(){

            public void handleEvent(Event event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ChangePackageTopologyWizard.this.getContainer() != null && ChangePackageTopologyWizard.this.select != null) {
                            ChangePackageTopologyWizard.this.getContainer().showPage((IWizardPage)ChangePackageTopologyWizard.this.select);
                        }
                    }
                });
            }
        };
        Thread runnable = new Thread(){

            @Override
            public void run() {
                ChangePackageTopologyWizard.this.treeItems = new ArrayList();
                for (CICSRegionGroupDefinition systemGroup : ChangePackageTopologyWizard.this.systemGroups) {
                    CPSMNoGroupDefinitionTreeItem item = new CPSMNoGroupDefinitionTreeItem((CPSMNoGroupDefinition)systemGroup, CPSMNoGroupDefinitionTreeItem.SelectedState.DEFINITION, null);
                    ChangePackageTopologyWizard.this.treeItems.add(item);
                    item.getChildren();
                }
                if (callback != null) {
                    callback.handleEvent(new Event());
                }
            }
        };
        runnable.start();
    }

    protected ArrayList<CPSMNoGroupDefinitionTreeItem> getTreeItems() {
        return this.treeItems;
    }

    protected List<CICSRegionGroupDefinition> getRegionGroups() {
        return this.systemGroups;
    }

    public ArrayList<ResourceDefinition> getDefinitions() {
        return this.returnDefs;
    }

    public ChangePackage getTargetPackage() {
        return this.targetPackage;
    }

    public void setTreeItems(ArrayList<CPSMNoGroupDefinitionTreeItem> treeItems) {
        this.treeItems = treeItems;
    }
}

