/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.wizards;

import com.ibm.cics.cm.model.ChangePackage;
import com.ibm.cics.cm.model.MigrationScheme;
import com.ibm.cics.cm.model.PackageSchemeEvent;
import com.ibm.cics.cm.model.runtime.MessageResponse;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.chgpkg.ChangePackageCommand;
import com.ibm.cics.cm.ui.wizards.BatchJCLEditorLauncher;
import com.ibm.cics.cm.ui.wizards.CPBackoutActionPage;
import com.ibm.cics.cm.ui.wizards.CPConfirmActionPage;
import com.ibm.cics.cm.ui.wizards.CPPerformActionPage;
import com.ibm.cics.cm.ui.wizards.CPSchemeActionPage;
import com.ibm.cics.cm.ui.wizards.ChangePackageWizardPage;
import com.ibm.cics.eclipse.common.ViewHelper;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class ChangePackageActionWizard
extends Wizard {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2023 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String CONFIRM_PAGE = "confirm.action";
    public static final String SCHEME_PAGE = "choose.scheme";
    public static final String PERFORM_PAGE = "perform.action";
    public static final String BACKOUT_PAGE = "choose.backout";
    public static final String PACKAGE_PAGE = "choose.package";
    public static final String COMMAND_PAGE = "choose.command";
    private ChangePackage changePackage;
    private MigrationScheme migrationScheme;
    private ChangePackageCommand cpCommand;
    private MessageResponse lastResponse = null;
    private Pages startingPage = null;
    protected CPSchemeActionPage schemePage;
    protected CPBackoutActionPage backoutPage;
    protected CPConfirmActionPage confirmPage;
    protected CPPerformActionPage performPage;
    private PackageSchemeEvent backoutEvent;
    private boolean enoughDataToProcess = false;
    private boolean jclRequested = false;
    private boolean processNow = false;
    private IPageChangedListener pageChangeListener;

    public ChangePackageActionWizard(ChangePackageCommand action, ChangePackage cPackage, MigrationScheme scheme) {
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(this.getImageDescriptor(action));
        this.setWindowTitle(Messages.getString("NewChangePackageWizard.title"));
        if (scheme != null) {
            this.setMigrationScheme(scheme);
        } else {
            this.startingPage = Pages.SCHEME;
        }
        if (cPackage != null) {
            this.setChangePackage(cPackage);
        } else {
            this.startingPage = Pages.PACKAGE;
        }
        if (action != null) {
            this.setCommand(action);
            if (this.startingPage == null && this.cpCommand.equals((Object)ChangePackageCommand.BACKOUT)) {
                this.startingPage = Pages.BACKOUT;
            }
        } else {
            this.startingPage = Pages.COMMAND;
        }
        if (this.startingPage == null) {
            this.startingPage = Pages.CONFIRM;
        }
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        WizardDialog dialog = (WizardDialog)this.getContainer();
        this.pageChangeListener = new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                if (event.getSelectedPage() instanceof ChangePackageWizardPage) {
                    ChangePackageWizardPage cpPage = (ChangePackageWizardPage)((Object)event.getSelectedPage());
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)ChangePackageActionWizard.this.getShell(), cpPage.getHelpContextID());
                }
            }
        };
        dialog.addPageChangedListener(this.pageChangeListener);
    }

    public void dispose() {
        if (this.pageChangeListener != null) {
            WizardDialog dialog = (WizardDialog)this.getContainer();
            dialog.removePageChangedListener(this.pageChangeListener);
        }
    }

    private ImageDescriptor getImageDescriptor(ChangePackageCommand action) {
        ImageDescriptor imageDescriptor;
        switch (action) {
            case MIGRATE: {
                imageDescriptor = UIActivator.IMGD_CPWIZ_MIGRATE;
                break;
            }
            case INSTALL: {
                imageDescriptor = UIActivator.IMGD_CPWIZ_INSTALL;
                break;
            }
            case READY: {
                imageDescriptor = UIActivator.IMGD_CPWIZ_READY;
                break;
            }
            case UNREADY: {
                imageDescriptor = UIActivator.IMGD_CPWIZ_UNREADY;
                break;
            }
            case APPROVE: {
                imageDescriptor = UIActivator.IMGD_CPWIZ_APPROVE;
                break;
            }
            case DISAPPROVE: {
                imageDescriptor = UIActivator.IMGD_CPWIZ_DISAPPROVE;
                break;
            }
            case BACKOUT: {
                imageDescriptor = UIActivator.IMGD_CPWIZ_BACKOUT;
                break;
            }
            default: {
                imageDescriptor = UIActivator.IMGD_CPWIZ;
            }
        }
        return imageDescriptor;
    }

    public IWizardPage getStartingPage() {
        if (this.startingPage != null) {
            switch (this.startingPage) {
                case COMMAND: {
                    break;
                }
                case PACKAGE: {
                    break;
                }
                case SCHEME: {
                    if (this.schemePage == null) break;
                    return this.schemePage;
                }
                case BACKOUT: {
                    if (this.backoutPage != null) {
                        return this.backoutPage;
                    }
                }
                default: {
                    if (this.confirmPage == null) break;
                    return this.confirmPage;
                }
            }
        }
        return super.getStartingPage();
    }

    public void addPages() {
        this.schemePage = new CPSchemeActionPage(this.getPackageCommand());
        this.addPage((IWizardPage)this.schemePage);
        this.backoutPage = new CPBackoutActionPage(this.getPackageCommand());
        this.addPage((IWizardPage)this.backoutPage);
        this.confirmPage = new CPConfirmActionPage(this.getPackageCommand());
        this.addPage((IWizardPage)this.confirmPage);
        this.performPage = new CPPerformActionPage(this.getPackageCommand());
        this.addPage((IWizardPage)this.performPage);
    }

    public boolean canFinish() {
        return this.jclRequested || this.processNow || this.lastResponse != null;
    }

    public boolean readyToProcess() {
        return this.enoughDataToProcess;
    }

    public void setJCLRequested() {
        this.jclRequested = true;
        this.processNow = false;
    }

    public void setProcessNow() {
        this.processNow = true;
        this.jclRequested = false;
    }

    public void setCannotFinish() {
        this.processNow = false;
        this.jclRequested = false;
    }

    public boolean performFinish() {
        if (this.jclRequested) {
            this.generateJCL();
            return true;
        }
        if (this.processNow && this.validateInputs()) {
            this.processAction(null);
            return true;
        }
        return false;
    }

    public boolean validateInputs() {
        boolean baseInputs;
        boolean bl = baseInputs = this.cpCommand != null && this.migrationScheme != null && this.changePackage != null;
        if (this.cpCommand != null && this.cpCommand == ChangePackageCommand.BACKOUT) {
            return baseInputs && this.backoutEvent != null;
        }
        return baseInputs;
    }

    public void updatePages() {
        if (this.validateInputs()) {
            this.enoughDataToProcess = true;
        }
        if (this.confirmPage != null) {
            this.confirmPage.update();
        }
    }

    public void setCommand(ChangePackageCommand cpc) {
        this.cpCommand = cpc;
        this.updatePages();
    }

    public void setMigrationScheme(MigrationScheme ms) {
        this.migrationScheme = ms;
        this.backoutEvent = null;
        this.updatePages();
    }

    public void setChangePackage(ChangePackage cp) {
        this.changePackage = cp;
        this.updatePages();
    }

    public void setBackoutEvent(PackageSchemeEvent event) {
        this.backoutEvent = event;
        this.updatePages();
    }

    public ChangePackageCommand getPackageCommand() {
        return this.cpCommand;
    }

    public MigrationScheme getMigrationScheme() {
        return this.migrationScheme;
    }

    public ChangePackage getChangePackage() {
        return this.changePackage;
    }

    public PackageSchemeEvent getBackoutEvent() {
        return this.backoutEvent;
    }

    protected void processAction(final Listener callback) {
        this.lastResponse = null;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.getString("ChangePackageActionWizard.processingPackageAction"), -1);
                Thread.sleep(100L);
                switch (ChangePackageActionWizard.this.cpCommand) {
                    case READY: {
                        ChangePackageActionWizard.this.lastResponse = ChangePackageActionWizard.this.changePackage.readyPackage(ChangePackageActionWizard.this.migrationScheme);
                        break;
                    }
                    case UNREADY: {
                        ChangePackageActionWizard.this.lastResponse = ChangePackageActionWizard.this.changePackage.unreadyPackage(ChangePackageActionWizard.this.migrationScheme);
                        break;
                    }
                    case MIGRATE: {
                        ChangePackageActionWizard.this.lastResponse = ChangePackageActionWizard.this.changePackage.migratePackage(ChangePackageActionWizard.this.migrationScheme);
                        break;
                    }
                    case BACKOUT: {
                        ChangePackageActionWizard.this.lastResponse = ChangePackageActionWizard.this.changePackage.backoutEvent(ChangePackageActionWizard.this.migrationScheme, ChangePackageActionWizard.this.backoutEvent);
                        break;
                    }
                }
                if (callback != null) {
                    callback.handleEvent(new Event());
                }
            }
        };
        try {
            this.getContainer().run(true, false, runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.lastResponse != null) {
            Status status;
            if (this.lastResponse.returnCode == 0) {
                status = new Status(1, "com.ibm.cics.cm.ui", this.getActionResponseMessage(this.lastResponse));
                ViewHelper.setDeferredStatusInformationMessage((String)status.getMessage());
                UIActivator.getDefault().getLog().log((IStatus)status);
            } else if (this.lastResponse.returnCode == 4) {
                status = new Status(2, "com.ibm.cics.cm.ui", this.getActionResponseMessage(this.lastResponse));
                ViewHelper.setDeferredStatusInformationMessage((String)status.getMessage());
                UIActivator.getDefault().getLog().log((IStatus)status);
            } else if (this.lastResponse.returnCode > 4) {
                status = new Status(4, "com.ibm.cics.cm.ui", this.getActionResponseMessage(this.lastResponse));
                ViewHelper.setDeferredStatusErrorMessage((String)status.getMessage());
                UIActivator.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    private String getActionResponseMessage(MessageResponse mr) {
        return MessageFormat.format(Messages.getString("ChangePackageActionWizard.result.message"), this.cpCommand.toString(), this.getChangePackage().getName(), this.getMigrationScheme().getName(), mr.getReturnResponse());
    }

    private void generateJCL() {
        HashMap<String, String> otherAttribs = new HashMap<String, String>();
        ChangePackageCommand packageCommand = this.getPackageCommand();
        if (packageCommand.equals((Object)ChangePackageCommand.BACKOUT)) {
            PackageSchemeEvent backoutEvent = this.getBackoutEvent();
            String eventID = backoutEvent.getAttribute(PackageSchemeEvent.EventAttribute.CH_EVID);
            otherAttribs.put("EVID", eventID);
        }
        ChangePackage changePackage = this.getChangePackage();
        MigrationScheme migrationScheme = this.getMigrationScheme();
        BatchJCLEditorLauncher.launchJCLEditor(changePackage.getName(), migrationScheme.getName(), packageCommand.toString(), otherAttribs);
    }

    public MessageResponse getLastResponse() {
        return this.lastResponse;
    }

    private static enum Pages {
        COMMAND,
        PACKAGE,
        SCHEME,
        CONFIRM,
        PERFORM,
        BACKOUT;

    }
}

