/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.wizards;

import com.ibm.cics.cm.model.ChangePackage;
import com.ibm.cics.cm.model.MigrationScheme;
import com.ibm.cics.cm.model.PackageSchemeEvent;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.chgpkg.ChangePackageCommand;
import com.ibm.cics.cm.ui.wizards.ChangePackageWizardPage;
import java.text.MessageFormat;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CPConfirmActionPage
extends ChangePackageWizardPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Composite base;
    private Label schemeName;
    private Label packageName;
    private Label commandName;
    private Label eventLabel;
    private Label eventDetail;
    private Button directButton = null;
    private Button jclButton = null;

    protected CPConfirmActionPage(ChangePackageCommand changePackageCommand) {
        super("choose.scheme", changePackageCommand);
        this.setMessage(Messages.getString("ChangePackageActionWizard.choose.method"));
    }

    public void createControl(Composite parent) {
        this.base = new Composite(parent, 0);
        GridLayout gLayout = new GridLayout(2, false);
        gLayout.marginLeft = 20;
        gLayout.marginRight = 20;
        gLayout.marginTop = 20;
        this.base.setLayout((Layout)gLayout);
        Label commandLabel = new Label(this.base, 0);
        commandLabel.setText(Messages.getString("ChangePackageActionWizard.commandLabel"));
        commandLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.commandName = new Label(this.base, 0);
        this.commandName.setLayoutData((Object)new GridData(16384, 128, false, false));
        Label packageLabel = new Label(this.base, 0);
        packageLabel.setText(Messages.getString("ChangePackageActionWizard.packageLabel"));
        packageLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.packageName = new Label(this.base, 0);
        this.packageName.setLayoutData((Object)new GridData(16384, 128, false, false));
        Label schemeLabel = new Label(this.base, 0);
        schemeLabel.setText(Messages.getString("ChangePackageActionWizard.schemeLabel"));
        schemeLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.schemeName = new Label(this.base, 0);
        this.schemeName.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.eventLabel = new Label(this.base, 0);
        this.eventLabel.setText("");
        this.eventLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.eventDetail = new Label(this.base, 0);
        this.eventDetail.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.directButton = new Button(this.base, 16);
        this.directButton.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        this.directButton.setToolTipText(MessageFormat.format(Messages.getString("ChangePackageActionWizard.directButtonToolTopText"), this.getCPWizard().getPackageCommand().name(), this.getCPWizard().getChangePackage().getName()));
        this.directButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CPConfirmActionPage.this.getCPWizard().setProcessNow();
                CPConfirmActionPage.this.getCPWizard().getContainer().updateButtons();
            }
        });
        this.directButton.setText(Messages.getString("ChangePackageActionWizard.directButtonText"));
        this.directButton.setSelection(true);
        this.jclButton = new Button(this.base, 16);
        this.jclButton.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        this.jclButton.setToolTipText(MessageFormat.format(Messages.getString("ChangePackageActionWizard.jclButtonToolTipText"), this.getCPWizard().getPackageCommand().name(), this.getCPWizard().getChangePackage().getName()));
        this.jclButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CPConfirmActionPage.this.getCPWizard().setJCLRequested();
                CPConfirmActionPage.this.getCPWizard().getContainer().updateButtons();
            }
        });
        this.jclButton.setText(Messages.getString("ChangePackageActionWizard.jclButtonText"));
        this.getCPWizard().setProcessNow();
        this.update();
        this.setControl((Control)this.base);
    }

    @Override
    protected String getHelpContextID() {
        return "com.ibm.cics.cm.ui.wizard_cp_actions_confirm";
    }

    public IWizardPage getPreviousPage() {
        ChangePackageCommand command = this.getCPWizard().getPackageCommand();
        if (command != null && command.equals((Object)ChangePackageCommand.BACKOUT)) {
            return this.getCPWizard().backoutPage;
        }
        return this.getCPWizard().schemePage;
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void update() {
        ChangePackageCommand packageCommand;
        if (this.commandName != null && !this.commandName.isDisposed()) {
            packageCommand = this.getCPWizard().getPackageCommand();
            this.commandName.setText(packageCommand != null ? packageCommand.toString() : "");
        }
        if (this.packageName != null && !this.packageName.isDisposed()) {
            ChangePackage changePackage = this.getCPWizard().getChangePackage();
            this.packageName.setText(changePackage != null ? changePackage.getName() : "");
        }
        if (this.schemeName != null && !this.schemeName.isDisposed()) {
            MigrationScheme migrationScheme = this.getCPWizard().getMigrationScheme();
            this.schemeName.setText(migrationScheme != null ? migrationScheme.getName() : "");
        }
        if (this.eventDetail != null && !this.eventDetail.isDisposed() && (packageCommand = this.getCPWizard().getPackageCommand()).equals((Object)ChangePackageCommand.BACKOUT)) {
            PackageSchemeEvent backoutEvent = this.getCPWizard().getBackoutEvent();
            if (backoutEvent != null) {
                this.eventLabel.setText(Messages.getString("ChangePackageActionWizard.eventLabel"));
                StringBuffer detailBuffer = new StringBuffer();
                detailBuffer.append(String.valueOf(backoutEvent.getAttribute(PackageSchemeEvent.EventAttribute.CH_EVID)) + " - ");
                detailBuffer.append(String.valueOf(backoutEvent.getAttribute(PackageSchemeEvent.EventAttribute.CH_APICMD)) + " - ");
                detailBuffer.append(String.valueOf(backoutEvent.getAttribute(PackageSchemeEvent.EventAttribute.CH_DATIME)) + "\n");
                detailBuffer.append(String.valueOf(Messages.getString("PackageSchemeEvent.userid")) + " " + backoutEvent.getAttribute(PackageSchemeEvent.EventAttribute.CH_USERID) + "\n");
                detailBuffer.append(String.valueOf(Messages.getString("PackageSchemeEvent.return")) + " " + backoutEvent.getAttribute(PackageSchemeEvent.EventAttribute.CH_RC) + "\n");
                detailBuffer.append(String.valueOf(Messages.getString("PackageSchemeEvent.reason")) + " " + backoutEvent.getAttribute(PackageSchemeEvent.EventAttribute.CH_RSN) + "\n");
                this.eventDetail.setText(detailBuffer.toString());
            } else {
                this.eventLabel.setText("");
                this.eventDetail.setText("");
            }
        }
        this.base.layout();
    }
}

