/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.wizards;

import com.ibm.cics.cm.cpsm.comm.CMSMConnection;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class BatchJCLEditorLauncher {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2023 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String GENERIC_CM_TMPLT = "//<-CMD--> EXEC  PGM=CCVBMAIN,REGION=3M\n//*\n//STEPLIB  DD DISP=SHR,DSN=<SCCVAlang>\n//         DD DISP=SHR,DSN=<SCCVAUTH>\n//CCVPRINT DD SYSOUT=*\n//CCVREPRT DD SYSOUT=*            * Output report results\n//CCVPARMS DD *\nCONNECT IPADDRESS=<HOST>,PORT=<PORT>,SSL=<SSL>\n";
    private static final String READY_CM_TMPLT = "READY CPID=<CPID>,SCHEME=<SCHEME>\n";
    private static final String UNREADY_CM_TMPLT = "UNREADY CPID=<CPID>,SCHEME=<SCHEME>\n";
    private static final String MIGRATE_CM_TMPLT = "MIGRATE CPID=<CPID>,SCHEME=<SCHEME>\n";
    private static final String BACKOUT_CM_TMPLT = "BACKOUT CPID=<CPID>,SCHEME=<SCHEME>,EVID=<EVID>\n";
    private static final String APPROVE_CM_TMPLT = "APPROVE CPID=<CPID>,SCHEME=<SCHEME>,ROLE=<ROLE>\n";
    private static final String DISAPPROVE_CM_TMPLT = "DISAPPROVE CPID=<CPID>,SCHEME=<SCHEME>,ROLE=<ROLE>\n";
    static final String SEP = "_";
    protected static final String EVENT_ID = "EVID";
    private static final String CMD_TAG = "<-CMD-->";
    private static final String CPID_TAG = "<CPID>";
    private static final String SCHEME_TAG = "<SCHEME>";
    private static final String EVID_TAG = "<EVID>";
    private static final String HOST_TAG = "<HOST>";
    private static final String PORT_TAG = "<PORT>";
    private static final String SSL_TAG = "<SSL>";
    private static final String SCCVAlang_TAG = "<SCCVAlang>";
    private static final String SCCVAUTH_TAG = "<SCCVAUTH>";
    static String projectName = "Configuration Manager";
    static String jclFolderName = "ChangePackageJCL";
    private static final Debug debug = new Debug(BatchJCLEditorLauncher.class);

    public static void launchJCLEditor(String packageID, String migrationScheme, String apiCommand, Map<String, String> otherAttribs) {
        IFolder folder = BatchJCLEditorLauncher.getCMJCLFolder();
        String filename = String.valueOf(apiCommand.toUpperCase()) + SEP + packageID.toUpperCase() + SEP + migrationScheme.toUpperCase() + SEP + System.currentTimeMillis() + ".jcl";
        IFile file = folder.getFile(filename);
        String content = BatchJCLEditorLauncher.getJCLContent(packageID, migrationScheme, apiCommand, otherAttribs);
        try {
            ByteArrayInputStream source = new ByteArrayInputStream(content.getBytes());
            file.create((InputStream)source, true, null);
        }
        catch (CoreException source) {
            // empty catch block
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.openEditor((IEditorInput)new FileEditorInput(file), "com.ibm.cics.jcl_editor");
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }

    private static String getJCLContent(String packageID, String migrationScheme, String apiCommand, Map<String, String> otherAttribs) {
        ConnectionConfiguration lastCMConnConf;
        StringBuffer buffer = new StringBuffer();
        ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), UIActivator.getDefault().getBundle().getSymbolicName());
        String jobCard = preferenceStore.getString("CHANGEPACKAGES_JOB_CARD");
        buffer.append(jobCard);
        buffer.append(GENERIC_CM_TMPLT);
        BatchJCLEditorLauncher.replaceString(buffer, SCCVAlang_TAG, preferenceStore.getString("CHANGEPACKAGES_SCCVALANG"));
        BatchJCLEditorLauncher.replaceString(buffer, SCCVAUTH_TAG, preferenceStore.getString("CHANGEPACKAGES_SCCVAUTH"));
        if (apiCommand.toUpperCase().matches("READY")) {
            buffer.append(READY_CM_TMPLT);
        } else if (apiCommand.toUpperCase().matches("UNREADY")) {
            buffer.append(UNREADY_CM_TMPLT);
        } else if (apiCommand.toUpperCase().matches("MIGRATE")) {
            buffer.append(MIGRATE_CM_TMPLT);
        } else if (apiCommand.toUpperCase().matches("BACKOUT")) {
            buffer.append(BACKOUT_CM_TMPLT);
            if (otherAttribs.containsKey(EVENT_ID)) {
                BatchJCLEditorLauncher.replaceString(buffer, EVID_TAG, otherAttribs.get(EVENT_ID));
            }
        }
        BatchJCLEditorLauncher.replaceString(buffer, CMD_TAG, String.format("%-8s", apiCommand.toUpperCase()));
        BatchJCLEditorLauncher.replaceString(buffer, CPID_TAG, packageID);
        BatchJCLEditorLauncher.replaceString(buffer, SCHEME_TAG, migrationScheme);
        IConnectionService connectionService = ConnectionsPlugin.getDefault().getConnectionService();
        IConnectable connectable = connectionService.getConnectable("com.ibm.cics.sm.connection");
        if (connectable.isConnected() && connectable.getConnection() != null && connectable.getConnection() instanceof CMSMConnection && (lastCMConnConf = connectable.getConnection().getConfiguration()) != null) {
            BatchJCLEditorLauncher.replaceString(buffer, HOST_TAG, lastCMConnConf.getHost());
            BatchJCLEditorLauncher.replaceString(buffer, PORT_TAG, Integer.toString(lastCMConnConf.getPort()));
            BatchJCLEditorLauncher.replaceString(buffer, SSL_TAG, lastCMConnConf.getSecureHint() ? "YES" : "NO");
        }
        return buffer.toString();
    }

    private static void replaceString(StringBuffer buffer, String toMatch, String replacement) {
        while (buffer.indexOf(toMatch) > 0) {
            int indexOfMatch = buffer.indexOf(toMatch);
            buffer.replace(indexOfMatch, indexOfMatch + toMatch.length(), replacement);
        }
    }

    private static IFolder getCMJCLFolder() {
        IProject cmProj = BatchJCLEditorLauncher.getCMProject();
        IFolder folder = cmProj.getFolder(jclFolderName);
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                debug.error("getCMJCLFolder", (Throwable)e);
                return null;
            }
        }
        return folder;
    }

    private static IProject getCMProject() {
        IProject cmProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (cmProject.isAccessible()) {
            return cmProject;
        }
        if (!cmProject.exists()) {
            try {
                cmProject.create(null);
            }
            catch (CoreException e) {
                debug.error("getCMProject", (Throwable)e);
                return null;
            }
        }
        if (!cmProject.isOpen()) {
            try {
                cmProject.open(null);
            }
            catch (CoreException e) {
                debug.error("getCMProject", (Throwable)e);
                return null;
            }
        }
        return cmProject;
    }
}

