/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.widgets;

import com.ibm.cics.cm.model.CSDConfiguration;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.utilities.CSDConnectionsForConfigurationContentProposalProvider;
import com.ibm.cics.core.ui.editors.wizards.LazyContentAssistCommandAdapter;
import com.ibm.cics.eclipse.common.ui.TextInput;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class CSDConnectionsForConfigurationTextInput
extends TextInput {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String HAS_CONTENT_ASSIST = "HAS_CONTENT_ASSIST";
    private LazyContentAssistCommandAdapter contentProposalAdapter;
    private CSDConnectionsForConfigurationContentProposalProvider contentProposalProvider;

    public CSDConnectionsForConfigurationTextInput(final Composite parent, Label anAccessibleLabel) {
        super(parent, anAccessibleLabel);
        this.setNumberOfCharacters(4);
        this.text.setTextLimit(4);
        this.text.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                if (((Boolean)CSDConnectionsForConfigurationTextInput.this.text.getData(CSDConnectionsForConfigurationTextInput.HAS_CONTENT_ASSIST)).booleanValue()) {
                    super.getName(event);
                    event.result = String.valueOf(event.result) + Messages.getString("ACCESSIBILITY.fieldHasContentAssist");
                }
            }
        });
        this.contentProposalProvider = new CSDConnectionsForConfigurationContentProposalProvider();
        TextContentAdapter textContentAdapter = new TextContentAdapter(){

            public void insertControlContents(Control control, String text, int cursorPosition) {
                super.insertControlContents(control, text, cursorPosition);
            }
        };
        LabelProvider scopeLabelProvider = new LabelProvider(){

            public String getText(Object element) {
                return ((IContentProposal)element).getLabel();
            }
        };
        this.contentProposalAdapter = new LazyContentAssistCommandAdapter((Control)this.text, (IControlContentAdapter)textContentAdapter, (IContentProposalProvider)this.contentProposalProvider, null, null, true);
        this.contentProposalAdapter.setProposalAcceptanceStyle(2);
        this.contentProposalProvider.addListener(new CSDConnectionsForConfigurationContentProposalProvider.Listener(){

            @Override
            public void dataAvailable() {
                parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CSDConnectionsForConfigurationTextInput.this.contentProposalAdapter.updatePopupContents();
                    }
                });
            }
        });
        this.contentProposalAdapter.setLabelProvider((ILabelProvider)scopeLabelProvider);
        this.setContentProposalActive(false);
    }

    private void setContentProposalActive(boolean active) {
        if (this.contentProposalAdapter != null) {
            this.contentProposalAdapter.setEnabled(active);
        }
        if (this.text != null) {
            this.text.setData(HAS_CONTENT_ASSIST, (Object)new Boolean(active));
        }
    }

    public void setCSDConfiguration(CSDConfiguration configuration) {
        if (this.contentProposalProvider != null) {
            this.contentProposalProvider.setConfiguration(configuration);
        }
        this.setContentProposalActive(configuration != null);
    }
}

