/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.views;

import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.FilteredCollection;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.ZfsConfiguration;
import com.ibm.cics.cm.model.ZfsDefinition;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.views.CMViewPart;
import com.ibm.cics.cm.ui.views.FilteredTableComposite;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import java.util.HashMap;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.actions.NewWizardShortcutAction;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class ZfsDefinitionsView
extends CMViewPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2017, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ID = "com.ibm.cics.cm.view.zfsdefinitions";
    private TableViewer viewer;
    private JobWithCancelingSupport job;
    private FilteredTableComposite filteredTableComposite;
    private ZfsDefinitionFilter filter;
    private HashMap<ZfsDefinition, ZfsDefinition.ZfsDefinitionListener> zfsDefinitionListeners;

    @Override
    protected void setInput(Object input) {
    }

    @Override
    protected Control createControl(Composite aComposite) {
        this.zfsDefinitionListeners = new HashMap();
        this.filteredTableComposite = new FilteredTableComposite(aComposite, 67584, this.getViewSite().getActionBars().getToolBarManager(), true);
        this.filteredTableComposite.addListener(new FilteredTableComposite.Listener(){

            @Override
            public void searchRequested(String string) {
                ZfsDefinitionsView.this.refresh(string);
            }
        });
        Table table = this.filteredTableComposite.getTable();
        this.viewer = new TableViewer(table);
        this.createColumns(table);
        this.filteredTableComposite.getTable().setLinesVisible(true);
        this.filteredTableComposite.getTable().setHeaderVisible(true);
        this.filteredTableComposite.setSite(this.getSite());
        this.addLabelProvider(this.viewer);
        this.addContentProvider(this.viewer);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IHandlerService handlerService = (IHandlerService)ZfsDefinitionsView.this.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("com.ibm.cics.cm.ui.zfsdefinition.command.open", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.filter = new ZfsDefinitionFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.getSite().getPage().addSelectionListener(new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (selection != null && selection instanceof IStructuredSelection) {
                    for (Object element : ((IStructuredSelection)selection).toList()) {
                        if (!(element instanceof Configuration)) continue;
                        ZfsDefinitionsView.this.refresh(true);
                        break;
                    }
                }
            }
        });
        return this.filteredTableComposite;
    }

    @Override
    protected void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ZfsDefinitionsView.this.fillContextMenu(manager);
            }
        });
        Menu popupMenu = menuMgr.createContextMenu(this.getPrimaryControl());
        this.getPrimaryControl().setMenu(popupMenu);
        this.getSite().registerContextMenu(menuMgr, this.getSelectionProvider());
    }

    protected void fillContextMenu(IMenuManager aMenuManager) {
        IWizardDescriptor wizardDesc = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard("com.ibm.cics.cm.ui.zfsdef.newwizard");
        if (wizardDesc != null) {
            NewWizardShortcutAction newWizardShortcutAction = new NewWizardShortcutAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), wizardDesc);
            newWizardShortcutAction.setText(Messages.getString("ZfsDefinitionsView.new"));
            newWizardShortcutAction.setImageDescriptor(null);
            aMenuManager.add((IAction)newWizardShortcutAction);
        }
        aMenuManager.add((IContributionItem)new Separator("new"));
        aMenuManager.add((IContributionItem)new Separator("open"));
        aMenuManager.add((IContributionItem)new Separator("actions"));
        aMenuManager.add((IContributionItem)new Separator("commonActions"));
        aMenuManager.add((IContributionItem)new Separator("clipboard"));
        aMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void createColumns(Table table) {
        this.createColumn(Messages.getString("ZfsDefinitionsView.column.definitions"), table, 100);
        this.createColumn(Messages.getString("ZfsDefinitionsView.column.location"), table, 200);
        this.createColumn(Messages.getString("ZfsDefinitionsView.column.changetime"), table, 150);
        this.createColumn(Messages.getString("ZfsDefinitionsView.column.description"), table, 150);
        this.createColumn(Messages.getString("ZfsDefinitionsView.column.path"), table, 100);
        this.createColumn(Messages.getString("ZfsDefinitionsView.column.data1"), table, 100);
        this.createColumn(Messages.getString("ZfsDefinitionsView.column.data2"), table, 100);
        this.createColumn(Messages.getString("ZfsDefinitionsView.column.data3"), table, 100);
        this.createColumn(Messages.getString("ZfsDefinitionsView.column.data4"), table, 100);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
    }

    private TableColumn createColumn(String text, Table table, int width) {
        TableColumn column = new TableColumn(table, 0);
        column.setText(text);
        column.setWidth(width);
        return column;
    }

    @Override
    protected Control getPrimaryControl() {
        return this.filteredTableComposite.getTable();
    }

    @Override
    protected ISelectionProvider getSelectionProvider() {
        return this.filteredTableComposite.getSelectionProvider();
    }

    @Override
    protected String getHelpContextID() {
        return "com.ibm.cics.cm.ui.view_zfsdefinitions";
    }

    public void refresh(final String string) {
        IWorkbenchPartSite wPartSite;
        if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
        if ((wPartSite = this.getSite()) != null && wPartSite instanceof IViewSite) {
            ((IViewSite)wPartSite).getActionBars().getStatusLineManager().setMessage(null);
        }
        this.job = new CMViewPart.FillTableFromFilteredCollectionJob(this, Messages.getString("ZfsDefinitionsView.fetchingMessage"), this.filteredTableComposite.getTable()){

            @Override
            protected void fillTableFrom(IFilteredCollection cmObjects) {
                if (cmObjects != null) {
                    IFilteredCollection zfsDefinitions = cmObjects;
                    ZfsDefinitionsView.this.viewer.setInput((Object)zfsDefinitions);
                    ZfsDefinitionsView.this.filter.setSearchString(string);
                    ZfsDefinitionsView.this.viewer.refresh();
                    ZfsDefinitionsView.this.filteredTableComposite.setTotalsCount(zfsDefinitions.size(), Messages.getString("CMObjects.zfsDefinitions"));
                    if (zfsDefinitions.size() > 0) {
                        ZfsDefinitionsView.this.viewer.getTable().setSelection(0);
                    }
                    ZfsDefinitionsView.this.viewer.getTable().setFocus();
                }
            }

            protected IFilteredCollection<ZfsDefinition> getCMObjects() {
                ISelection selection = ZfsDefinitionsView.this.getSite().getPage().getSelection("com.ibm.cics.cm.view.configurations");
                String configName = null;
                if (selection != null && selection instanceof IStructuredSelection) {
                    for (Object element : ((IStructuredSelection)selection).toList()) {
                        if (!(element instanceof ZfsConfiguration)) continue;
                        configName = ((ZfsConfiguration)element).getName();
                        break;
                    }
                }
                IFilteredCollection zfsDefinitions = null;
                if (configName != null) {
                    zfsDefinitions = ConfigurationManager.getCurrent().getZfsDefinitions(LocationCriteria.newConfigurationLocationCriteria(configName));
                    zfsDefinitions.getResults();
                }
                if (zfsDefinitions != null) {
                    for (ZfsDefinition zfsDef : zfsDefinitions) {
                        if (ZfsDefinitionsView.this.zfsDefinitionListeners.containsKey(zfsDef)) continue;
                        ZfsDefinition zfsDefinition = zfsDef;
                        zfsDefinition.getClass();
                        ZfsDefinition.ZfsDefinitionListener newListener = new ZfsDefinition.ZfsDefinitionListener(zfsDefinition, zfsDef){

                            public void notify(boolean changed, final ZfsDefinition source) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (source.isDeleted()) {
                                            ZfsDefinitionsView.this.viewer.remove((Object)source);
                                        } else {
                                            ZfsDefinitionsView.this.viewer.update((Object)source, null);
                                        }
                                    }
                                });
                            }
                        };
                        zfsDef.addListener(newListener);
                        ZfsDefinitionsView.this.zfsDefinitionListeners.put(zfsDef, newListener);
                    }
                }
                return zfsDefinitions;
            }
        };
        this.filteredTableComposite.reset();
        this.filteredTableComposite.beginFetch();
        this.schedule((Job)this.job);
    }

    @Override
    protected boolean canLinkToSelection() {
        return false;
    }

    public void add(ZfsDefinition zfsDef) {
        ZfsDefinition zfsDefinition = zfsDef;
        zfsDefinition.getClass();
        ZfsDefinition.ZfsDefinitionListener newListener = new ZfsDefinition.ZfsDefinitionListener(zfsDefinition, zfsDef){

            public void notify(boolean changed, final ZfsDefinition source) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (source.isDeleted()) {
                            ZfsDefinitionsView.this.viewer.remove((Object)source);
                        } else {
                            ZfsDefinitionsView.this.viewer.update((Object)source, null);
                        }
                    }
                });
            }
        };
        zfsDef.addListener(newListener);
        this.zfsDefinitionListeners.put(zfsDef, newListener);
        this.refresh(false);
    }

    @Override
    public void refresh(boolean isUser) {
        this.refresh(this.filteredTableComposite.getSearchString());
    }

    public void refreshViewer() {
        if (this.viewer != null) {
            this.viewer.refresh();
        }
    }

    private void addLabelProvider(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                ZfsDefinition item = null;
                if (!(element instanceof ZfsDefinition)) {
                    return null;
                }
                item = (ZfsDefinition)element;
                switch (columnIndex) {
                    case 0: {
                        return item.getName();
                    }
                    case 1: {
                        return item.getLocation();
                    }
                    case 2: {
                        return item.getDisplayChangeTime();
                    }
                    case 3: {
                        return item.getDescription();
                    }
                    case 4: {
                        return item.getRelPath();
                    }
                    case 5: {
                        return item.getData1();
                    }
                    case 6: {
                        return item.getData2();
                    }
                    case 7: {
                        return item.getData3();
                    }
                    case 8: {
                        return item.getData4();
                    }
                }
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    private void addContentProvider(TableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                FilteredCollection elements = (FilteredCollection)inputElement;
                return elements.getResults().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
    }

    private class ZfsDefinitionFilter
    extends ViewerFilter {
        private String searchString;

        private ZfsDefinitionFilter() {
        }

        public void setSearchString(String searchString) {
            this.searchString = searchString != null ? searchString : "";
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.searchString == null || this.searchString.trim().length() == 0) {
                return true;
            }
            ZfsDefinition ms = (ZfsDefinition)element;
            return ms.getName().contains(this.searchString);
        }
    }
}

