/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.views;

import com.ibm.cics.cm.model.definitions.ResourceDefinition;
import com.ibm.cics.cm.ui.ImageFactory;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.search.CMSearchQuery;
import com.ibm.cics.cm.ui.search.SearchHistoryManager;
import com.ibm.cics.cm.ui.search.SearchResultTreeBuilder;
import com.ibm.cics.cm.ui.views.CMViewPart;
import com.ibm.cics.cm.utilities.TreeSelectionProvider;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSObject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class SearchResultsView
extends CMViewPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(SearchResultsView.class);
    public static final String ID = "com.ibm.cics.cm.view.searchresults";
    private static final String BLANK = "    ";
    private static final String ZERO = "0";
    private static final int DESC_MAXWRAPLINES = 3;
    private static SearchResultsView view;
    SearchResultTreeBuilder treeBuilder;
    private Tree tree;
    private Label titleLabel;
    private Label totalsLabel;
    private Composite c;
    private SearchHistoryManager searchHistoryManager;
    private CMSearchQuery currentQuery;
    private Action toggleGroupsAction;
    private CMSearchQuery.CompletionListener completionListener;
    private TreeSelectionProvider selectionProvider;
    protected static boolean showGroups;

    public SearchResultsView() {
        view = this;
    }

    private void createResultsArea(Composite c2) {
        Composite resultsComposite = new Composite(this.c, 0);
        StackLayout stackLayout = new StackLayout();
        resultsComposite.setLayout((Layout)stackLayout);
        GridData data = new GridData(4, 4, true, true);
        resultsComposite.setLayoutData((Object)data);
        this.tree = new Tree(resultsComposite, 514);
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeBuilder = new SearchResultTreeBuilder(this.tree);
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                Object selectedObject;
                if (SearchResultsView.this.tree.getSelectionCount() == 1 && (selectedObject = SearchResultsView.this.tree.getSelection()[0].getData()) instanceof ResourceDefinition) {
                    final ICICSObject aCICSObject = (ICICSObject)Platform.getAdapterManager().getAdapter(selectedObject, ICICSDefinition.class);
                    BusyIndicator.showWhile((Display)SearchResultsView.this.tree.getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            UIPlugin.performDefaultViewAction((ICICSObject)aCICSObject);
                        }
                    });
                }
            }
        });
        this.treeBuilder.addTotalResultsListener(new SearchResultTreeBuilder.TotalsListener(){

            @Override
            public void totalChanged(int total) {
                SearchResultsView.this.totalsLabel.setText("(" + String.valueOf(total) + ")");
                SearchResultsView.this.totalsLabel.getParent().layout(true);
            }
        });
        stackLayout.topControl = this.tree;
        this.selectionProvider = new TreeSelectionProvider(this.tree);
        this.selectionProvider.allowMultipleSelections(true);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
    }

    @Override
    public void setFocus() {
        this.c.setFocus();
    }

    public void cancelSearch() {
        if (this.currentQuery != null) {
            this.treeBuilder.cancelSearch(this.currentQuery);
            this.currentQuery.removeCompletionListener(this.completionListener);
            this.currentQuery.cancel();
        }
        if (!this.totalsLabel.isDisposed()) {
            if (Display.getCurrent() == null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SearchResultsView.this.totalsLabel.setText(SearchResultsView.BLANK);
                    }
                });
            } else {
                this.totalsLabel.setText(BLANK);
            }
        }
        this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    public void executeSearch(CMSearchQuery query) {
        query.setWorkbenchPSiterogressService((IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class));
        this.cancelSearch();
        this.currentQuery = query;
        this.currentQuery.addCompletionListener(this.completionListener);
        this.titleLabel.setToolTipText(this.formatToolTipText(query.getDescription(), 100));
        this.updateAndReformatSearchDescription();
        this.totalsLabel.setText("(0)");
        this.totalsLabel.getParent().layout(true);
        this.toggleGroupsAction.setEnabled(false);
        if (this.currentQuery.showGroups()) {
            this.treeBuilder.setShowGroups(this.currentQuery.showGroups());
            this.toggleGroupsAction.setChecked(this.currentQuery.showGroups());
        } else {
            this.treeBuilder.setShowGroups(showGroups);
            this.toggleGroupsAction.setChecked(showGroups);
        }
        this.treeBuilder.startSearch(query);
        this.searchHistoryManager.searchStarted(query);
    }

    private void updateAndReformatSearchDescription() {
        if (this.currentQuery != null && this.titleLabel != null) {
            String fullText = this.currentQuery.getDescription();
            String formattedText = this.currentQuery.getDescription();
            GC labelGC = new GC((Drawable)this.titleLabel);
            int textPreferredWidthPx = labelGC.textExtent((String)fullText).x;
            int labelActualWidthPx = this.titleLabel.getBounds().width;
            int textMaxWidthPx = labelActualWidthPx * 3;
            if (textPreferredWidthPx > textMaxWidthPx) {
                double ratioOfTrim = Integer.valueOf(textMaxWidthPx).doubleValue() / Integer.valueOf(textPreferredWidthPx).doubleValue();
                double textActualLengthChars = Integer.valueOf(fullText.length()).doubleValue();
                int stringTrimPoint = Double.valueOf(textActualLengthChars * ratioOfTrim).intValue();
                int lastSpace = fullText.lastIndexOf(Character.valueOf(' ').charValue(), stringTrimPoint - 5);
                if (lastSpace != -1) {
                    formattedText = String.valueOf(fullText.substring(0, lastSpace)) + "...";
                }
            }
            this.titleLabel.setText(formattedText);
            this.titleLabel.getParent().getParent().layout(true);
            labelGC.dispose();
        }
    }

    @Override
    protected boolean canLinkToSelection() {
        return false;
    }

    @Override
    protected Control createControl(Composite composite) {
        this.c = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.c.setLayout((Layout)gridLayout);
        Composite searchComposite = new Composite(this.c, 0);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 2;
        searchComposite.setLayout((Layout)gridLayout);
        searchComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.titleLabel = new Label(searchComposite, 64);
        this.titleLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.totalsLabel = new Label(searchComposite, 64);
        GridData data = new GridData(0x1000008, 0, false, false);
        this.totalsLabel.setLayoutData((Object)data);
        this.totalsLabel.setText(BLANK);
        this.createResultsArea(this.c);
        this.completionListener = new CMSearchQuery.CompletionListener(){

            @Override
            public void complete() {
                SearchResultsView.this.toggleGroupsAction.setEnabled(SearchResultsView.this.currentQuery.allowGroups());
            }
        };
        this.searchHistoryManager = new SearchHistoryManager(){

            @Override
            public void executeQuery(CMSearchQuery query) {
                SearchResultsView.this.executeSearch(query);
            }
        };
        this.toggleGroupsAction = new Action(Messages.getString("SearchResultsView.GroupsActionShowGroups"), ImageDescriptor.createFromImage((Image)ImageFactory.getGroupsImage())){

            public ImageDescriptor getDisabledImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getGroupsImage_DISABLED());
            }

            public int getStyle() {
                return 2;
            }

            public void runWithEvent(Event event) {
                boolean show = ((ToolItem)event.widget).getSelection();
                SearchResultsView.this.treeBuilder.setShowGroups(show);
                showGroups = show;
                SearchResultsView.this.executeSearch(SearchResultsView.this.currentQuery);
            }

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
            }
        };
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)this.toggleGroupsAction);
        this.toggleGroupsAction.setEnabled(true);
        this.c.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SearchResultsView.this.updateAndReformatSearchDescription();
            }
        });
        this.searchHistoryManager.createActions(toolBarManager);
        return this.c;
    }

    @Override
    protected String getHelpContextID() {
        return "com.ibm.cics.cm.ui.view_search";
    }

    @Override
    protected Control getPrimaryControl() {
        return this.tree;
    }

    @Override
    protected ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    @Override
    protected void refresh(boolean isUser) {
    }

    @Override
    protected void setInput(Object input) {
    }

    @Override
    public void disconnected() {
        debug.enter("disconnected");
        this.cancelSearch();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SearchResultsView.super.disconnected();
                SearchResultsView.this.titleLabel.setText(SearchResultsView.BLANK);
                SearchResultsView.this.titleLabel.getParent().getParent().layout(true);
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(runnable);
        } else {
            runnable.run();
        }
        debug.exit("disconnected");
    }

    @Override
    protected void makeActions(IWorkbenchWindow window) {
    }

    @Override
    protected void fillActionBar(IActionBars actionBars) {
    }

    public static SearchResultsView getDefault() {
        return view;
    }

    private String formatToolTipText(String input, int maxLineLength) {
        String output = input;
        int initialLength = input.length();
        int devisor = maxLineLength;
        int remainder = initialLength % devisor;
        int lines = 1;
        if (initialLength > devisor) {
            lines = remainder != 0 ? (initialLength - remainder) / devisor + 1 : initialLength / devisor;
            int i = 1;
            while (i < lines) {
                int lastSpace = output.lastIndexOf(Character.valueOf(' ').charValue(), i * devisor);
                int lastComma = output.lastIndexOf(Character.valueOf(',').charValue(), i * devisor);
                int newlinePoint = Math.max(lastComma, lastSpace) + 1;
                output = String.valueOf(output.substring(0, newlinePoint)) + "\n" + output.substring(newlinePoint);
                ++i;
            }
        }
        return output;
    }
}

