/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.views;

import com.ibm.cics.cm.cpsm.comm.CMSMConnection;
import com.ibm.cics.cm.cpsm.comm.CMUtils;
import com.ibm.cics.cm.cpsm.comm.ICMSMConnection;
import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.DateRange;
import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.History;
import com.ibm.cics.cm.model.HistoryEntry;
import com.ibm.cics.cm.model.HistoryFilterAttribute;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.IHistoryProvider;
import com.ibm.cics.cm.model.runtime.IRestrictionCriteria;
import com.ibm.cics.cm.ui.DateRangeDialog;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.adapters.ICSDGroupDefinitionToIHistoryProviderAdapterFactory;
import com.ibm.cics.cm.ui.adapters.IResourceGroupDefinitionToIHistoryProviderAdapterFactory;
import com.ibm.cics.cm.ui.history.HistoryFilter;
import com.ibm.cics.cm.ui.history.HistoryFilterFactory;
import com.ibm.cics.cm.ui.history.ResourceDefinitionType;
import com.ibm.cics.cm.ui.views.CMViewPart;
import com.ibm.cics.cm.utilities.TreeSelectionProvider;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.model.CICSTypes;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import com.ibm.cics.model.IApplicationDefinition;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSRegionDefinition;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICSDGroupDefinition;
import com.ibm.cics.model.IPlatformDefinition;
import com.ibm.cics.model.IResourceGroupDefinition;
import com.ibm.cics.model.IWorkloadSpecification;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeAdapter;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;

public class HistoryView
extends CMViewPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2008, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ID = "com.ibm.cics.cm.view.history";
    public Tree tree;
    private TreeSelectionProvider selectionProvider;
    private Table compareTable;
    private Job job;
    private static final String DUMMY_CHILD = "DUMMY_CHILD";
    private static final String PROVIDER = "PROVIDER";
    private static final String SORTPROPERTY = "SORTPROPERTY";
    private static final String RESOURCETYPE = "RESOURCETYPE";
    private Action groupByDateAction;
    private boolean groupByDate = false;
    private Collection<History> currentSortedHistory;
    private SortedSet<History> currentHistory = History.getDescendingSortedHistorySet();
    private TreeItem busyTreeItem;
    private boolean isRefreshingExistingInput;
    protected String sortProperty;
    protected int sortDirection;
    private Action removeFilterAction;
    private Action dateRangeAction;
    protected Date fromDate;
    protected Date toDate;
    protected boolean datesSetByUser = false;
    private List<IContributionItem> filterToolBarContributionItems = new ArrayList<IContributionItem>();
    private IContributionItem runFilterContribution;
    private Action runFilterAction;
    private Action clearFilterAction;
    private ActionContributionItem clearFilterContribution;
    private boolean cancelled;
    private Collection<HistoryFilter> filters;
    private List<HistoryFilter> currentFilters = new ArrayList<HistoryFilter>();
    private static final Logger logger = Logger.getLogger(CMViewPart.class.getPackage().getName());
    Job adapterJob;
    private int itemCount;

    @Override
    protected Control createControl(Composite parent) {
        this.setContentDescription("");
        SashForm sashForm = new SashForm(parent, 256);
        this.tree = new Tree((Composite)sashForm, 65538);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        TreeColumn dateColumn = new TreeColumn(this.tree, 0);
        dateColumn.setText(Messages.getString("HistoryView.ColumnLabelRevisionTime"));
        dateColumn.setToolTipText(Messages.getString("HistoryView.ColumnToolTipRevisionTime"));
        dateColumn.setData(SORTPROPERTY, (Object)"CREATETIME");
        dateColumn.addSelectionListener(this.getSortSelectionAdapter());
        TreeColumn resourceNameColumn = new TreeColumn(this.tree, 0);
        resourceNameColumn.setText(Messages.getString("HistoryView.ColumnLabelResourceNameAfter"));
        resourceNameColumn.setToolTipText(Messages.getString("HistoryView.ColumnToolTipResourceNameAfter"));
        resourceNameColumn.setData(SORTPROPERTY, (Object)"OBJNAME");
        resourceNameColumn.addSelectionListener(this.getSortSelectionAdapter());
        TreeColumn resourceTypeColumn = new TreeColumn(this.tree, 0);
        resourceTypeColumn.setText(Messages.getString("HistoryView.ColumnLabelResourceTypeBefore"));
        resourceTypeColumn.setToolTipText(Messages.getString("HistoryView.ColumnToolTipResourceTypeBefore"));
        resourceTypeColumn.setData(SORTPROPERTY, (Object)"TYPE");
        resourceTypeColumn.addSelectionListener(this.getSortSelectionAdapter());
        TreeColumn groupColumn = new TreeColumn(this.tree, 0);
        groupColumn.setText(Messages.getString("HistoryView.ColumnLabelGroup"));
        groupColumn.setToolTipText(Messages.getString("HistoryView.ColumnToolTipGroup"));
        groupColumn.setData(SORTPROPERTY, (Object)"OBJGROUP");
        groupColumn.addSelectionListener(this.getSortSelectionAdapter());
        TreeColumn userColumn = new TreeColumn(this.tree, 0);
        userColumn.setText(Messages.getString("HistoryView.ColumnLabelUserName"));
        userColumn.setToolTipText(Messages.getString("HistoryView.ColumnToolTipUserName"));
        userColumn.setData(SORTPROPERTY, (Object)"USERID");
        userColumn.addSelectionListener(this.getSortSelectionAdapter());
        TreeColumn configColumn = new TreeColumn(this.tree, 0);
        configColumn.setText(Messages.getString("HistoryView.ColumnLabelConfiguration"));
        configColumn.setToolTipText(Messages.getString("HistoryView.ColumnToolTipConfiguration"));
        configColumn.setData(SORTPROPERTY, (Object)"CCONFIG");
        configColumn.addSelectionListener(this.getSortSelectionAdapter());
        TreeColumn commandColumn = new TreeColumn(this.tree, 0);
        commandColumn.setText(Messages.getString("HistoryView.ColumnLabelCommand"));
        commandColumn.setToolTipText(Messages.getString("HistoryView.ColumnToolTipCommand"));
        commandColumn.setData(SORTPROPERTY, (Object)"API_COMMAND");
        commandColumn.addSelectionListener(this.getSortSelectionAdapter());
        TreeColumn changePackageColumn = new TreeColumn(this.tree, 0);
        changePackageColumn.setText(Messages.getString("HistoryView.ColumnLabelChangePackage"));
        changePackageColumn.setToolTipText(Messages.getString("HistoryView.ColumnToolTipChangePackage"));
        changePackageColumn.setData(SORTPROPERTY, (Object)"CPID");
        changePackageColumn.addSelectionListener(this.getSortSelectionAdapter());
        TreeColumn schemeColumn = new TreeColumn(this.tree, 0);
        schemeColumn.setText(Messages.getString("HistoryView.ColumnLabelScheme"));
        schemeColumn.setToolTipText(Messages.getString("HistoryView.ColumnToolTipScheme"));
        schemeColumn.setData(SORTPROPERTY, (Object)"SCHEME");
        schemeColumn.addSelectionListener(this.getSortSelectionAdapter());
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(150));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(140));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(140));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(75));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(75));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(75));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(75));
        this.tree.setLayout((Layout)tableLayout);
        MenuManager menuMgr = new MenuManager();
        Menu popupMenu = menuMgr.createContextMenu((Control)this.tree);
        this.tree.setMenu(popupMenu);
        this.selectionProvider = new TreeSelectionProvider(this.tree);
        this.selectionProvider.allowMultipleSelections(true);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.selectionProvider);
        Composite compareComposite = new Composite((Composite)sashForm, 0);
        this.compareTable = new Table(compareComposite, 2048);
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ICICSObject aCICSObject;
                Object selectedItem;
                if (HistoryView.this.tree.getSelectionCount() == 1 && (selectedItem = HistoryView.this.tree.getSelection()[0].getData()) instanceof History && (aCICSObject = (ICICSObject)Platform.getAdapterManager().getAdapter(selectedItem, ICICSDefinition.class)) != null) {
                    BusyIndicator.showWhile((Display)HistoryView.this.tree.getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            UIPlugin.performDefaultViewAction((ICICSObject)aCICSObject);
                        }
                    });
                }
            }
        });
        this.tree.addTreeListener((TreeListener)new TreeAdapter(){

            public void treeExpanded(TreeEvent e) {
                TreeItem treeItem = (TreeItem)e.item;
                if (treeItem.getData() instanceof History) {
                    HistoryView.this.createHistoryFor(treeItem);
                }
            }
        });
        int[] nArray = new int[2];
        nArray[0] = 1;
        sashForm.setWeights(nArray);
        this.createActions();
        return sashForm;
    }

    @Override
    protected void fillToolBar(IToolBarManager toolBar) {
        super.fillToolBar(toolBar);
        this.linkToSelectionAction.setChecked(false);
        toolBar.add((IContributionItem)new Separator("additions"));
        Separator filterGroup = new Separator("filter");
        toolBar.add((IContributionItem)filterGroup);
        GroupMarker filterActionsGroup = new GroupMarker("filterActions");
        toolBar.add((IContributionItem)filterActionsGroup);
    }

    private void addFilterToolBarContributions(IToolBarManager toolBarManager) {
        if (this.filterToolBarContributionItems.size() > 0) {
            toolBarManager.remove(this.runFilterContribution);
            toolBarManager.remove((IContributionItem)this.clearFilterContribution);
            this.removeFilterAction.setEnabled(false);
        }
        for (IContributionItem item : this.filterToolBarContributionItems) {
            toolBarManager.remove(item);
        }
        this.filterToolBarContributionItems.clear();
        for (HistoryFilter filter : this.currentFilters) {
            this.createFilter(toolBarManager, filter);
        }
        if (this.filterToolBarContributionItems.size() > 0) {
            toolBarManager.add(this.runFilterContribution);
            toolBarManager.add((IContributionItem)this.clearFilterContribution);
        }
        this.removeFilterAction.setEnabled(this.filterToolBarContributionItems.size() > 0);
    }

    private void createFilter(IToolBarManager toolBar, final HistoryFilter filter) {
        ControlContribution filterLabel = new ControlContribution(null){

            protected Control createControl(Composite parent) {
                Composite c = new Composite(parent, 0);
                c.setLayout((Layout)new GridLayout(1, false));
                Label label = new Label(c, 0);
                label.setText(MessageFormat.format(Messages.getString("HistoryView.ControlSetLabelTextFilterName"), filter.getDisplayName()));
                GridData data = new GridData(131072, 0x1000000, false, false);
                label.setLayoutData((Object)data);
                return c;
            }
        };
        toolBar.appendToGroup("filter", (IContributionItem)filterLabel);
        this.filterToolBarContributionItems.add((IContributionItem)filterLabel);
        Action operatorAction = new Action("foo", UIActivator.IMGD_EQUALS){

            public void run() {
                if (FilterExpression.Operator.EQ.equals((Object)filter.getOperator())) {
                    filter.setOperator(FilterExpression.Operator.NE);
                    this.setImageDescriptor(UIActivator.IMGD_NOT_EQUALS);
                } else {
                    filter.setOperator(FilterExpression.Operator.EQ);
                    this.setImageDescriptor(UIActivator.IMGD_EQUALS);
                }
            }
        };
        operatorAction.setToolTipText(Messages.getString("HistoryView.OperatorToolTipSetOperator"));
        ActionContributionItem operatorItem = new ActionContributionItem((IAction)operatorAction);
        toolBar.appendToGroup("filter", (IContributionItem)operatorItem);
        this.filterToolBarContributionItems.add((IContributionItem)operatorItem);
        ControlContribution filterControl = new ControlContribution(null){

            protected Control createControl(Composite parent) {
                Control control = filter.getValues() != null ? this.createCombo(parent, filter.getValues()) : this.createText(parent);
                return control;
            }

            private Control createCombo(Composite parent, String[] values) {
                String currentValue;
                int index;
                final Combo combo = new Combo(parent, 12);
                combo.add("");
                int i = 0;
                while (i < values.length) {
                    combo.add(values[i]);
                    ++i;
                }
                if (filter.getDisplayValue() != null && (index = combo.indexOf(currentValue = filter.getDisplayValue())) != -1) {
                    combo.select(index);
                }
                combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String selectedValue = combo.getText();
                        filter.setDisplayValue(selectedValue);
                    }
                });
                filter.setControlEditor(new IControlEditor(){

                    @Override
                    public void clearControl() {
                        combo.setText("");
                    }
                });
                return combo;
            }

            private Control createText(Composite parent) {
                Composite c = new Composite(parent, 0){

                    public Point computeSize(int hint, int hint2, boolean changed) {
                        Point p = super.computeSize(hint, hint2, changed);
                        return new Point(62, p.y);
                    }
                };
                c.setLayout((Layout)new FillLayout());
                final Text text = new Text(c, 132);
                String value = filter.getDisplayValue();
                if (value != null && value.length() > 0) {
                    text.setText(value);
                }
                text.setToolTipText(MessageFormat.format(Messages.getString("HistoryView.FilterToolTipText"), filter.getDisplayName()));
                text.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                        filter.setDisplayValue(text.getText());
                        HistoryView.this.runFilterAction.run();
                    }
                });
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        filter.setDisplayValue(text.getText());
                    }
                });
                filter.setControlEditor(new IControlEditor(){

                    @Override
                    public void clearControl() {
                        text.setText("");
                    }
                });
                return c;
            }
        };
        toolBar.appendToGroup("filter", (IContributionItem)filterControl);
        this.filterToolBarContributionItems.add((IContributionItem)filterControl);
        ControlContribution blankLabel = new ControlContribution(null){

            protected Control createControl(Composite parent) {
                Label label = new Label(parent, 0);
                label.setText(" ");
                return label;
            }
        };
        toolBar.appendToGroup("filter", (IContributionItem)blankLabel);
        this.filterToolBarContributionItems.add((IContributionItem)blankLabel);
    }

    private SelectionListener getSortSelectionAdapter() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Tree parent;
                TreeColumn column = (TreeColumn)e.getSource();
                if (column == (parent = column.getParent()).getSortColumn()) {
                    int currentDirection = parent.getSortDirection();
                    if (currentDirection == 128) {
                        parent.setSortDirection(1024);
                        HistoryView.this.sortDirection = 1024;
                    } else {
                        parent.setSortDirection(128);
                        HistoryView.this.sortDirection = 128;
                    }
                } else {
                    parent.setSortDirection(128);
                    HistoryView.this.sortDirection = 128;
                }
                parent.setSortColumn(column);
                HistoryView.this.tree.setVisible(false);
                HistoryView.this.tree.setLayoutDeferred(true);
                HistoryView.this.tree.removeAll();
                HistoryView.this.itemCount = 0;
                HistoryView.this.createBusyTreeItem();
                HistoryView.this.tree.setLayoutDeferred(false);
                HistoryView.this.tree.setVisible(true);
                HistoryView.this.sortProperty = (String)column.getData(HistoryView.SORTPROPERTY);
                HistoryView.this.refresh(false);
            }
        };
    }

    private void createActions() {
        this.groupByDateAction = new Action(Messages.getString("HistoryView.groupByDateAction"), UIActivator.IMGD_GROUP_BY_DATE){

            public void run() {
                HistoryView.this.groupByDate = this.isChecked();
                HistoryView.this.refresh(false);
            }

            public int getStyle() {
                return 2;
            }
        };
        this.dateRangeAction = new Action(Messages.getString("HistoryView.DateRangeToolTipSetDateRange"), UIActivator.IMGD_DATE_RANGE){

            public void run() {
                DateRangeDialog dialog = new DateRangeDialog(HistoryView.this.getSite().getShell());
                dialog.setFromDate(HistoryView.this.fromDate);
                dialog.setToDate(HistoryView.this.toDate);
                if (dialog.open() == 0) {
                    HistoryView.this.fromDate = dialog.getFromDate();
                    HistoryView.this.toDate = dialog.getToDate();
                    HistoryView.this.datesSetByUser = true;
                    if (HistoryView.this.existingInput != null) {
                        ((IHistoryProvider)HistoryView.this.existingInput).setFromDate(HistoryView.this.fromDate);
                        ((IHistoryProvider)HistoryView.this.existingInput).setToDate(HistoryView.this.toDate);
                        HistoryView.this.currentSortedHistory = null;
                        HistoryView.this.refresh(false);
                    }
                }
            }
        };
        this.runFilterAction = new Action(Messages.getString("HistoryView.FilterActionRun"), UIActivator.IMGD_RUN){

            public void run() {
                Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"runFilterAction.run");
                if (HistoryView.this.currentFilters.size() > 0) {
                    HistoryView.this.removeFilterAction.setEnabled(true);
                }
                HistoryView.this.currentSortedHistory = null;
                HistoryView.this.refresh(false);
                Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"runFilterAction.run");
            }
        };
        this.runFilterContribution = new ActionContributionItem((IAction)this.runFilterAction);
        this.clearFilterAction = new Action(Messages.getString("HistoryView.FilterActionClearFilters"), UIActivator.IMGD_CLEAR_FILTER){

            public void run() {
                Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"run");
                for (HistoryFilter filter : HistoryView.this.currentFilters) {
                    filter.clear();
                }
                HistoryView.this.runFilterAction.run();
                Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"run");
            }
        };
        this.clearFilterContribution = new ActionContributionItem((IAction)this.clearFilterAction);
        this.removeFilterAction = new Action(Messages.getString("HistoryView.FilterActionRemoveFilters"), UIActivator.IMGD_REMOVE_FILTERS){

            public void run() {
                for (HistoryFilter filter : HistoryView.this.currentFilters) {
                    filter.reset();
                    filter.getAction().setChecked(false);
                }
                HistoryView.this.currentFilters.clear();
                HistoryView.this.updateToolBar();
                HistoryView.this.runFilterAction.run();
            }
        };
        this.removeFilterAction.setEnabled(false);
        IToolBarManager toolBar = this.getViewSite().getActionBars().getToolBarManager();
        toolBar.add((IAction)this.groupByDateAction);
    }

    protected void fillMenu(IMenuManager menu) {
        menu.add((IAction)this.dateRangeAction);
        MenuManager filtersMenu = new MenuManager(Messages.getString("HistoryView.FiltersMenuSelectFilters"));
        this.fillFilterMenu((IMenuManager)filtersMenu);
        menu.add((IContributionItem)filtersMenu);
        menu.add((IAction)this.removeFilterAction);
    }

    private void fillFilterMenu(IMenuManager menu) {
        this.filters = HistoryFilterFactory.getFilters();
        for (final HistoryFilter filter : this.filters) {
            Action action = new Action(filter.getDisplayName(), 2){

                public void run() {
                    if (this.isChecked()) {
                        HistoryView.this.addFilter(filter);
                    } else {
                        HistoryView.this.removeFilter(filter);
                    }
                    HistoryView.this.updateToolBar();
                }
            };
            if (this.currentFilters.contains(filter)) {
                action.setChecked(true);
            }
            filter.setAction((IAction)action);
            menu.add((IAction)action);
        }
    }

    protected void removeFilter(HistoryFilter filter) {
        this.currentFilters.remove(filter);
        filter.reset();
    }

    public void addFilter(HistoryFilter filter) {
        this.currentFilters.add(filter);
    }

    protected void updateToolBar() {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"updateToolBar");
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager manager = actionBars.getToolBarManager();
        this.addFilterToolBarContributions(manager);
        manager.update(true);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"updateToolBar");
    }

    @Override
    protected void fillActionBar(IActionBars actionBars) {
        IMenuManager menu = actionBars.getMenuManager();
        this.fillMenu(menu);
        IToolBarManager toolBar = actionBars.getToolBarManager();
        this.fillToolBar(toolBar);
        toolBar.add((IContributionItem)new Separator("additions"));
        Separator filterGroup = new Separator("filter");
        toolBar.add((IContributionItem)filterGroup);
    }

    private void createHistoryFor(final TreeItem aTreeItem) {
        this.cancelJob();
        TreeItem[] items = aTreeItem.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        final TreeItem dummyItem = new TreeItem(aTreeItem, 0);
        dummyItem.setData((Object)DUMMY_CHILD);
        dummyItem.setText(Messages.getString("HistoryView.DummyItemTextFetching"));
        dummyItem.setImage(UIActivator.getBusyImage());
        aTreeItem.setData(DUMMY_CHILD, (Object)dummyItem);
        final Object treeItemData = aTreeItem.getData();
        this.job = new JobWithCancelingSupport(Messages.getString("HistoryView.JobFetchingHistory")){
            private boolean isCancelled;

            private void disposeDummyChild() {
                aTreeItem.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!dummyItem.isDisposed()) {
                            dummyItem.dispose();
                        }
                    }
                });
            }

            protected void cancelingSub() {
                this.isCancelled = true;
            }

            protected IStatus runSub(IProgressMonitor monitor) {
                if (treeItemData instanceof History) {
                    final History selectedHistory = (History)treeItemData;
                    final Map changes = selectedHistory.getHistoryEntry().getChanges();
                    if (monitor.isCanceled()) {
                        this.disposeDummyChild();
                        return Status.CANCEL_STATUS;
                    }
                    aTreeItem.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            dummyItem.dispose();
                            if (!isCancelled) {
                                ResourceDefinitionType resourceType = HistoryView.this.getResourceType(selectedHistory);
                                String[] attributeNameList = changes.keySet().toArray(new String[0]);
                                String[] stringArray = attributeNameList = resourceType.getOrderedAttributeNames(changes);
                                int n = attributeNameList.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String attributeName = stringArray[n2];
                                    HistoryEntry.Change change = (HistoryEntry.Change)changes.get(attributeName);
                                    if (!isCancelled && change != null) {
                                        String beforeValue;
                                        TreeItem treeItem = new TreeItem(aTreeItem, 0);
                                        treeItem.setText(0, HistoryView.this.getAttributeDescription(attributeName));
                                        String afterValue = change.getAfterValue();
                                        if (afterValue != null) {
                                            treeItem.setText(1, afterValue);
                                        }
                                        if ((beforeValue = change.getBeforeValue()) != null) {
                                            treeItem.setText(2, beforeValue);
                                        }
                                        treeItem.setImage(UIActivator.getImage(UIActivator.IMGD520_HISTORY_ATTRIBUTE));
                                        treeItem.setExpanded(true);
                                        treeItem.getParentItem().setExpanded(true);
                                    }
                                    ++n2;
                                }
                            }
                        }
                    });
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        this.schedule(this.job);
    }

    private ResourceDefinitionType getResourceType(History selectedHistory) {
        ResourceDefinitionType resourceType = (ResourceDefinitionType)this.tree.getData(RESOURCETYPE);
        if (resourceType == null) {
            resourceType = ResourceDefinitionType.getResourceDefinitionType(selectedHistory.getType());
            this.tree.setData(RESOURCETYPE, (Object)resourceType);
        }
        return resourceType;
    }

    private String getAttributeDescription(String anAttributeName) {
        ResourceDefinitionType resourceType = (ResourceDefinitionType)this.tree.getData(RESOURCETYPE);
        if (resourceType != null) {
            return resourceType.getAttributeName(anAttributeName);
        }
        return anAttributeName;
    }

    private Collection<History> getSortedHistoryFor(IHistoryProvider historyProvider) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getSortedHistoryFor", (Object)historyProvider);
        if (historyProvider != null) {
            ArrayList<History> list = new ArrayList<History>();
            if (this.currentSortedHistory == null) {
                ArrayList<IRestrictionCriteria> filters = new ArrayList<IRestrictionCriteria>();
                for (HistoryFilter filter : this.currentFilters) {
                    if (filter.getDisplayValue() == null) continue;
                    filters.add(filter.getRestrictionCriteria());
                }
                IFilteredCollection history = historyProvider.getHistory(true, filters);
                if (history == null) {
                    return new ArrayList<History>();
                }
                this.currentSortedHistory = history.getResults();
                list.addAll(this.currentSortedHistory);
            } else {
                list.addAll(this.currentSortedHistory);
            }
            if (this.sortProperty == null || "CREATETIME".equals(this.sortProperty)) {
                if (this.sortDirection == 128) {
                    SortedSet asAscendingChangeDate = History.asAscendingChangeDate(list);
                    Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getSortedHistoryFor", (Object)asAscendingChangeDate);
                    return asAscendingChangeDate;
                }
                SortedSet asDescendingChangeDate = History.asDescendingChangeDate(list);
                Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getSortedHistoryFor", (Object)asDescendingChangeDate);
                return asDescendingChangeDate;
            }
            if (this.sortDirection == 128) {
                List asAscending = History.asAscending(list, (String)this.sortProperty);
                Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getSortedHistoryFor", (Object)asAscending);
                return asAscending;
            }
            List asDescending = History.asDescending(list, (String)this.sortProperty);
            Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getSortedHistoryFor", (Object)asDescending);
            return asDescending;
        }
        TreeSet<History> treeSet = new TreeSet<History>();
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getSortedHistoryFor", treeSet);
        return treeSet;
    }

    private void cancelJob() {
        if (this.job != null && this.job.getState() == 4) {
            this.job.cancel();
        }
        this.job = null;
    }

    public void setInput(IHistoryProvider historyProvider) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"setInput", (Object)historyProvider);
        this.setInput(historyProvider, null);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"setInput");
    }

    public void setInput(IHistoryProvider historyProvider, List<HistoryFilterAttribute> filterAttributes) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"setInput", (Object)historyProvider, filterAttributes);
        if (this.tree.isDisposed()) {
            return;
        }
        if (historyProvider == null) {
            Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"setInput");
            return;
        }
        if (this.existingInput instanceof IHistoryProvider && filterAttributes == null && this.existingInput != null && this.existingInput.equals(historyProvider)) {
            Date existingChangeTime = ((IHistoryProvider)this.existingInput).getChangeTime();
            Date newChangeTime = historyProvider.getChangeTime();
            if (existingChangeTime != null && newChangeTime != null && existingChangeTime.equals(newChangeTime) && !this.cancelled) {
                Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"setInput");
                return;
            }
        }
        this.tree.setData(RESOURCETYPE, null);
        this.isRefreshingExistingInput = this.existingInput != null && this.existingInput.equals(historyProvider) && this.itemCount > 0;
        this.existingInput = historyProvider;
        this.cancelJob();
        this.setContentDescription(historyProvider);
        this.tree.setSortColumn(null);
        this.currentSortedHistory = null;
        if (this.datesSetByUser) {
            historyProvider.setFromDate(this.fromDate);
            historyProvider.setToDate(this.toDate);
            this.setContentDescription(historyProvider);
        } else {
            this.fromDate = historyProvider.getHistoryFromDate();
            this.toDate = historyProvider.getHistoryToDate();
        }
        if (filterAttributes != null) {
            for (HistoryFilter filter : this.currentFilters) {
                filter.reset();
                filter.getAction().setChecked(false);
            }
            this.currentFilters = HistoryFilterFactory.getFiltersFromListOfAttributes(filterAttributes);
            for (HistoryFilter filter : this.currentFilters) {
                filter.getAction().setChecked(true);
            }
            this.updateToolBar();
        }
        this.populateTreeWithHistory(historyProvider);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"setInput");
    }

    private void setContentDescription(IHistoryProvider historyProvider) {
        String toDate;
        String description = "";
        String name = historyProvider.getIHistoryProvider().getName();
        String fromDate = historyProvider.getHistoryFromDateAsDisplay();
        if (fromDate == null) {
            fromDate = "";
        }
        description = (toDate = historyProvider.getHistoryToDateAsDisplay()) != null ? (fromDate != "EARLIEST" ? (toDate != "LATEST" ? MessageFormat.format(Messages.getString("HistoryView.HistoryDescription1"), name, fromDate, toDate) : MessageFormat.format(Messages.getString("HistoryView.HistoryDescription2"), name, fromDate)) : (toDate != "LATEST" ? MessageFormat.format(Messages.getString("HistoryView.HistoryDescription3"), name, toDate) : MessageFormat.format(Messages.getString("HistoryView.HistoryDescription4"), name))) : (fromDate != "EARLIEST" ? MessageFormat.format(Messages.getString("HistoryView.HistoryDescription5"), name, fromDate) : MessageFormat.format(Messages.getString("HistoryView.HistoryDescription6"), name));
        this.setContentDescription(description);
    }

    private void createBusyTreeItem() {
        this.busyTreeItem = new TreeItem(this.tree, 0);
        this.busyTreeItem.setText(Messages.getString("HistoryView.BusyItemTextFetching"));
        this.busyTreeItem.setImage(UIActivator.getBusyImage());
    }

    private void disposeBusyTreeItem() {
        this.busyTreeItem.dispose();
    }

    private void populateTreeWithHistory(final IHistoryProvider historyProvider) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"populateTreeWithHistory", (Object)historyProvider);
        this.tree.setData(PROVIDER, (Object)historyProvider);
        if (!this.isRefreshingExistingInput) {
            this.tree.setVisible(false);
            this.tree.setLayoutDeferred(true);
            this.tree.removeAll();
            this.itemCount = 0;
            this.tree.setVisible(true);
            this.createBusyTreeItem();
            this.tree.setLayoutDeferred(false);
        }
        this.job = new JobWithCancelingSupport(MessageFormat.format(Messages.getString("HistoryView.JobFetchingHistoryFor1"), historyProvider.getIHistoryProvider().getName())){
            boolean isCancelled;
            {
                super($anonymous0);
                this.isCancelled = false;
            }

            protected IStatus runSub(IProgressMonitor monitor) {
                monitor.beginTask(MessageFormat.format(Messages.getString("HistoryView.JobFetchingHistoryFor2"), historyProvider.getIHistoryProvider().getName()), -1);
                Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"runSub", (Object)monitor);
                HistoryView.this.currentSortedHistory = HistoryView.this.getSortedHistoryFor(historyProvider);
                if (monitor.isCanceled()) {
                    Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"runSub", (Object)Status.CANCEL_STATUS);
                    return Status.CANCEL_STATUS;
                }
                if (!HistoryView.this.tree.isDisposed()) {
                    HistoryView.this.tree.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"run");
                            if (!isCancelled && !(this).HistoryView.this.tree.isDisposed()) {
                                if ((this).HistoryView.this.tree.getData(HistoryView.PROVIDER) != historyProvider) {
                                    Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"run");
                                    return;
                                }
                                HistoryView.this.disposeBusyTreeItem();
                                if (!HistoryView.this.groupByDate) {
                                    HistoryView.this.createFlatHistoryItems(historyProvider);
                                } else {
                                    HistoryView.this.createDateGroupedHistoryItems(historyProvider);
                                }
                            }
                            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"run");
                        }
                    });
                }
                monitor.done();
                HistoryView.this.cancelled = false;
                Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"runSub", (Object)Status.OK_STATUS);
                return Status.OK_STATUS;
            }

            protected void cancelingSub() {
                Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"cancelingSub");
                this.isCancelled = true;
                HistoryView.this.cancelled((Job)this);
                Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"cancelingSub");
            }
        };
        this.schedule(this.job);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"populateTreeWithHistory");
    }

    private void createFlatHistoryItems(IHistoryProvider historyProvider) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createFlatHistoryItems", (Object)historyProvider);
        this.tree.setVisible(false);
        if (this.isRefreshingExistingInput) {
            SortedSet newHistory = History.getAscendingSortedHistorySet();
            SortedSet possibleNewHistorySet = History.getDescendingSortedHistorySet();
            possibleNewHistorySet.addAll(this.currentSortedHistory);
            for (History possibleNewHistory : possibleNewHistorySet) {
                if (this.currentHistory.contains(possibleNewHistory)) continue;
                newHistory.add(possibleNewHistory);
            }
            TreeItem topNewTreeItem = null;
            for (History history : newHistory) {
                TreeItem historyItem;
                if (this.tree.getData(PROVIDER) != historyProvider) {
                    return;
                }
                topNewTreeItem = historyItem = new TreeItem(this.tree, 0, 0);
                this.alter(historyItem, history);
                this.currentHistory.add(history);
            }
            if (topNewTreeItem != null) {
                final TreeItem finalTopNewTreeItem = topNewTreeItem;
                this.tree.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        finalTopNewTreeItem.setExpanded(true);
                        HistoryView.this.createHistoryFor(finalTopNewTreeItem);
                        HistoryView.this.tree.showItem(finalTopNewTreeItem);
                    }
                });
            }
        } else {
            this.currentHistory.clear();
            for (History history : this.currentSortedHistory) {
                if (this.tree.getData(PROVIDER) != historyProvider) {
                    return;
                }
                TreeItem historyItem = new TreeItem(this.tree, 0);
                this.alter(historyItem, history);
                this.currentHistory.add(history);
            }
        }
        this.tree.setVisible(true);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createFlatHistoryItems");
    }

    private void alter(TreeItem aTreeItem, History aHistory) {
        ++this.itemCount;
        aTreeItem.setText(0, CMUtilities.toStringyyyyMMddDate((Date)aHistory.getCreationTime()));
        aTreeItem.setText(1, aHistory.getName());
        aTreeItem.setText(2, aHistory.getType());
        aTreeItem.setText(3, aHistory.getResourceGroup());
        aTreeItem.setText(4, aHistory.getChangedBy());
        aTreeItem.setText(5, aHistory.getConfiguration());
        aTreeItem.setText(6, aHistory.getCommand());
        aTreeItem.setText(7, aHistory.getPackage());
        aTreeItem.setText(8, aHistory.getScheme());
        aTreeItem.setData((Object)aHistory);
        aTreeItem.setImage(UIActivator.getImage(UIActivator.IMGD520_HISTORY_ITEM));
        ICICSType findForResourceTableName = CICSTypes.findForResourceTableName((String)aHistory.getType());
        if (findForResourceTableName == null && !aHistory.getType().equals("ZFSFILE")) {
            return;
        }
        TreeItem dummyChildItem = new TreeItem(aTreeItem, 0);
        dummyChildItem.setData((Object)DUMMY_CHILD);
        dummyChildItem.setText(Messages.getString("HistoryView.DummyChildItemTextFetching"));
        dummyChildItem.setImage(UIActivator.getBusyImage());
    }

    private void createDateGroupedHistoryItems(IHistoryProvider historyProvider) {
        this.currentHistory.clear();
        this.tree.removeAll();
        this.itemCount = 0;
        Map historyByDateMap = History.groupByDate(this.currentSortedHistory);
        Iterator historyByDateIterator = historyByDateMap.entrySet().iterator();
        while (historyByDateIterator.hasNext()) {
            if (this.tree.getData(PROVIDER) != historyProvider) {
                return;
            }
            Map.Entry dateRangeHistoryEntry = historyByDateIterator.next();
            TreeItem dateRangeTreeItem = new TreeItem(this.tree, 0);
            dateRangeTreeItem.setImage(UIActivator.getImage(UIActivator.IMGD_GROUP_BY_DATE));
            dateRangeTreeItem.setText(((DateRange)dateRangeHistoryEntry.getKey()).toString());
            dateRangeTreeItem.setData(dateRangeHistoryEntry.getKey());
            Iterator historyItems = ((Collection)dateRangeHistoryEntry.getValue()).iterator();
            while (historyItems.hasNext()) {
                if (this.tree.getData(PROVIDER) != historyProvider) {
                    return;
                }
                History history = (History)historyItems.next();
                TreeItem historyTreeItem = new TreeItem(dateRangeTreeItem, 0);
                this.alter(historyTreeItem, history);
                this.currentHistory.add(history);
            }
        }
        this.tree.setVisible(false);
        TreeItem[] items = this.tree.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setExpanded(true);
            ++i;
        }
        this.tree.setVisible(true);
    }

    @Override
    protected void setInput(final Object input) {
        if (input instanceof ICICSDefinition) {
            if (this.adapterJob != null) {
                this.adapterJob.cancel();
            }
            this.adapterJob = new JobWithCancelingSupport(Messages.getString("HistoryView.JobFetchHistory")){
                private boolean cancelled;
                {
                    super($anonymous0);
                    this.cancelled = false;
                }

                protected void cancelingSub() {
                    this.cancelled = true;
                }

                protected IStatus runSub(IProgressMonitor monitor) {
                    if (!this.cancelled) {
                        IConnectable smConnectable;
                        ICMDefinition aCMDefinition = (ICMDefinition)Platform.getAdapterManager().getAdapter(input, ICMDefinition.class);
                        if (aCMDefinition == null && input instanceof ICICSDefinition && (smConnectable = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.sm.connection")) instanceof ICMSMConnection) {
                            aCMDefinition = ((ICMSMConnection)smConnectable.getConnection()).getCMDefinitionByFindingFirstResourceGroup((ICICSDefinition)input);
                        }
                        final ICMDefinition finalCMDefinition = aCMDefinition;
                        if (!HistoryView.this.tree.isDisposed()) {
                            HistoryView.this.tree.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!cancelled) {
                                        HistoryView.this.setInput((IHistoryProvider)finalCMDefinition);
                                    }
                                }
                            });
                        }
                        return Status.OK_STATUS;
                    }
                    return Status.CANCEL_STATUS;
                }
            };
            this.schedule(this.adapterJob);
        } else if (input instanceof IResourceGroupDefinition) {
            IResourceGroupDefinitionToIHistoryProviderAdapterFactory adapter = new IResourceGroupDefinitionToIHistoryProviderAdapterFactory();
            IHistoryProvider historyProvider = (IHistoryProvider)adapter.getAdapter((IResourceGroupDefinition)input, IHistoryProvider.class);
            this.setInput(historyProvider);
        } else if (input instanceof ICSDGroupDefinition) {
            ICSDGroupDefinitionToIHistoryProviderAdapterFactory adapter = new ICSDGroupDefinitionToIHistoryProviderAdapterFactory();
            IHistoryProvider historyProvider = (IHistoryProvider)adapter.getAdapter((ICSDGroupDefinition)input, IHistoryProvider.class);
            this.setInput(historyProvider);
        } else if (input instanceof IApplicationDefinition) {
            IApplicationDefinition iAppDef = (IApplicationDefinition)input;
            IPrimaryKey context = (IPrimaryKey)((ICoreObject)iAppDef).getAdapter(IPrimaryKey.class);
            ICMDefinition applDefCM = CMUtils.getCMApplDefByListingWithKeyValues((IPrimaryKey)context);
            this.setInput((IHistoryProvider)applDefCM);
        } else if (input instanceof IPlatformDefinition) {
            IPrimaryKey context = (IPrimaryKey)((ICoreObject)input).getAdapter(IPrimaryKey.class);
            Configuration configuration = CMSMConnection.getConfiguration((IContext)context);
            ICMDefinition definition = null;
            if (configuration != null) {
                definition = configuration.getDefinition(((IPlatformDefinition)input).getObjectType().getResourceTableName(), context.getAttributeValue("NAME"));
            }
            this.setInput((IHistoryProvider)definition);
        } else if (input instanceof ICICSRegionDefinition) {
            IPrimaryKey context = (IPrimaryKey)((ICoreObject)input).getAdapter(IPrimaryKey.class);
            Configuration configuration = CMSMConnection.getConfiguration((IContext)context);
            ICMDefinition definition = null;
            if (configuration != null) {
                definition = configuration.getDefinition(((ICICSRegionDefinition)input).getObjectType().getResourceTableName(), context.getAttributeValue("NAME"));
            }
            this.setInput((IHistoryProvider)definition);
        } else if (input instanceof ICICSRegionGroupDefinition) {
            IPrimaryKey context = (IPrimaryKey)((ICoreObject)input).getAdapter(IPrimaryKey.class);
            Configuration configuration = CMSMConnection.getConfiguration((IContext)context);
            ICMDefinition definition = null;
            if (configuration != null) {
                definition = configuration.getDefinition(((ICICSRegionGroupDefinition)input).getObjectType().getResourceTableName(), context.getAttributeValue("GROUP"));
            }
            this.setInput((IHistoryProvider)definition);
        } else if (input instanceof IWorkloadSpecification) {
            IPrimaryKey context = (IPrimaryKey)((ICoreObject)input).getAdapter(IPrimaryKey.class);
            Configuration configuration = CMSMConnection.getConfiguration((IContext)context);
            ICMDefinition definition = null;
            if (configuration != null) {
                definition = configuration.getDefinition(((IWorkloadSpecification)input).getObjectType().getResourceTableName(), context.getAttributeValue("NAME"));
            }
            this.setInput((IHistoryProvider)definition);
        } else if (input instanceof IHistoryProvider) {
            this.setInput((IHistoryProvider)input);
        }
    }

    @Override
    protected void setVisible(boolean bool) {
        super.setVisible(bool);
        if (!bool) {
            if (this.job != null) {
                this.job.cancel();
            }
            if (this.adapterJob != null) {
                this.adapterJob.cancel();
            }
            this.tree.setData(PROVIDER, null);
            this.tree.removeAll();
            this.itemCount = 0;
            this.setContentDescription("");
        } else {
            ISelection selection = this.getSite().getWorkbenchWindow().getSelectionService().getSelection();
            if (selection instanceof IStructuredSelection) {
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                if (firstElement instanceof ICICSDefinition || firstElement instanceof IHistoryProvider) {
                    this.setInput(firstElement);
                } else {
                    this.refresh(false);
                }
            } else {
                this.refresh(false);
            }
        }
    }

    @Override
    public void connected() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                HistoryView.super.connected();
                HistoryView.this.tree.removeAll();
                HistoryView.this.itemCount = 0;
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public void setFocus() {
        this.tree.setFocus();
    }

    @Override
    protected void refresh(boolean force) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"refresh", (Object)force);
        this.cancelJob();
        if (force) {
            this.currentSortedHistory = null;
            this.isRefreshingExistingInput = true;
        } else {
            this.isRefreshingExistingInput = false;
        }
        if (this.job != null && this.job.getState() == 4) {
            this.job.cancel();
        }
        if (this.existingInput == null) {
            return;
        }
        final IHistoryProvider historyProvider = (IHistoryProvider)this.existingInput;
        this.setContentDescription(historyProvider);
        this.job = new JobWithCancelingSupport(MessageFormat.format(Messages.getString("HistoryView.JobFetchingHistoryFor3"), historyProvider.getIHistoryProvider().getName())){

            protected IStatus runSub(IProgressMonitor monitor) {
                Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"runSub");
                monitor.beginTask(MessageFormat.format(Messages.getString("HistoryView.JobFetchingHistoryFor4"), historyProvider.getIHistoryProvider().getName()), -1);
                if (monitor.isCanceled()) {
                    Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"runSub", (Object)Status.CANCEL_STATUS);
                    return Status.CANCEL_STATUS;
                }
                if (!HistoryView.this.tree.isDisposed()) {
                    HistoryView.this.tree.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            HistoryView.this.populateTreeWithHistory(historyProvider);
                        }
                    });
                }
                monitor.done();
                Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"runSub", (Object)Status.OK_STATUS);
                return Status.OK_STATUS;
            }

            protected void cancelingSub() {
                HistoryView.this.cancelled((Job)this);
            }
        };
        this.schedule(this.job);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"refresh");
    }

    protected void cancelled(Job aJob) {
        if (this.job == aJob && !this.tree.isDisposed()) {
            this.tree.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!HistoryView.this.tree.isDisposed()) {
                        HistoryView.this.tree.removeAll();
                    }
                    HistoryView.this.itemCount = 0;
                    HistoryView.this.currentSortedHistory = null;
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(HistoryView.this.getContentDescription());
                    buffer.append(Messages.getString("HistoryView.JobCancelled"));
                    HistoryView.this.setContentDescription(buffer.toString());
                    HistoryView.this.cancelled = true;
                }
            });
        }
    }

    @Override
    protected boolean canLinkToSelection() {
        return true;
    }

    @Override
    protected String getHelpContextID() {
        return "com.ibm.cics.cm.ui.view_history";
    }

    @Override
    protected Control getPrimaryControl() {
        return this.tree;
    }

    @Override
    protected ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public void refreshInput(IHistoryProvider historyProvider) {
        if (this.existingInput.equals(historyProvider)) {
            this.refresh(true);
        }
    }

    public void refreshInput() {
        this.refresh(true);
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public static interface IControlEditor {
        public void clearControl();
    }
}

