/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.views;

import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.EnsureUppercaseListener;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.utilities.TableSelectionProvider;
import com.ibm.cics.cm.utilities.Utilities;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;

public class FilteredTableComposite
extends Composite
implements Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Text searchText;
    protected Table table;
    private TimerTask searchTimerTask;
    private static Timer timer = new Timer(true);
    private List<Listener> listeners;
    private boolean multipleSelections;
    protected Label totalsLabel;
    protected Composite centerComposite;
    protected int LABEL_OFFSET = -4;
    private TableSelectionProvider selectionProvider;

    public FilteredTableComposite(Composite parent, int tableStyle, IToolBarManager toolBar, boolean multipleSelection) {
        super(parent, 0);
        this.createControls(multipleSelection, tableStyle, toolBar);
    }

    private void createControls(boolean multipleSelections, int tableStyle, IToolBarManager toolBar) {
        this.multipleSelections = multipleSelections;
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 5;
        gridLayout.verticalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.fillTopComposite(this);
        this.fillToolBar(toolBar);
        this.table = tableStyle != 0 ? (multipleSelections ? new Table((Composite)this, 2 | tableStyle) : new Table((Composite)this, tableStyle)) : (multipleSelections ? new Table((Composite)this, 2) : new Table((Composite)this, 0));
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    protected void fillToolBar(IToolBarManager tb) {
        if (tb.find("ADDITIONS") == null) {
            Separator filterGroup = new Separator("ADDITIONS");
            tb.add((IContributionItem)filterGroup);
        }
        CMObjectFilterControl filterControl = new CMObjectFilterControl();
        tb.appendToGroup("ADDITIONS", (IContributionItem)filterControl);
        tb.update(true);
        this.searchText = filterControl.getSearchText();
    }

    protected void fillTopComposite(Composite aComposite) {
        this.createTotalsLabel(aComposite);
    }

    protected void createTotalsLabel(Composite aComposite) {
        this.totalsLabel = new Label(aComposite, 64);
        GridData data = new GridData(4, 128, true, false);
        data.widthHint = 100;
        this.totalsLabel.setLayoutData((Object)data);
        this.totalsLabel.setText("");
    }

    protected void createSearchText(Composite aComposite) {
        this.searchText = new Text(aComposite, 2176);
        FormData data = new FormData();
        data.width = 70;
        data.top = new FormAttachment((Control)aComposite, 3, 128);
        this.searchText.setLayoutData((Object)data);
        this.searchText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                AccessibleEvent i = e;
                i.toString();
                e.result = Messages.getString("FilteredTableComposite.label.search");
            }
        });
        this.searchText.setToolTipText(Messages.getString("FilteredTableComposite.tooltip"));
        this.searchText.addVerifyListener((VerifyListener)EnsureUppercaseListener.getSingleton());
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FilteredTableComposite.this.listeners == null) {
                    return;
                }
                if (FilteredTableComposite.this.searchTimerTask != null) {
                    FilteredTableComposite.this.searchTimerTask.cancel();
                }
                FilteredTableComposite.this.searchTimerTask = new TimerTask(){

                    @Override
                    public void run() {
                        FilteredTableComposite.this.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                for (Listener listener : FilteredTableComposite.this.listeners) {
                                    listener.searchRequested(FilteredTableComposite.this.getSearchString());
                                }
                            }
                        });
                    }
                };
                timer.schedule(FilteredTableComposite.this.searchTimerTask, 1000L);
            }
        });
    }

    public void addListener(Listener aListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Listener>(1);
        }
        this.listeners.add(aListener);
    }

    public Table getTable() {
        return this.table;
    }

    public String getSearchString() {
        if (!this.searchText.isDisposed()) {
            return UIActivator.hasContent(this.searchText) ? Utilities.asTrailingWild(this.searchText.getText()) : null;
        }
        return "";
    }

    public void setSite(IWorkbenchPartSite site) {
        this.selectionProvider = new TableSelectionProvider(this.getTable());
        this.selectionProvider.allowMultipleSelections(this.multipleSelections);
        site.setSelectionProvider((ISelectionProvider)this.selectionProvider);
        MenuManager menuMgr = new MenuManager();
        Menu popupMenu = menuMgr.createContextMenu((Control)this.getTable());
        this.getTable().setMenu(popupMenu);
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.selectionProvider);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public void setTotalsCount(int size, String objectType) {
        String totals = MessageFormat.format(Messages.getString("FilteredTableComposite.label.description"), ConfigurationManager.getCurrent().getICMSMConnection().getConfiguration().getName(), objectType, this.table.getItemCount());
        this.totalsLabel.setText(totals);
        this.layout();
        this.totalsLabel.setEnabled(true);
    }

    public void reset() {
        this.getTable().removeAll();
        this.totalsLabel.setText("");
        this.totalsLabel.setEnabled(false);
    }

    public void beginFetch() {
        TableItem dummyTableItem = new TableItem(this.table, 0);
        this.table.setData("DUMMY_TABLE_ITEM", (Object)dummyTableItem);
        UIActivator.decorateAsBusy(dummyTableItem);
    }

    private class CMObjectFilterControl
    extends ControlContribution {
        private Text filterText;

        protected CMObjectFilterControl() {
            super("com.ibm.cics.cm.ui.views.FilteredTableComposite.CMObjectFilterControl");
        }

        protected Control createControl(Composite parent) {
            Composite thisComp = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            thisComp.setLayout((Layout)layout);
            Label filterLabel = new Label(thisComp, 0);
            filterLabel.setText(Messages.getString("FilteredTableComposite.label.filter.name"));
            this.filterText = new Text(thisComp, 132);
            TextInput.setAccessibleLabel((Text)this.filterText, (Label)filterLabel);
            GridData data = new GridData(128, 128, true, true);
            this.filterText.setLayoutData((Object)data);
            this.filterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    AccessibleEvent i = e;
                    i.toString();
                    e.result = Messages.getString("FilteredTableComposite.tooltip");
                }
            });
            this.filterText.addVerifyListener((VerifyListener)EnsureUppercaseListener.getSingleton());
            this.filterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (FilteredTableComposite.this.listeners == null) {
                        return;
                    }
                    if (FilteredTableComposite.this.searchTimerTask != null) {
                        FilteredTableComposite.this.searchTimerTask.cancel();
                    }
                    FilteredTableComposite.this.searchTimerTask = new TimerTask(){

                        @Override
                        public void run() {
                            FilteredTableComposite.this.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    for (Listener listener : FilteredTableComposite.this.listeners) {
                                        listener.searchRequested(CMObjectFilterControl.this.filterText.getText());
                                    }
                                }
                            });
                        }
                    };
                    timer.schedule(FilteredTableComposite.this.searchTimerTask, 1000L);
                }
            });
            return thisComp;
        }

        protected Text getSearchText() {
            return this.filterText;
        }
    }

    public static interface Listener {
        public void searchRequested(String var1);
    }
}

