/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.views;

import com.ibm.cics.cm.cpsm.comm.CMSMConnection;
import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.ZfsConfiguration;
import com.ibm.cics.cm.model.runtime.CMConnection;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.CMUIUtilities;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.eclipse.common.Activator;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public abstract class CMViewPart
extends ViewPart
implements Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2008, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IPartListener2 partListener;
    protected Object existingInput;
    private Composite stackComposite;
    private StackLayout stackLayout;
    private Control control;
    private Label cmOnlyLabel;
    private IAction refreshAction;
    protected IAction linkToSelectionAction;
    private boolean isLinkedToSelection = true;
    private ISelectionListener selectionListener;
    protected boolean visible;
    private Composite parent;
    private ConnectionServiceListener connectionListener;
    public static final String TOOLBAR_ADDITIONS_ID = "ADDITIONS";
    private static final Logger logger = Logger.getLogger(CMViewPart.class.getPackage().getName());
    private static final Debug debug = new Debug(CMViewPart.class);

    protected abstract void setInput(Object var1);

    protected abstract Control createControl(Composite var1);

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)CMViewPart.class.getName(), (String)"createPartControl", (Object)((Object)this), (Object)parent);
        this.parent = parent;
        this.stackComposite = new Composite(parent, 0);
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        this.stackLayout.topControl = this.control = this.createControl(this.stackComposite);
        this.cmOnlyLabel = new Label(this.stackComposite, 64);
        this.cmOnlyLabel.setText(CMSMConnection.ONLY_CM);
        this.makeActions(this.getViewSite().getWorkbenchWindow());
        this.fillActionBar(this.getViewSite().getActionBars());
        this.createPopupMenu();
        this.addPartListener();
        this.addSelectionListener();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpContextID());
        Debug.exit((Logger)logger, (String)CMViewPart.class.getName(), (String)"createPartControl");
    }

    protected void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Object element;
                Iterator iterator;
                ISelection selection = CMViewPart.this.getSite().getPage().getSelection("com.ibm.cics.cm.view.configurations");
                boolean isCICSConfiguration = true;
                if (selection != null && selection instanceof IStructuredSelection && (iterator = ((IStructuredSelection)selection).toList().iterator()).hasNext() && (element = iterator.next()) instanceof ZfsConfiguration) {
                    isCICSConfiguration = false;
                }
                CMViewPart.this.fillContextMenu(manager, isCICSConfiguration);
            }
        });
        Menu popupMenu = menuMgr.createContextMenu(this.getPrimaryControl());
        this.getPrimaryControl().setMenu(popupMenu);
        this.getSite().registerContextMenu(menuMgr, this.getSelectionProvider());
    }

    protected void fillContextMenu(IMenuManager manager, boolean isCICSConfiguration) {
        manager.add((IContributionItem)new Separator("new"));
        manager.add((IContributionItem)new Separator("open"));
        manager.add((IContributionItem)new Separator("actions"));
        manager.add((IContributionItem)new Separator("commonActions"));
        manager.add((IContributionItem)new Separator("clipboard"));
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected abstract Control getPrimaryControl();

    protected abstract ISelectionProvider getSelectionProvider();

    protected abstract String getHelpContextID();

    protected abstract void refresh(boolean var1);

    protected void schedule(Job aJob) {
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(aJob, 0L, true);
    }

    protected void fillActionBar(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        this.fillToolBar(toolBar);
    }

    protected void fillToolBar(IToolBarManager toolBar) {
        if (toolBar.find(TOOLBAR_ADDITIONS_ID) != null) {
            if (this.linkToSelectionAction != null) {
                toolBar.insertBefore(TOOLBAR_ADDITIONS_ID, this.linkToSelectionAction);
            }
            toolBar.insertBefore(TOOLBAR_ADDITIONS_ID, this.refreshAction);
        } else {
            if (this.linkToSelectionAction != null) {
                toolBar.add(this.linkToSelectionAction);
            }
            toolBar.add(this.refreshAction);
        }
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.refreshAction = new Action(){

            public void run() {
                CMViewPart.this.refresh(true);
            }
        };
        this.refreshAction.setToolTipText(Messages.getString("CMViewPart.1"));
        this.refreshAction.setImageDescriptor(Activator.IMGD_REFRESH);
        if (this.canLinkToSelection()) {
            this.linkToSelectionAction = new Action(Messages.getString("CMViewPart.2"), 2){

                public void run() {
                    CMViewPart.this.isLinkedToSelection = CMViewPart.this.linkToSelectionAction.isChecked();
                }

                public ImageDescriptor getImageDescriptor() {
                    return Activator.IMGD_LINK_TO_SELECTION;
                }
            };
            this.linkToSelectionAction.setChecked(true);
        }
    }

    protected abstract boolean canLinkToSelection();

    public void connected() {
        Debug.enter((Logger)logger, (String)CMViewPart.class.getName(), (String)"connected", (Object)((Object)this));
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CMViewPart.this.setInput(null);
                CMViewPart.this.existingInput = null;
                CMViewPart.this.addSelectionListener();
                ((CMViewPart)CMViewPart.this).stackLayout.topControl = CMViewPart.this.control;
                CMViewPart.this.stackComposite.layout();
                CMViewPart.this.connectedToCM();
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(runnable);
        } else {
            runnable.run();
        }
        Debug.exit((Logger)logger, (String)CMViewPart.class.getName(), (String)"connected", (Object)((Object)this));
    }

    protected void removePartListener() {
        Debug.enter((Logger)logger, (String)CMViewPart.class.getName(), (String)"removePartListener", (Object)((Object)this));
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null) {
            activeWindow.getPartService().removePartListener(this.partListener);
        }
        Debug.exit((Logger)logger, (String)CMViewPart.class.getName(), (String)"removePartListener", (Object)((Object)this));
    }

    protected void removeSelectionListener() {
        Debug.enter((Logger)logger, (String)CMViewPart.class.getName(), (String)"removeSelectionListener", (Object)((Object)this));
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (this.selectionListener != null && activeWindow != null) {
            activeWindow.getSelectionService().removeSelectionListener(this.selectionListener);
            this.selectionListener = null;
        }
        Debug.exit((Logger)logger, (String)CMViewPart.class.getName(), (String)"removeSelectionListener", (Object)((Object)this));
    }

    public void disconnected() {
        Debug.enter((Logger)logger, (String)CMViewPart.class.getName(), (String)"disconnected", (Object)((Object)this));
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CMViewPart.this.removeSelectionListener();
                CMViewPart.this.setInput(null);
                CMViewPart.this.existingInput = null;
                ((CMViewPart)CMViewPart.this).stackLayout.topControl = CMViewPart.this.cmOnlyLabel;
                CMViewPart.this.stackComposite.layout();
                CMViewPart.this.setContentDescription("");
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(runnable);
        } else {
            runnable.run();
        }
        Debug.exit((Logger)logger, (String)CMViewPart.class.getName(), (String)"disconnected", (Object)((Object)this));
    }

    protected void addPartListener() {
        Debug.enter((Logger)logger, (String)CMViewPart.class.getName(), (String)"addPartListener", (Object)((Object)this));
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.partListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference part) {
                IWorkbenchPart workbenchPart = part.getPart(false);
            }

            public void partBroughtToTop(IWorkbenchPartReference part) {
                IWorkbenchPart workbenchPart = part.getPart(false);
            }

            public void partClosed(IWorkbenchPartReference part) {
                IWorkbenchPart workbenchPart = part.getPart(false);
                if (workbenchPart == CMViewPart.this) {
                    CMViewPart.this.closed();
                }
            }

            public void partDeactivated(IWorkbenchPartReference part) {
                if (part == CMViewPart.this) {
                    part.toString();
                }
            }

            public void partHidden(IWorkbenchPartReference partRef) {
                IWorkbenchPart workbenchPart = partRef.getPart(false);
                if (workbenchPart == CMViewPart.this) {
                    CMViewPart.this.setVisible(false);
                }
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference part) {
                IWorkbenchPart workbenchPart = part.getPart(false);
                if (workbenchPart == CMViewPart.this) {
                    CMViewPart.this.opened();
                }
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                IWorkbenchPart workbenchPart = partRef.getPart(false);
                if (workbenchPart == CMViewPart.this) {
                    CMViewPart.this.setVisible(true);
                }
            }
        };
        workbenchWindow.getPartService().addPartListener(this.partListener);
        Debug.exit((Logger)logger, (String)CMViewPart.class.getName(), (String)"addPartListener", (Object)((Object)this));
    }

    protected void addSelectionListener() {
        Debug.enter((Logger)logger, (String)CMViewPart.class.getName(), (String)"addSelectionListener", (Object)((Object)this));
        if (this.selectionListener == null) {
            this.selectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    Object inputObject;
                    if (CMViewPart.this.isLinkedToSelection && selection instanceof StructuredSelection && (inputObject = ((StructuredSelection)selection).getFirstElement()) != CMViewPart.this.existingInput) {
                        CMViewPart.this.setInput(inputObject);
                    }
                }
            };
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            workbenchWindow.getSelectionService().addSelectionListener(this.selectionListener);
        }
        Debug.exit((Logger)logger, (String)CMViewPart.class.getName(), (String)"addSelectionListener", (Object)((Object)this));
    }

    protected void setVisible(boolean aBool) {
        this.visible = aBool;
        if (aBool) {
            this.addSelectionListener();
        } else {
            this.removeSelectionListener();
        }
    }

    protected void opened() {
        this.addConnectionListener();
        this.initialConnectionCheck();
    }

    private void initialConnectionCheck() {
        CMConnection currentConn = ConfigurationManager.getCurrent().getConnection();
        if (currentConn != null && currentConn.isConnected()) {
            this.connected();
        } else {
            this.disconnected();
        }
    }

    private ConnectionServiceListener getConnectionListener() {
        if (this.connectionListener == null) {
            this.connectionListener = new ConnectionServiceListener(){

                public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                    if (CMUIUtilities.isCMConnection(event)) {
                        if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                            CMViewPart.this.connected();
                        } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                            CMViewPart.this.disconnected();
                        }
                    }
                }
            };
        }
        return this.connectionListener;
    }

    private void addConnectionListener() {
        Debug.enter((Logger)logger, (String)CMViewPart.class.getName(), (String)"addConnectionListener", (Object)((Object)this));
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.getConnectionListener());
        Debug.exit((Logger)logger, (String)CMViewPart.class.getName(), (String)"addConnectionListener", (Object)((Object)this));
    }

    protected void closed() {
        Debug.enter((Logger)logger, (String)CMViewPart.class.getName(), (String)"closed", (Object)((Object)this));
        this.removeConnectionListener();
        this.removePartListener();
        this.removeSelectionListener();
        this.disconnected();
        Debug.exit((Logger)logger, (String)CMViewPart.class.getName(), (String)"closed", (Object)((Object)this));
    }

    private void removeConnectionListener() {
        Debug.enter((Logger)logger, (String)CMViewPart.class.getName(), (String)"removeConnectionListener", (Object)((Object)this));
        this.getConnectionListener().makeStale();
        Debug.exit((Logger)logger, (String)CMViewPart.class.getName(), (String)"removeConnectionListener", (Object)((Object)this));
    }

    protected void connectedToCM() {
        Debug.enter((Logger)logger, (String)CMViewPart.class.getName(), (String)"connectedToCM", (Object)((Object)this));
        this.refresh(true);
        Debug.exit((Logger)logger, (String)CMViewPart.class.getName(), (String)"connectedToCM", (Object)((Object)this));
    }

    public void setFocus() {
        this.parent.setFocus();
    }

    abstract class FillTableFromFilteredCollectionJob
    extends JobWithCancelingSupport {
        boolean isCancelled;
        protected Table table;

        protected FillTableFromFilteredCollectionJob(String name, Table aTable) {
            super(name);
            this.table = aTable;
        }

        protected void cancelingSub() {
            this.isCancelled = true;
        }

        protected IStatus runSub(IProgressMonitor monitor) {
            try {
                this.clearErrorMessage();
                final IFilteredCollection cmObjects = this.getCMObjects();
                if (!this.isCancelled && !this.table.isDisposed()) {
                    this.table.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!FillTableFromFilteredCollectionJob.this.table.isDisposed()) {
                                FillTableFromFilteredCollectionJob.this.table.setRedraw(false);
                                try {
                                    TableItem dummyTableItem = (TableItem)FillTableFromFilteredCollectionJob.this.table.getData("DUMMY_TABLE_ITEM");
                                    if (dummyTableItem != null) {
                                        dummyTableItem.dispose();
                                        FillTableFromFilteredCollectionJob.this.table.setData("DUMMY_TABLE_ITEM", null);
                                    }
                                    FillTableFromFilteredCollectionJob.this.fillTableFrom(cmObjects);
                                }
                                finally {
                                    FillTableFromFilteredCollectionJob.this.table.setRedraw(true);
                                }
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
            catch (RuntimeException e) {
                this.setErrorMessage(this.getName());
                debug.error(this.getName(), (Throwable)e);
                return Status.CANCEL_STATUS;
            }
        }

        private void clearErrorMessage() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CMViewPart.this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(null);
                }
            });
        }

        protected void setErrorMessage(final String anErrorMessage) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!FillTableFromFilteredCollectionJob.this.table.isDisposed()) {
                        FillTableFromFilteredCollectionJob.this.table.setRedraw(false);
                        try {
                            TableItem dummyTableItem = (TableItem)FillTableFromFilteredCollectionJob.this.table.getData("DUMMY_TABLE_ITEM");
                            if (dummyTableItem != null) {
                                dummyTableItem.dispose();
                                FillTableFromFilteredCollectionJob.this.table.setData("DUMMY_TABLE_ITEM", null);
                            }
                        }
                        finally {
                            FillTableFromFilteredCollectionJob.this.table.setRedraw(true);
                        }
                    }
                    CMViewPart.this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(MessageFormat.format(Messages.getString("CMViewPart.0"), anErrorMessage));
                }
            });
        }

        protected abstract IFilteredCollection getCMObjects();

        protected abstract void fillTableFrom(IFilteredCollection var1);
    }
}

