/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.search;

import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.FilterAttribute;
import com.ibm.cics.cm.model.HistoryFilterAttribute;
import com.ibm.cics.cm.model.IHistoryProvider;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.history.HistoryFilterAttributeFactory;
import com.ibm.cics.cm.ui.search.Messages;
import com.ibm.cics.cm.ui.search.SearchTabGeneric;
import com.ibm.cics.cm.ui.views.HistoryView;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SearchTabHistory
extends SearchTabGeneric {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private FilterAttribute[] filterAttributes = HistoryFilterAttributeFactory.getSearchFilters();
    private List<HistoryFilterAttribute> selectedFilterAttributes = new ArrayList<HistoryFilterAttribute>();

    @Override
    protected void createUI() {
        this.tabComposite.setText(Messages.getString("CMSearchDialog.historyTab"));
        this.contentComposite = new Composite((Composite)this.parent, 0);
        this.tabComposite.setControl((Control)this.contentComposite);
        HashMap errorMap = new HashMap();
        this.tabComposite.setData("ERRORS", errorMap);
        GridLayout layout = new GridLayout(3, false);
        this.contentComposite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        this.contentComposite.setLayoutData((Object)data);
        this.searchGroup = new Group(this.contentComposite, 0);
        layout = new GridLayout(2, false);
        this.searchGroup.setLayout((Layout)layout);
        this.searchGroup.setText(Messages.getString("CMSearchDialog.searchCompositeText"));
        data = new GridData(4, 4, true, true);
        this.searchGroup.setLayoutData((Object)data);
        boolean displayFilters = true;
        this.addResourceFilters(this.contentComposite, displayFilters);
        this.addResourceDefinitionSearch((Composite)this.searchGroup);
        this.addConfigurationSearch((Composite)this.searchGroup, 1);
        this.addGroupSearch((Composite)this.searchGroup, true, 1);
        this.setFilterAttributes();
    }

    @Override
    protected void setActiveTab() {
        super.setActiveTab();
        this.dialog.setTitle(Messages.getString("CMSearchDialog.historyTitle"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.parent.getShell(), "com.ibm.cics.cm.ui.search_history");
    }

    @Override
    protected void addGroupToolTipText(Text aGroupsText) {
        aGroupsText.setToolTipText(Messages.getString("CMSearchDialog.groupToolTip"));
    }

    @Override
    protected void addListeners() {
        this.addResourceTextListener();
        this.addResourceDropdownListeners();
        if (this.addFilterListener == null) {
            this.addFilterDropdownSelectionListener();
        }
    }

    @Override
    protected void populateFromSelection() {
        this.populateConfigurations();
        this.populateGroups();
        this.populateResourceType();
    }

    @Override
    protected void okPressed() {
        HistoryView historyView;
        IHistoryProvider historyProvider = null;
        Configuration config = null;
        if (this.selectedConfigurations.keySet().size() == 1) {
            String name = (String)this.selectedConfigurations.keySet().toArray()[0];
            config = (Configuration)availableConfigurations.get(name);
        }
        if (config != null) {
            String groupTextValue;
            if (config instanceof IHistoryProvider) {
                historyProvider = (IHistoryProvider)config;
            } else {
                Object adapter = Platform.getAdapterManager().getAdapter(config, IHistoryProvider.class);
                historyProvider = (IHistoryProvider)adapter;
            }
            for (HistoryFilterAttribute historyFilterAttribute : this.selectedFilterAttributes) {
                Date date;
                Calendar calendar;
                if ("FROMDATE".equals(historyFilterAttribute.getAPIName())) {
                    calendar = (Calendar)historyFilterAttribute.getFilterExpression().getValue();
                    date = calendar.getTime();
                    historyProvider.setFromDate(date);
                    this.selectedFilterAttributes.remove(historyFilterAttribute);
                }
                if (!"TODATE".equals(historyFilterAttribute.getAPIName())) continue;
                calendar = (Calendar)historyFilterAttribute.getFilterExpression().getValue();
                date = calendar.getTime();
                historyProvider.setToDate(date);
                this.selectedFilterAttributes.remove(historyFilterAttribute);
            }
            String resourceNameText = this.resourceTextBox.getText();
            if (!this.isWild(resourceNameText)) {
                HistoryFilterAttribute nameFilter = HistoryFilterAttributeFactory.getNameFilter(resourceNameText);
                this.selectedFilterAttributes.add(nameFilter);
            }
            if (!this.isWild(groupTextValue = this.groupsText.getText())) {
                HistoryFilterAttribute groupFilter = HistoryFilterAttributeFactory.getGroupFilter(groupTextValue);
                this.selectedFilterAttributes.add(groupFilter);
            }
            if (!this.isWild(this.getTypeName())) {
                HistoryFilterAttribute typeFilter = HistoryFilterAttributeFactory.getTypeFilter(this.getTypeName());
                this.selectedFilterAttributes.add(typeFilter);
            }
        }
        if ((historyView = UIActivator.getHistoryView()) != null && historyProvider != null) {
            historyView.setInput(historyProvider, this.selectedFilterAttributes);
        }
    }

    private boolean isWild(String text) {
        return text != null && "*".equals(text);
    }

    @Override
    protected void updateFilterAttributes(boolean enabled) {
        if (this.addFilterToolItem != null) {
            this.addFilterToolItem.setEnabled(true);
        }
    }

    @Override
    protected FilterAttribute[] getFilterAttributes() {
        return this.filterAttributes;
    }

    @Override
    protected void addSelectedFilterAttribute(FilterAttribute attribute) {
        if (attribute instanceof HistoryFilterAttribute) {
            this.selectedFilterAttributes.add((HistoryFilterAttribute)attribute);
        }
    }

    @Override
    protected void addGroupSearchText(Group groupSearchComp) {
        groupSearchComp.setText(Messages.getString("CMSearchDialog.groupCompositeText"));
    }

    @Override
    protected void removeSelectedFilterAttribute(FilterAttribute attribute) {
        if (attribute instanceof HistoryFilterAttribute) {
            this.selectedFilterAttributes.remove((HistoryFilterAttribute)attribute);
        }
    }
}

