/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.search;

import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.FilterAttribute;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.search.CMSearchForGroupsQuery;
import com.ibm.cics.cm.ui.search.Messages;
import com.ibm.cics.cm.ui.search.SearchTabGeneric;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class SearchTabGroups
extends SearchTabGeneric {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    protected void createUI() {
        this.tabComposite.setText(Messages.getString("CMSearchDialog.groupsTab"));
        this.contentComposite = new Composite((Composite)this.parent, 0);
        this.tabComposite.setControl((Control)this.contentComposite);
        HashMap errorMap = new HashMap();
        this.tabComposite.setData("ERRORS", errorMap);
        GridLayout layout = new GridLayout(1, false);
        this.contentComposite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        this.contentComposite.setLayoutData((Object)data);
        this.searchGroup = new Group(this.contentComposite, 0);
        layout = new GridLayout(2, false);
        this.searchGroup.setLayout((Layout)layout);
        this.searchGroup.setText(Messages.getString("CMSearchDialog.searchCompositeText"));
        data = new GridData(4, 4, true, true);
        this.searchGroup.setLayoutData((Object)data);
        this.addGroupWildcardSearch((Composite)this.searchGroup);
        this.addConfigurationSearch((Composite)this.searchGroup, -1);
    }

    @Override
    protected void setActiveTab() {
        super.setActiveTab();
        this.dialog.setTitle(Messages.getString("CMSearchDialog.groupsTitle"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.parent.getShell(), "com.ibm.cics.cm.ui.search_groups");
    }

    @Override
    protected void addListeners() {
        this.addGroupsTextListener();
    }

    @Override
    protected void populateFromSelection() {
        this.populateConfigurations();
    }

    @Override
    protected void okPressed() {
        String name = this.queryNameText.getText().trim();
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (String configurationName : this.selectedConfigurations.keySet()) {
            if (!first) {
                buffer.append(',');
                buffer.append(' ');
            } else {
                first = false;
            }
            buffer.append(configurationName);
        }
        String description = MessageFormat.format(Messages.getString("CMSearchDialog.searchGroupsDesc"), name, buffer.toString());
        CMSearchForGroupsQuery query = new CMSearchForGroupsQuery(description, name, new ArrayList<Configuration>(this.selectedConfigurations.values()));
        UIActivator.executeSearch(query);
        this.selectedConfigurations.clear();
    }

    @Override
    protected FilterAttribute[] getFilterAttributes() {
        return null;
    }

    @Override
    protected void updateFilterAttributes(boolean enabled) {
    }

    @Override
    protected void addSelectedFilterAttribute(FilterAttribute attribute) {
    }

    @Override
    protected void removeSelectedFilterAttribute(FilterAttribute attribute) {
    }
}

