/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.search;

import com.ibm.cics.cm.ui.ImageFactory;
import com.ibm.cics.cm.ui.search.CMSearchQuery;
import com.ibm.cics.cm.ui.search.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class SearchHistoryManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Action searchPreviousAction;
    private Action searchNextAction;
    public List searchHistory = new ArrayList();
    private CMSearchQuery currentQuery;
    private Action searchHistoryAction;

    public abstract void executeQuery(CMSearchQuery var1);

    public IMenuCreator getHistoryMenuCreator() {
        SelectionAdapter historyItemListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem menuItem = (MenuItem)e.widget;
                if (menuItem.getSelection()) {
                    CMSearchQuery query = (CMSearchQuery)menuItem.getData();
                    SearchHistoryManager.this.executeQuery(query);
                    ((MenuItem)e.widget).setSelection(true);
                }
            }
        };
        return new IMenuCreator((SelectionListener)historyItemListener){
            private final /* synthetic */ SelectionListener val$historyItemListener;
            {
                this.val$historyItemListener = selectionListener;
            }

            public void dispose() {
            }

            public Menu getMenu(Control parent) {
                Menu result = new Menu(parent);
                for (CMSearchQuery query : SearchHistoryManager.this.searchHistory) {
                    MenuItem menuItem = new MenuItem(result, 16);
                    menuItem.setText(query.getDescription());
                    menuItem.setData((Object)query);
                    if (query == SearchHistoryManager.this.currentQuery) {
                        menuItem.setSelection(true);
                    }
                    menuItem.addSelectionListener(this.val$historyItemListener);
                }
                if (SearchHistoryManager.this.searchHistory.size() > 0) {
                    new MenuItem(result, 2);
                }
                MenuItem clearHistoryItem = new MenuItem(result, 8);
                clearHistoryItem.setText(Messages.getString("SearchHistoryManager.ClearHistory"));
                clearHistoryItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ArrayList<CMSearchQuery> newHistory = new ArrayList<CMSearchQuery>();
                        newHistory.add(SearchHistoryManager.this.currentQuery);
                        (this).SearchHistoryManager.this.searchHistory = newHistory;
                        SearchHistoryManager.this.searchHistoryAction.setEnabled(false);
                    }
                });
                return result;
            }

            public Menu getMenu(Menu parent) {
                return null;
            }
        };
    }

    public void searchStarted(CMSearchQuery aQuery) {
        int indexOfQueryInHistory = this.searchHistory.indexOf(aQuery);
        if (indexOfQueryInHistory == -1) {
            this.searchHistory.add(aQuery);
            if (this.searchHistory.size() > 20) {
                this.searchHistory.remove(0);
            }
        }
        this.searchHistoryAction.setEnabled(true);
        this.currentQuery = aQuery;
    }

    public void createActions(IToolBarManager toolBarManager) {
        this.searchHistoryAction = new Action(Messages.getString("SearchHistoryManager.ShowPreviousSearches"), ImageDescriptor.createFromImage((Image)ImageFactory.getSearchHistoryImage())){

            public ImageDescriptor getDisabledImageDescriptor() {
                return ImageDescriptor.createFromImage((Image)ImageFactory.getSearchHistoryImage_DISABLED());
            }

            public int getStyle() {
                return 4;
            }
        };
        this.searchHistoryAction.setMenuCreator(this.getHistoryMenuCreator());
        toolBarManager.add((IAction)this.searchHistoryAction);
        this.searchHistoryAction.setEnabled(false);
    }
}

