/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.search;

import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ResourceList;
import com.ibm.cics.cm.ui.search.CMSearchQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CMSearchForListsQuery
extends CMSearchQuery {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String searchString;
    protected List<Pattern> searchPatterns;

    public CMSearchForListsQuery(String description, String searchString, List<Configuration> configurationList) {
        super(description);
        this.searchString = searchString;
        this.configurations = configurationList;
        this.parseSearchTerms();
    }

    @Override
    protected synchronized List<ResourceList> getDefinitions(Configuration configuration) {
        List allLists = configuration.getResourceLists().getResults();
        ArrayList<ResourceList> matchedLists = new ArrayList<ResourceList>();
        block0: for (ResourceList list : allLists) {
            for (Pattern p : this.searchPatterns) {
                Matcher m = p.matcher(list.getName());
                if (!m.matches()) continue;
                matchedLists.add(list);
                continue block0;
            }
        }
        return matchedLists;
    }

    @Override
    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.getDescription());
        return buffer.toString();
    }

    @Override
    public boolean hasMultipleTypes() {
        return false;
    }

    @Override
    public boolean hasResources() {
        return false;
    }

    @Override
    public boolean hasLists() {
        return true;
    }

    @Override
    public boolean showGroups() {
        return false;
    }

    private void parseSearchTerms() {
        if (this.searchPatterns != null) {
            this.searchPatterns.clear();
        } else {
            this.searchPatterns = new ArrayList<Pattern>();
        }
        this.searchString = this.searchString.replaceAll(" ", "");
        String[] temp = this.searchString.split(",");
        int i = 0;
        while (i < temp.length) {
            temp[i] = temp[i].trim();
            temp[i] = temp[i].replaceAll("\\+", ".");
            temp[i] = temp[i].replaceAll("\\*", ".*");
            Pattern p = Pattern.compile(temp[i]);
            this.searchPatterns.add(p);
            ++i;
        }
    }

    @Override
    public boolean allowGroups() {
        return false;
    }
}

