/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.search;

import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.runtime.RestrictionCriteriaList;
import com.ibm.cics.cm.model.runtime.RestrictionElementList;
import com.ibm.cics.cm.ui.search.CMSearchQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CMDialogSearchQuery
extends CMSearchQuery {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String resourceType;
    protected String resourceName;
    protected Map<Configuration, List<ICMDefinition>> configurationsToResults = new HashMap<Configuration, List<ICMDefinition>>();
    protected RestrictionCriteriaList restrictionCriteriaList;

    public CMDialogSearchQuery(String description, String aResourceName, String aResourceType, RestrictionCriteriaList restrictionCriteriaList, List<Configuration> aConfigurationList) {
        super(description);
        this.resourceName = aResourceName;
        this.resourceType = aResourceType;
        this.configurations = aConfigurationList;
        this.restrictionCriteriaList = restrictionCriteriaList;
    }

    public CMDialogSearchQuery(String description, String aResourceName, String aResourceType, RestrictionCriteriaList restrictionCriteriaList, Configuration aConfiguration) {
        super(description);
        this.resourceName = aResourceName;
        this.resourceType = aResourceType;
        this.configurations = new ArrayList();
        this.configurations.add(aConfiguration);
        this.restrictionCriteriaList = restrictionCriteriaList;
    }

    @Override
    protected synchronized List<ICMDefinition> getDefinitions(Configuration configuration) {
        List results = this.configurationsToResults.get(configuration);
        if (results == null) {
            IFilteredCollection definitions = configuration.getDefinitions();
            definitions.setObjectName(this.resourceName);
            definitions.setObjectType(this.resourceType);
            if (this.restrictionCriteriaList != null) {
                definitions.setRestrictionCriteriaList(this.copyRestrictionCriteriaList(this.restrictionCriteriaList));
            }
            results = definitions.getResults();
            this.configurationsToResults.put(configuration, results);
        }
        return results;
    }

    protected RestrictionCriteriaList copyRestrictionCriteriaList(RestrictionCriteriaList originalRestrictionCriteriaList) {
        RestrictionCriteriaList newRestrictionCriteriaList = new RestrictionCriteriaList();
        List clone = (List)((ArrayList)originalRestrictionCriteriaList.getRestrictionElementLists()).clone();
        for (RestrictionElementList restrictionElementList : clone) {
            newRestrictionCriteriaList.add(restrictionElementList);
        }
        return newRestrictionCriteriaList;
    }

    @Override
    public boolean hasMultipleTypes() {
        return "*".equals(this.resourceType);
    }
}

