/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.preferences;

import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.common.util.Debug;
import java.text.MessageFormat;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class RetrievalLimitPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(RetrievalLimitPreferencePage.class);
    private Spinner rowNumberSpinner;
    private Text result;

    public RetrievalLimitPreferencePage() {
        debug.enter("constructor");
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.ibm.cics.cm.model"));
        debug.exit("constructor");
    }

    protected Control createContents(Composite parent) {
        Composite outerParent = new Composite(parent, 0);
        outerParent.setLayoutData((Object)new GridData(4, 4, true, true));
        outerParent.setLayout((Layout)new GridLayout());
        Label l = new Label(outerParent, 64);
        l.setText(Messages.getString("RetrievalLimitPreferencePage.label.preamble"));
        GridData data9 = new GridData(4, 128, false, false);
        data9.widthHint = 200;
        l.setLayoutData((Object)data9);
        GridData data = new GridData(4, 128, false, false);
        data.horizontalSpan = 3;
        data.widthHint = 200;
        Group clientArea = new Group(outerParent, 0);
        clientArea.setText(Messages.getString("RetrievalLimitPreferencePage.Description"));
        clientArea.setLayout((Layout)new GridLayout(3, false));
        GridData clientAreaData = new GridData(4, 128, true, false);
        clientArea.setLayoutData((Object)clientAreaData);
        l = new Label((Composite)clientArea, 64);
        l.setText(Messages.getString("RetrievalLimitPreferencePage.label.toomuchdata"));
        l.setLayoutData((Object)data);
        l = new Label((Composite)clientArea, 0);
        l.setText(Messages.getString("RetrievalLimitPreferencePage.label.maximumnoresources"));
        l.setLayoutData((Object)new GridData(4, 128, false, false));
        this.rowNumberSpinner = new Spinner((Composite)clientArea, 2048);
        this.rowNumberSpinner.setMinimum(1);
        this.rowNumberSpinner.setMaximum(500000);
        this.rowNumberSpinner.setIncrement(50);
        this.rowNumberSpinner.setPageIncrement(100);
        this.rowNumberSpinner.setLayoutData((Object)new GridData(4, 128, true, false));
        this.rowNumberSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = RetrievalLimitPreferencePage.this.rowNumberSpinner.getText();
                RetrievalLimitPreferencePage.this.rowNumberSpinner.setToolTipText(MessageFormat.format(Messages.getString("RetrievalLimitPreferencePage.accessible.spinner"), text));
                try {
                    if (Integer.valueOf(text) > RetrievalLimitPreferencePage.this.rowNumberSpinner.getMaximum()) {
                        RetrievalLimitPreferencePage.this.rowNumberSpinner.setSelection(RetrievalLimitPreferencePage.this.rowNumberSpinner.getMaximum());
                    }
                }
                catch (NumberFormatException nfe) {
                    RetrievalLimitPreferencePage.this.rowNumberSpinner.setSelection(RetrievalLimitPreferencePage.this.rowNumberSpinner.getMinimum());
                }
            }
        });
        this.rowNumberSpinner.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = MessageFormat.format(Messages.getString("RetrievalLimitPreferencePage.accessible.spinner"), RetrievalLimitPreferencePage.this.rowNumberSpinner.getText());
            }

            public void getDescription(AccessibleEvent e) {
                e.result = MessageFormat.format(Messages.getString("RetrievalLimitPreferencePage.accessible.spinner"), RetrievalLimitPreferencePage.this.rowNumberSpinner.getText());
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.ibm.cics.cm.ui.preferences_limit");
        this.initializeControls();
        return outerParent;
    }

    private void initializeControls() {
        this.rowNumberSpinner.setSelection(this.getPreferencePageSize());
    }

    protected void performDefaults() {
        this.rowNumberSpinner.setSelection(this.getPreferenceStore().getDefaultInt("PAGE_SIZE"));
        this.result.getParent().layout();
        super.performDefaults();
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("PAGE_SIZE", this.rowNumberSpinner.getSelection());
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
        debug.enter("init");
        debug.exit("init");
    }

    public int getPreferencePageSize() {
        return this.getPreferenceStore().getInt("PAGE_SIZE");
    }
}

