/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.history;

import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.HistoryFilterAttribute;
import com.ibm.cics.cm.ui.history.HistoryFilter;
import com.ibm.cics.cm.ui.history.HistoryFilterAttributeFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistoryFilterFactory
implements Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Map<String, HistoryFilter> filterMap;

    public static List<HistoryFilter> getFiltersFromListOfAttributes(List<HistoryFilterAttribute> historyFilterAttributes) {
        ArrayList<HistoryFilter> outputList = new ArrayList<HistoryFilter>();
        for (HistoryFilterAttribute attribute : historyFilterAttributes) {
            HistoryFilter historyFilter = filterMap.get(attribute.getAPIName());
            historyFilter.setHistoryFilterAttribute(attribute);
            outputList.add(historyFilter);
        }
        return outputList;
    }

    public static Collection<HistoryFilter> getFilters() {
        if (filterMap == null) {
            filterMap = new HashMap<String, HistoryFilter>();
            Map<String, HistoryFilterAttribute> map = HistoryFilterAttributeFactory.getHistoryFilters();
            for (Map.Entry<String, HistoryFilterAttribute> entry : map.entrySet()) {
                HistoryFilter historyFilter = new HistoryFilter(entry.getValue());
                filterMap.put(entry.getKey(), historyFilter);
            }
        }
        Collection<HistoryFilter> values = filterMap.values();
        ArrayList<HistoryFilter> arrayList = new ArrayList<HistoryFilter>();
        arrayList.addAll(values);
        Collections.sort(arrayList, new Comparator<HistoryFilter>(){

            @Override
            public int compare(HistoryFilter object1, HistoryFilter object2) {
                return object1.getDisplayName().compareTo(object2.getDisplayName());
            }
        });
        return arrayList;
    }
}

