/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.handlers;

import com.ibm.cics.cm.model.ZfsDefinition;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.editors.ZfsDefinitionEditorInput;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class ZfsDefinitionOpenHandler
extends AbstractHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            for (Object element : ((IStructuredSelection)selection).toList()) {
                if (!(element instanceof ZfsDefinition)) continue;
                ZfsDefinition definition = (ZfsDefinition)element;
                ZfsDefinition fullDefinition = ConfigurationManager.getCurrent().getZfsDefinition(definition.getName(), definition.getConfigurationName());
                definition.setAttributes(fullDefinition.getAttributes());
                definition.notifyListeners(true);
                ZfsDefinitionEditorInput input = new ZfsDefinitionEditorInput(definition);
                try {
                    HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().openEditor((IEditorInput)input, "com.ibm.cics.cm.ui.zfsdefinition.editor");
                }
                catch (PartInitException pie) {
                    throw new RuntimeException(pie);
                }
            }
        }
        return null;
    }
}

