/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.handlers;

import com.ibm.cics.cm.model.CMCopyException;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.MessageResponse;
import com.ibm.cics.cm.model.runtime.ObjectCriteriaList;
import com.ibm.cics.cm.model.runtime.ProcessParms;
import com.ibm.cics.cm.model.runtime.TargetLocationCriteria;
import com.ibm.cics.cm.ui.handlers.CMCopyReplaceDialog;
import com.ibm.cics.cm.ui.handlers.CopyPasteHelper;
import com.ibm.cics.cm.ui.handlers.Messages;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICSDGroupDefinition;
import com.ibm.cics.model.IResourceGroupDefinition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class PasteCICSDefinitionCMHandler
extends AbstractHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean replaceBool;
    private static final Logger logger = Logger.getLogger(PasteCICSDefinitionCMHandler.class.getPackage().getName());
    private static final Debug debug = new Debug(PasteCICSDefinitionCMHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<ICICSDefinition> cicsObjects;
        ResourceDefinitionGroup resourceGroup;
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"execute", (Object)event);
        Object pasteTarget = this.getPasteTarget(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        if (pasteTarget == null) {
            throw new ExecutionException("Could not get target group from selection");
        }
        if ((pasteTarget instanceof ICSDGroupDefinition || pasteTarget instanceof IResourceGroupDefinition) && (resourceGroup = (ResourceDefinitionGroup)Platform.getAdapterManager().getAdapter(pasteTarget, ResourceDefinitionGroup.class)) != null) {
            pasteTarget = resourceGroup;
        }
        if ((cicsObjects = this.getClipboardContents()) == null || cicsObjects.size() == 0) {
            throw new ExecutionException("Could not get definitions from clipboard");
        }
        if (!this.canPaste(pasteTarget, cicsObjects)) {
            throw new ExecutionException("Selected definitions were not valid for the target group");
        }
        this.doPaste(pasteTarget, cicsObjects);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"execute");
        return null;
    }

    private int showReplaceDialog(Configuration originConfig, ResourceDefinitionGroup targetGroup, List<ICMDefinition> defs) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"showReplaceDialog", (Object)originConfig, (Object)targetGroup, defs);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        CMCopyReplaceDialog dialog = new CMCopyReplaceDialog(shell, originConfig, targetGroup, defs);
        dialog.setBlockOnOpen(true);
        int dialogResponse = dialog.open();
        this.replaceBool = dialog.getReplaceBool();
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"showReplaceDialog", (Object)this.replaceBool);
        return dialogResponse;
    }

    protected void doPaste(Object pasteTarget, List<ICICSDefinition> definitions) {
        MessageResponse response;
        block10: {
            int dialogResponse;
            Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"doPaste", (Object)pasteTarget, definitions);
            Configuration originConfiguration = null;
            ArrayList<ICMDefinition> cmDefinitions = new ArrayList<ICMDefinition>();
            for (ICICSDefinition cicsDef : definitions) {
                ICMDefinition cmDefinition = (ICMDefinition)Platform.getAdapterManager().getAdapter((Object)cicsDef, ICMDefinition.class);
                if (cmDefinition != null) {
                    cmDefinitions.add(cmDefinition);
                    if (originConfiguration == null) {
                        originConfiguration = cmDefinition.getConfiguration();
                        continue;
                    }
                    if (originConfiguration == cmDefinition.getConfiguration()) continue;
                    CMCopyException cmce = new CMCopyException("CM cannot copy definitions from multiple source configurations");
                    Debug.error((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"doPaste", (Throwable)cmce);
                    continue;
                }
                String detailedMessage = MessageFormat.format(Messages.getString("PasteCICSDefinitionCMHandler.orphanErrorText"), cicsDef.getName(), cicsDef.getObjectType().getResourceTableName());
                CMCopyException cmce = new CMCopyException(detailedMessage);
                Debug.error((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"doPaste", (Throwable)cmce);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageBox mb = new MessageBox(shell, 40);
                mb.setText(Messages.getString("PasteCICSDefinitionCMHandler.orphanErrorTitle"));
                mb.setMessage(detailedMessage);
                mb.open();
                return;
            }
            ResourceDefinitionGroup targetGroup = null;
            if (pasteTarget instanceof ResourceDefinitionGroup) {
                targetGroup = (ResourceDefinitionGroup)pasteTarget;
            }
            if ((dialogResponse = this.showReplaceDialog(originConfiguration, targetGroup, cmDefinitions)) != 0) {
                return;
            }
            LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria((String)originConfiguration.getName());
            ObjectCriteriaList objectCriteriaList = ObjectCriteriaList.newObjectCriteriaList();
            for (ICMDefinition def : cmDefinitions) {
                String definitionName = def.getName();
                String definitionType = def.getType();
                String resourceGroupName = def.getResourceGroupName();
                objectCriteriaList.addListElement(resourceGroupName, definitionType, definitionName);
            }
            ProcessParms processParms = ProcessParms.getReplace((boolean)this.replaceBool);
            TargetLocationCriteria targetLocationCriteria = TargetLocationCriteria.newCriteriaForGroup((String)targetGroup.getConfiguration().getName(), (String)targetGroup.getName());
            response = null;
            try {
                response = ConfigurationManager.getCurrent().getConnection().copy(locationCriteria, objectCriteriaList, processParms, targetLocationCriteria);
            }
            catch (CMServerException ee) {
                if (ee.isWarningCopyReplaced()) {
                    System.out.println((Object)ee);
                    response = ee.getMessageResponse();
                }
                if (!ee.isWarningObjectAlreadyExists()) break block10;
                System.out.println((Object)ee);
                response = ee.getMessageResponse();
            }
        }
        if (response != null) {
            System.out.println(response.rawMessageBuffer);
        }
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"doPaste");
    }

    protected boolean canPaste(Object target, List<ICICSDefinition> definitions) {
        return target instanceof ResourceDefinitionGroup;
    }

    protected Object getPasteTarget(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (structuredSelection.size() != 1) {
            return null;
        }
        return structuredSelection.getFirstElement();
    }

    protected List<ICICSDefinition> getClipboardContents() {
        return CopyPasteHelper.getClipboardSelectionAsList(ICICSDefinition.class);
    }
}

