/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.handlers;

import com.ibm.cics.cm.ui.handlers.CopyPasteHelper;
import com.ibm.cics.cm.ui.handlers.PasteCICSDefinitionCMHandler;
import com.ibm.cics.model.ICICSDefinition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class CMPasteHandler
extends AbstractHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<Class<?>, AbstractHandler> delegates = new HashMap();
    private ISelection selection;
    private AbstractHandler activeHandler;

    public CMPasteHandler() {
        this.delegates.put(ICICSDefinition.class, new PasteCICSDefinitionCMHandler());
    }

    public boolean isEnabled() {
        this.setActiveHandler();
        if (this.activeHandler != null) {
            return this.activeHandler.isEnabled();
        }
        return false;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.setActiveHandler();
        if (this.activeHandler != null) {
            return this.activeHandler.execute(event);
        }
        return null;
    }

    private void setActiveHandler() {
        ISelection clipboardContentsSelection = CopyPasteHelper.getClipboardSelection();
        if (this.selection == clipboardContentsSelection) {
            return;
        }
        this.selection = clipboardContentsSelection;
        if (this.selection == null) {
            this.activeHandler = null;
            return;
        }
        List clipboardContents = ((IStructuredSelection)this.selection).toList();
        if (clipboardContents.size() == 0) {
            this.activeHandler = null;
            return;
        }
        block0: for (Map.Entry<Class<?>, AbstractHandler> entry : this.delegates.entrySet()) {
            for (Object object : clipboardContents) {
                Class<?> testClass = entry.getKey();
                if (!testClass.isAssignableFrom(object.getClass())) continue block0;
            }
            this.activeHandler = entry.getValue();
            return;
        }
        this.activeHandler = null;
    }
}

