/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.handlers;

import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.ui.handlers.Messages;
import com.ibm.cics.core.ui.UIPlugin;
import java.text.MessageFormat;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CMCopyReplaceDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Configuration originConfig;
    private ResourceDefinitionGroup targetGroup;
    private List<ICMDefinition> defs;
    boolean replace = false;
    Button replaceButton = null;
    Button dontReplaceButton = null;

    public CMCopyReplaceDialog(Shell parent, Configuration originConfig, ResourceDefinitionGroup targetGroup, List<ICMDefinition> defs) {
        super(parent);
        this.originConfig = originConfig;
        this.targetGroup = targetGroup;
        this.defs = defs;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        dialogArea.setLayoutData((Object)new GridData(4, 4, true, true));
        dialogArea.setFont(parent.getFont());
        Label copyDescription = new Label(dialogArea, 0);
        String originConfigName = this.originConfig.getName();
        String targetConfigName = this.targetGroup.getConfiguration().getName();
        String targetGroupName = this.targetGroup.getName();
        int definitionCount = this.defs.size();
        SortedSet<String> groupsSet = this.getGroupsSet(this.defs);
        String originGroups = this.getOriginGroupsString(groupsSet);
        String definitionMultiple = definitionCount > 1 ? Messages.getString("CMCopyReplaceDialog.definitionMultiple") : Messages.getString("CMCopyReplaceDialog.definitionSingle");
        String groupMultiple = groupsSet.size() > 1 ? Messages.getString("CMCopyReplaceDialog.groupMultiple") : Messages.getString("CMCopyReplaceDialog.groupSingle");
        copyDescription.setText(MessageFormat.format(Messages.getString("CMCopyReplaceDialog.copyDescriptionText"), definitionCount, definitionMultiple, groupMultiple, originGroups, originConfigName, targetGroupName, targetConfigName));
        Composite actionSection = new Composite(dialogArea, 0);
        GridLayout actionLayout = new GridLayout(2, false);
        actionSection.setLayout((Layout)actionLayout);
        actionSection.setLayoutData((Object)new GridData(4, 1024, true, true, 1, 1));
        Label actionLabel = new Label(actionSection, 0);
        actionLabel.setText(Messages.getString("CMCopyReplaceDialog.actionText"));
        actionLabel.setLayoutData((Object)new GridData(16384, 128, false, true, 1, 1));
        Composite radioButtons = new Composite(actionSection, 0);
        GridLayout radioLayout = new GridLayout(2, false);
        layout.marginWidth = 5;
        radioLayout.marginHeight = 5;
        layout.horizontalSpacing = 5;
        radioLayout.verticalSpacing = 5;
        radioButtons.setLayout((Layout)layout);
        radioButtons.setLayoutData((Object)new GridData(131072, 1024, false, false, 1, 1));
        this.replaceButton = new Button(radioButtons, 16);
        this.replaceButton.setText(Messages.getString("CMCopyReplaceDialog.replace"));
        this.replaceButton.setData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.dontReplaceButton = new Button(radioButtons, 16);
        this.dontReplaceButton.setText(Messages.getString("CMCopyReplaceDialog.dontReplace"));
        this.dontReplaceButton.setData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.dontReplaceButton.setSelection(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent.getShell(), this.getHelpContextId());
        this.setTitleImage(UIPlugin.getImage((ImageDescriptor)UIPlugin.EXECUTE_WIZ_BAN));
        this.setTitle(Messages.getString("CMCopyReplaceDialog.ReplaceDialogTitle"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cics.cm.ui.replace_dialog");
        return dialogArea;
    }

    private String getHelpContextId() {
        return null;
    }

    private String getOriginGroupsString(SortedSet<String> sortedSet) {
        StringBuffer groups = new StringBuffer();
        boolean first = true;
        for (String s : sortedSet) {
            if (!first) {
                groups.append(", ");
            } else {
                first = false;
            }
            groups.append(s);
        }
        return groups.toString();
    }

    private SortedSet<String> getGroupsSet(List<ICMDefinition> defs2) {
        TreeSet<String> sortedSet = new TreeSet<String>();
        for (ICMDefinition def : defs2) {
            String name = def.getResourceGroupName();
            if (sortedSet.contains(name)) continue;
            sortedSet.add(name);
        }
        return sortedSet;
    }

    public boolean getReplaceBool() {
        return this.replace;
    }

    protected void okPressed() {
        if (this.replaceButton.getSelection()) {
            this.replace = true;
        }
        super.okPressed();
    }
}

