/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.editors;

import com.ibm.cics.cm.model.ZfsConfiguration;
import com.ibm.cics.cm.model.ZfsDefinition;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.composites.NameDescriptionComposite;
import com.ibm.cics.cm.ui.dialogs.BrowseZfsDialog;
import com.ibm.cics.cm.ui.editors.ZfsDefinitionEditor;
import com.ibm.cics.cm.ui.editors.ZfsDefinitionEditorInput;
import com.ibm.cics.cm.utilities.Utilities;
import com.ibm.cics.core.ui.UIHelper;
import com.ibm.cics.eclipse.common.editor.HelpAction;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.text.MessageFormat;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ZfsDefinitionOverviewPage
extends FormPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2017, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String PAGE_ID = "overviewpage";
    private FormEditor editor;
    private ZfsDefinition definition;
    private boolean errorsOnPage = false;
    private Text descText;
    private Text pathText;
    private Text data1Text;
    private Text data2Text;
    private Text data3Text;
    private Text data4Text;

    public ZfsDefinitionOverviewPage(ZfsDefinitionEditor editor) {
        super((FormEditor)editor, PAGE_ID, Messages.getString("ConfigurationOverviewPage.title"));
        this.initialize(editor);
        this.editor = editor;
        if (this.editor != null && this.editor.getEditorInput() instanceof ZfsDefinitionEditorInput) {
            this.definition = ((ZfsDefinitionEditorInput)editor.getEditorInput()).getZfsDefinition();
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        IManagedForm mForm = managedForm;
        FormToolkit toolkit = mForm.getToolkit();
        Form form = mForm.getForm().getForm();
        final Composite body = form.getBody();
        GridLayout layout = new GridLayout(1, false);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        body.setLayout((Layout)layout);
        toolkit.decorateFormHeading(form);
        form.setText(Messages.getString("ConfigurationOverviewPage.title"));
        form.setImage(this.editor.getTitleImage());
        HelpAction helpAction = new HelpAction(this.getHelpContextID());
        form.getToolBarManager().add((IAction)helpAction);
        form.updateToolBar();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, this.getHelpContextID());
        Section genInfoSection = toolkit.createSection(body, 320);
        genInfoSection.setText(Messages.getString("ConfigurationOverviewPage.section.generalinformation.title"));
        genInfoSection.setLayoutData((Object)new GridData(4, -1, true, false));
        Composite genInfoArea = toolkit.createComposite((Composite)genInfoSection, 0);
        layout = new GridLayout(1, false);
        layout.horizontalSpacing = 15;
        genInfoArea.setLayout((Layout)layout);
        genInfoSection.setClient((Control)genInfoArea);
        genInfoArea.setLayoutData((Object)new GridData(4, -1, true, false));
        NameDescriptionComposite nameDesc = new NameDescriptionComposite(genInfoArea, 0, this.definition.getName());
        nameDesc.setLayoutData(new GridData(4, -1, true, false));
        this.descText = nameDesc.descText;
        this.descText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZfsDefinitionOverviewPage.this.setDirty(true);
                ZfsDefinitionOverviewPage.this.validateInputs();
            }
        });
        Section zfsOptionsSection = toolkit.createSection(body, 320);
        zfsOptionsSection.setText(Messages.getString("ConfigurationOverviewPage.section.zfsoptions.title"));
        zfsOptionsSection.setLayoutData((Object)new GridData(4, -1, true, false));
        Composite zfsOptionsArea = toolkit.createComposite((Composite)zfsOptionsSection, 0);
        layout = new GridLayout(3, false);
        layout.horizontalSpacing = 15;
        zfsOptionsArea.setLayout((Layout)layout);
        zfsOptionsSection.setClient((Control)zfsOptionsArea);
        zfsOptionsArea.setLayoutData((Object)new GridData(4, -1, true, false));
        Label locationLabel = new Label(zfsOptionsArea, 0);
        locationLabel.setText(Messages.getString("zfsDefinition.location"));
        locationLabel.setLayoutData((Object)new GridData(16384, -1, false, false));
        Label location = new Label(zfsOptionsArea, 0);
        location.setText(this.definition.getLocation());
        location.setLayoutData((Object)new GridData(16384, -1, false, false, 2, 1));
        Label pathLabel = new Label(zfsOptionsArea, 0);
        pathLabel.setText(Messages.getString("zfsDefinition.path"));
        pathLabel.setLayoutData((Object)new GridData(16384, -1, false, false));
        Utilities.addMandatoryField((Control)pathLabel);
        TextInput pathInput = new TextInput(zfsOptionsArea, pathLabel);
        pathInput.setLayoutData((Object)new GridData(4, -1, true, false));
        this.pathText = pathInput.text;
        this.pathText.setTextLimit(255);
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZfsDefinitionOverviewPage.this.setDirty(true);
                ZfsDefinitionOverviewPage.this.validateInputs();
            }
        });
        Button zfsBrowseButton = new Button(zfsOptionsArea, 8);
        zfsBrowseButton.setText(Messages.getString("BrowseZfs.buttonText"));
        zfsBrowseButton.setLayoutData((Object)new GridData(16384, -1, false, false));
        zfsBrowseButton.setEnabled(true);
        zfsBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowseZfsDialog dialog = new BrowseZfsDialog(body.getShell(), (ZfsConfiguration)ZfsDefinitionOverviewPage.this.definition.getConfiguration(), "RelativePath");
                if (dialog.open() == 0) {
                    ZfsDefinitionOverviewPage.this.pathText.setText(dialog.getSelectedPath());
                }
            }
        });
        Label data1Label = new Label(zfsOptionsArea, 0);
        data1Label.setText(Messages.getString("zfsDefinition.data1"));
        data1Label.setLayoutData((Object)new GridData(16384, -1, false, false));
        TextInput data1Input = new TextInput(zfsOptionsArea, data1Label);
        data1Input.setLayoutData((Object)new GridData(16384, -1, true, false, 2, 1));
        this.data1Text = data1Input.text;
        this.data1Text.setTextLimit(16);
        this.data1Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZfsDefinitionOverviewPage.this.setDirty(true);
                ZfsDefinitionOverviewPage.this.validateInputs();
            }
        });
        Label data2Label = new Label(zfsOptionsArea, 0);
        data2Label.setText(Messages.getString("zfsDefinition.data2"));
        data2Label.setLayoutData((Object)new GridData(16384, -1, false, false));
        TextInput data2Input = new TextInput(zfsOptionsArea, data2Label);
        data2Input.setLayoutData((Object)new GridData(16384, -1, true, false, 2, 1));
        this.data2Text = data2Input.text;
        this.data2Text.setTextLimit(16);
        this.data2Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZfsDefinitionOverviewPage.this.setDirty(true);
                ZfsDefinitionOverviewPage.this.validateInputs();
            }
        });
        Label data3Label = new Label(zfsOptionsArea, 0);
        data3Label.setText(Messages.getString("zfsDefinition.data3"));
        data3Label.setLayoutData((Object)new GridData(16384, -1, false, false));
        TextInput data3Input = new TextInput(zfsOptionsArea, data3Label);
        data3Input.setLayoutData((Object)new GridData(16384, -1, true, false, 2, 1));
        this.data3Text = data3Input.text;
        this.data3Text.setTextLimit(16);
        this.data3Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZfsDefinitionOverviewPage.this.setDirty(true);
                ZfsDefinitionOverviewPage.this.validateInputs();
            }
        });
        Label data4Label = new Label(zfsOptionsArea, 0);
        data4Label.setText(Messages.getString("zfsDefinition.data4"));
        data4Label.setLayoutData((Object)new GridData(16384, -1, false, false));
        TextInput data4Input = new TextInput(zfsOptionsArea, data4Label);
        data4Input.setLayoutData((Object)new GridData(16384, -1, true, false, 2, 1));
        this.data4Text = data4Input.text;
        this.data4Text.setTextLimit(16);
        this.data4Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZfsDefinitionOverviewPage.this.setDirty(true);
                ZfsDefinitionOverviewPage.this.validateInputs();
            }
        });
        this.refresh();
    }

    private String getHelpContextID() {
        return "com.ibm.cics.cm.ui.editor_migrationscheme";
    }

    protected boolean hasErrors() {
        return this.errorsOnPage;
    }

    private void validateInputs() {
        String errorMessage = null;
        String relativePath = this.pathText.getText();
        if (relativePath.isEmpty()) {
            errorMessage = Messages.getString("ZfsDefinitionWizardDetailsPage.errorMessage.relativePath.empty");
            this.setErrorMessage((Control)this.pathText, errorMessage, errorMessage);
        } else if (!relativePath.matches("[A-Za-z0-9$@#\\./-_%&?!:|\"=,;<> ]{1,255}")) {
            errorMessage = MessageFormat.format(Messages.getString("ZfsDirectoryDefinitions.errorMessage.chars"), Messages.getString("ZfsDefinitionsView.column.path"));
            this.setErrorMessage((Control)this.pathText, errorMessage, errorMessage);
        } else if (relativePath.startsWith("/")) {
            errorMessage = Messages.getString("ZfsDefinitionWizardDetailsPage.errorMessage.mustNotStart");
            this.setErrorMessage((Control)this.pathText, errorMessage, errorMessage);
        } else if (relativePath.matches(".*//.*")) {
            errorMessage = MessageFormat.format(Messages.getString("ZfsDirectoryDefinitions.errorMessage.slash"), Messages.getString("ZfsDefinitionsView.column.path"));
            this.setErrorMessage((Control)this.pathText, errorMessage, errorMessage);
        } else {
            this.clearErrorMessage((Control)this.pathText);
        }
        ((ZfsDefinitionEditor)this.editor).refreshDirty();
    }

    private void setErrorMessage(Control control, String shortMessage, String longMessage) {
        ScrolledForm form = this.getManagedForm().getForm();
        IStatusLineManager status = this.getEditorSite().getActionBars().getStatusLineManager();
        if (control != null) {
            UIHelper.errorControl((Control)control, (String)longMessage);
        }
        form.setMessage(shortMessage, 3);
        status.setErrorMessage(UIActivator.getImage(UIActivator.IMGD_ERROR), longMessage);
        this.errorsOnPage = true;
        status.update(true);
    }

    private void clearErrorMessage(Control control) {
        ScrolledForm form = this.getManagedForm().getForm();
        IStatusLineManager status = this.getEditorSite().getActionBars().getStatusLineManager();
        if (control != null) {
            UIHelper.clearError((Control)control);
        }
        form.setMessage(null, -1);
        status.setErrorMessage(null);
        this.errorsOnPage = false;
        status.update(true);
    }

    private void setDirty(boolean value) {
        ((ZfsDefinitionEditor)this.editor).setDirty(value);
    }

    protected void refresh() {
        this.descText.setText(this.definition.getDescription());
        this.pathText.setText(this.definition.getRelPath());
        this.data1Text.setText(this.definition.getData1());
        this.data2Text.setText(this.definition.getData2());
        this.data3Text.setText(this.definition.getData3());
        this.data4Text.setText(this.definition.getData4());
        this.setDirty(false);
        this.validateInputs();
    }

    protected String getDescription() {
        return this.descText.getText();
    }

    protected void savePage() {
        this.definition.setDescription(this.descText.getText());
        this.definition.setRelPath(this.pathText.getText());
        this.definition.setData1(this.data1Text.getText());
        this.definition.setData2(this.data2Text.getText());
        this.definition.setData3(this.data3Text.getText());
        this.definition.setData4(this.data4Text.getText());
    }

    public void setServerError(CMServerException e) {
        String errorMessage;
        Text field = null;
        if (e.isZfsFileNotFound()) {
            errorMessage = Messages.getString("ZfsDefinitionWizardDetailsPage.errorMessage.relativePath.notFound");
            field = this.pathText;
        } else if (e.isZfsPathAlreadyDefined()) {
            errorMessage = Messages.getString("ZfsDefinitionWizardDetailsPage.errorMessage.relativePath.alreadyDefined");
            field = this.pathText;
        } else {
            this.clearErrorMessage((Control)this.pathText);
            errorMessage = MessageFormat.format(Messages.getString("ZfsDefinitionEditor.errorMessage.genericServer"), e.getMessage());
        }
        this.setErrorMessage((Control)field, errorMessage, errorMessage);
    }
}

