/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.editors;

import com.ibm.cics.cm.model.ZfsDefinition;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.MessageResponse;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.editors.ZfsDefinitionEditorInput;
import com.ibm.cics.cm.ui.editors.ZfsDefinitionOverviewPage;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ZfsDefinitionEditor
extends FormEditor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2017, 2023 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ID = "com.ibm.cics.cm.ui.zfsdefinition.editor";
    private ZfsDefinition.ZfsDefinitionListener definitionListener;
    private ZfsDefinitionOverviewPage overviewPage;
    private ZfsDefinition definition;
    private boolean dirty;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setPartName(MessageFormat.format(Messages.getString("ZfsDefinitionEditor.partname"), input.getName()));
        this.setTitleImage(UIActivator.getImage(UIActivator.IMG_ZFS_DEFINITION));
    }

    public FormToolkit getToolkit() {
        if (super.getToolkit() == null) {
            super.createToolkit(Display.getCurrent());
        }
        return super.getToolkit();
    }

    protected void addPages() {
        try {
            this.overviewPage = new ZfsDefinitionOverviewPage(this);
            this.addPage((IFormPage)this.overviewPage);
            IEditorInput input = this.getEditorInput();
            if (input instanceof ZfsDefinitionEditorInput) {
                ZfsDefinition definition;
                ZfsDefinition zfsDefinition = definition = ((ZfsDefinitionEditorInput)input).getZfsDefinition();
                zfsDefinition.getClass();
                this.definitionListener = new ZfsDefinition.ZfsDefinitionListener(zfsDefinition, definition){

                    public void notify(boolean changed, ZfsDefinition source) {
                        if (source.isDeleted()) {
                            ZfsDefinitionEditor.this.closeEditor();
                        } else {
                            ZfsDefinitionEditor.this.refreshEditor(changed);
                        }
                    }
                };
                definition.addListener(this.definitionListener);
                this.definition = definition;
            }
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }

    private void closeEditor() {
        final ZfsDefinitionEditor editor = this;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)editor, false);
            }
        });
    }

    private void refreshEditor(boolean changed) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean refreshOK = true;
                if (ZfsDefinitionEditor.this.dirty) {
                    MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 196);
                    messageBox.setText(Messages.getString("ZfsDefinitionEditor.message.refreshDirtyEditor.title"));
                    messageBox.setMessage(Messages.getString("ZfsDefinitionEditor.message.refreshDirtyEditor.description"));
                    if (messageBox.open() == 128) {
                        refreshOK = false;
                    }
                }
                if (refreshOK) {
                    ZfsDefinitionEditor.this.overviewPage.refresh();
                    ZfsDefinitionEditor.this.setDirty(false);
                }
            }
        });
    }

    public void doSave(IProgressMonitor monitor) {
        MessageResponse lastResponse;
        block4: {
            this.overviewPage.savePage();
            try {
                lastResponse = this.definition.update();
                this.definition.setIntegrityToken(lastResponse.integrityToken);
                this.setDirty(false);
            }
            catch (CMServerException e) {
                lastResponse = e.getMessageResponse();
                if (e.isIntegrityTokenMismatch()) {
                    ZfsDefinition newDefinition = ConfigurationManager.getCurrent().getZfsDefinition(this.definition.getName(), this.definition.getConfigurationName());
                    this.definition.setAttributes(newDefinition.getAttributes());
                    this.definition.notifyListeners(true);
                }
                if (!e.isError()) break block4;
                this.overviewPage.setServerError(e);
            }
        }
        if (lastResponse != null) {
            Status status = this.getStatusToLog(lastResponse);
            UIActivator.getDefault().getLog().log((IStatus)status);
        }
    }

    private Status getStatusToLog(MessageResponse mr) {
        int logLevel = 1;
        switch (mr.returnCode) {
            case 0: {
                logLevel = 0;
                break;
            }
            case 4: {
                logLevel = 2;
                break;
            }
            case 8: {
                logLevel = 4;
                break;
            }
            case 12: {
                logLevel = 4;
                break;
            }
            case 16: {
                logLevel = 4;
                break;
            }
            default: {
                logLevel = 1;
            }
        }
        String message = MessageFormat.format(Messages.getString("ZfsDefinitionEditor.status.saved"), this.definition.getName(), mr.getReadableReturnCode());
        MultiStatus status = new MultiStatus("com.ibm.cics.cm.ui", logLevel, message, null);
        if (logLevel != 0) {
            status.add((IStatus)new Status(logLevel, "com.ibm.cics.cm.ui", mr.getReadableReasonCode()));
        }
        return status;
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        this.definition.removeListener(this.definitionListener);
        this.definitionListener.dispose();
        super.dispose();
    }

    public boolean isDirty() {
        return this.dirty && !this.overviewPage.hasErrors();
    }

    protected void setDirty(boolean value) {
        this.dirty = value;
        this.firePropertyChange(257);
    }

    protected void refreshDirty() {
        this.firePropertyChange(257);
    }
}

