/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.editors;

import com.ibm.cics.cm.model.ZfsConfiguration;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.composites.ZfsBackupControls;
import com.ibm.cics.cm.ui.dialogs.BrowseZfsDialog;
import com.ibm.cics.cm.ui.editors.ConfigurationEditor;
import com.ibm.cics.cm.ui.editors.ConfigurationOverviewPage;
import com.ibm.cics.cm.utilities.Utilities;
import com.ibm.cics.core.ui.UIHelper;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.text.MessageFormat;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ZfsConfigurationOverviewPage
extends ConfigurationOverviewPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2017, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Text zfsRootText;
    private Button backup;
    private Spinner backupCount;
    private Text backupDirText;

    protected ZfsConfigurationOverviewPage(ConfigurationEditor configurationEditor) {
        super(configurationEditor);
    }

    @Override
    protected void createFiletypeSpecificContent(IManagedForm managedForm, FormToolkit toolkit, final Composite body) {
        Section zfsOptionsSection = toolkit.createSection(body, 320);
        zfsOptionsSection.setText(Messages.getString("ConfigurationOverviewPage.section.zfsoptions.title"));
        zfsOptionsSection.setLayoutData((Object)new GridData(4, -1, true, false));
        Composite zfsOptionsArea = toolkit.createComposite((Composite)zfsOptionsSection, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 15;
        zfsOptionsArea.setLayout((Layout)layout);
        zfsOptionsSection.setClient((Control)zfsOptionsArea);
        zfsOptionsArea.setLayoutData((Object)new GridData(4, -1, true, false, 1, 1));
        Composite zfsOptionsAreaMain = toolkit.createComposite(zfsOptionsArea, 0);
        GridLayout layoutMain = new GridLayout(3, false);
        layoutMain.horizontalSpacing = 15;
        zfsOptionsAreaMain.setLayout((Layout)layoutMain);
        zfsOptionsAreaMain.setLayoutData((Object)new GridData(4, -1, true, false, 1, 1));
        Label zfsRootLabel = new Label(zfsOptionsAreaMain, 0);
        zfsRootLabel.setText(Messages.getString("Configuration.zfs.root"));
        zfsRootLabel.setLayoutData((Object)new GridData(16384, -1, false, false));
        Utilities.addMandatoryField((Control)zfsRootLabel);
        TextInput zfsRootInput = new TextInput(zfsOptionsAreaMain, zfsRootLabel);
        zfsRootInput.setLayoutData((Object)new GridData(4, -1, true, false));
        this.zfsRootText = zfsRootInput.text;
        this.zfsRootText.setTextLimit(255);
        this.zfsRootText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZfsConfigurationOverviewPage.this.setDirty(true);
                ZfsConfigurationOverviewPage.this.validateInputs();
            }
        });
        this.zfsRootText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                String text;
                if (!UIHelper.hasError((Control)ZfsConfigurationOverviewPage.this.zfsRootText) && !(text = ZfsConfigurationOverviewPage.this.zfsRootText.getText()).endsWith("/")) {
                    ZfsConfigurationOverviewPage.this.zfsRootText.setText(String.valueOf(text) + "/");
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        Button zfsBrowseButton = new Button(zfsOptionsAreaMain, 8);
        zfsBrowseButton.setText(Messages.getString("BrowseZfs.buttonText"));
        zfsBrowseButton.setLayoutData((Object)new GridData(16384, -1, false, false));
        zfsBrowseButton.setEnabled(true);
        zfsBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowseZfsDialog dialog = new BrowseZfsDialog(body.getShell(), null, "RootDir");
                if (dialog.open() == 0) {
                    ZfsConfigurationOverviewPage.this.zfsRootText.setText(dialog.getSelectedPath());
                }
            }
        });
        ZfsBackupControls backupComposite = new ZfsBackupControls(zfsOptionsArea, 0, toolkit);
        this.backup = backupComposite.backup;
        this.backup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZfsConfigurationOverviewPage.this.setDirty(true);
                ZfsConfigurationOverviewPage.this.validateInputs();
            }
        });
        this.backupCount = backupComposite.backupCount;
        this.backupCount.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZfsConfigurationOverviewPage.this.setDirty(true);
            }
        });
        this.backupDirText = backupComposite.backupDirText;
        this.backupDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZfsConfigurationOverviewPage.this.setDirty(true);
                ZfsConfigurationOverviewPage.this.validateInputs();
            }
        });
    }

    @Override
    protected void validateInputs() {
        if (!this.pageLoading) {
            if (this.validateDirectoryField(this.zfsRootText, "Configuration.zfs.root")) {
                if (this.backup.getSelection()) {
                    this.validateDirectoryField(this.backupDirText, "Configuration.zfs.backupdirectory");
                } else {
                    UIHelper.clearError((Control)this.backupDirText);
                }
            }
            ((ConfigurationEditor)this.editor).refreshDirty();
        }
    }

    protected boolean validateDirectoryField(Text directoryText, String propertyName) {
        String fieldName = Messages.getString(propertyName);
        String errorMessage = null;
        String directory = directoryText.getText();
        if (directory.isEmpty()) {
            errorMessage = Messages.getString(String.valueOf(propertyName) + ".errorMessage.empty");
        } else if (!directory.startsWith("/")) {
            errorMessage = MessageFormat.format(Messages.getString("ZfsDirectoryDefinitions.errorMessage.mustStart"), fieldName);
        } else if (!directory.matches("[A-Za-z0-9$@#\\./-_%&?!:|\"=,;<> ]{1,255}")) {
            errorMessage = MessageFormat.format(Messages.getString("ZfsDirectoryDefinitions.errorMessage.chars"), fieldName);
        } else if (directory.matches(".*//.*")) {
            errorMessage = MessageFormat.format(Messages.getString("ZfsDirectoryDefinitions.errorMessage.slash"), fieldName);
        } else if (directory.length() == 255 && !directory.endsWith("/")) {
            errorMessage = MessageFormat.format(Messages.getString("ZfsDirectoryDefinitions.errorMessage.mustEnd"), fieldName);
        }
        if (errorMessage != null) {
            this.setErrorMessage((Control)directoryText, errorMessage, errorMessage);
            return false;
        }
        this.clearErrorMessage((Control)directoryText);
        return true;
    }

    @Override
    protected void refresh() {
        ZfsConfiguration zfs = (ZfsConfiguration)this.configuration;
        this.zfsRootText.setText(zfs.getZfsRootDir());
        this.backup.setSelection(zfs.getZfsBackup());
        this.backupCount.setSelection(zfs.getZfsBackupCount());
        this.backupDirText.setText(zfs.getZfsBackupDir());
        super.refresh();
    }

    @Override
    protected void saveTypeSpecificAttributes() {
        ZfsConfiguration zfs = (ZfsConfiguration)this.configuration;
        String rootDir = this.zfsRootText.getText();
        if (!rootDir.endsWith("/")) {
            rootDir = String.valueOf(rootDir) + "/";
            this.zfsRootText.setText(rootDir);
        }
        zfs.setZfsRootDir(rootDir);
        boolean backupSelected = this.backup.getSelection();
        zfs.setZfsBackup(backupSelected);
        if (backupSelected) {
            zfs.setZfsBackupCount(this.backupCount.getSelection());
            String backupDir = this.backupDirText.getText();
            if (!backupDir.endsWith("/")) {
                backupDir = String.valueOf(backupDir) + "/";
                this.backupDirText.setText(backupDir);
            }
            zfs.setZfsBackupDir(backupDir);
        } else {
            zfs.setZfsBackupCount(0);
            zfs.setZfsBackupDir("");
        }
    }

    @Override
    public void setServerError(CMServerException e) {
        if (e.isZfsFileNotFound()) {
            boolean backupSpecified = this.backup.getSelection();
            String fieldName = Messages.getString("Configuration.zfs.root");
            if (backupSpecified) {
                fieldName = String.valueOf(fieldName) + "/" + Messages.getString("Configuration.zfs.backupdirectory");
            }
            String errorMessage = MessageFormat.format(Messages.getString("ZfsDirectoryDefinitions.errorMessage.notFound"), fieldName);
            this.setErrorMessage((Control)this.zfsRootText, errorMessage, errorMessage);
            if (backupSpecified) {
                this.setErrorMessage((Control)this.backupDirText, errorMessage, errorMessage);
            }
        } else {
            super.setServerError(e);
        }
    }
}

