/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.editors;

import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.ICMDefinition2;
import com.ibm.cics.cm.model.ResourceList;
import com.ibm.cics.cm.model.definitions.CICSRegionDefinition;
import com.ibm.cics.cm.model.definitions.CICSRegionGroupDefinition;
import com.ibm.cics.cm.model.definitions.ResourceDefinition;
import com.ibm.cics.cm.model.definitions.WorkloadSpecificationDefinition;
import com.ibm.cics.cm.model.runtime.ActionMessageResponse;
import com.ibm.cics.cm.model.runtime.CMServerAddException;
import com.ibm.cics.cm.model.runtime.MessageResponse;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.editors.AbstractAddToPackageHandler;
import com.ibm.cics.cm.ui.wizards.ChangePackageTopologyWizard;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSRegionDefinition;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.ICSDListDefinition;
import com.ibm.cics.model.IWorkloadSpecification;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;

public class PackageResourcesHandler
extends AbstractAddToPackageHandler
implements Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String PACKAGE_PARM_ID = "com.ibm.cics.cm.ui.chgpkg.parm.package";
    public static final String CONFIGURATION_PARM_ID = "com.ibm.cics.cm.ui.chgpkg.parm.configuration";
    private static final Logger logger = Logger.getLogger(PackageResourcesHandler.class.getPackage().getName());
    private List<IHandlerListener> listeners = new ArrayList<IHandlerListener>();

    @Override
    public void addHandlerListener(IHandlerListener handlerListener) {
        this.listeners.add(handlerListener);
    }

    @Override
    public void removeHandlerListener(IHandlerListener handlerListener) {
        this.listeners.remove(handlerListener);
    }

    @Override
    public void dispose() {
        this.listeners.clear();
    }

    private static IEclipseContext getActiveContext() {
        IEclipseContext parentContext = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        return parentContext.getActiveLeaf();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public Object execute(ExecutionEvent event) {
        selection = PackageResourcesHandler.getActiveContext().get("activeMenuSelection");
        super.execute(event);
        definitions = new ArrayList<ICMDefinition2>();
        systemGroups = new ArrayList<CICSRegionGroupDefinition>();
        resourceLists = new ArrayList<ResourceList>();
        if (this.targetPackage == null) {
            return null;
        }
        if (selection instanceof IStructuredSelection) {
            structSel = (IStructuredSelection)selection;
            for (E next : structSel.toList()) {
                if (next instanceof ICICSDefinition) {
                    cmDef = (ICMDefinition)Platform.getAdapterManager().getAdapter(next, ICMDefinition.class);
                    if (cmDef != null) {
                        definitions.add((ICMDefinition2)cmDef);
                        continue;
                    }
                    status = new Status(2, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("PackageResourcesHandler.warning.adaptResourceFailed"), new Object[]{((ICICSDefinition)next).getName()}));
                    UIActivator.getDefault().getLog().log((IStatus)status);
                    ViewHelper.setDeferredStatusErrorMessage((String)status.getMessage());
                    continue;
                }
                if (next instanceof ICICSRegionDefinition) {
                    cmDef = (CICSRegionDefinition)Platform.getAdapterManager().getAdapter(next, CICSRegionDefinition.class);
                    if (cmDef != null) {
                        definitions.add((ICMDefinition2)cmDef);
                        continue;
                    }
                    status = new Status(2, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("PackageResourcesHandler.warning.adaptResourceFailed"), new Object[]{((ICICSRegionDefinition)next).getName()}));
                    UIActivator.getDefault().getLog().log((IStatus)status);
                    ViewHelper.setDeferredStatusErrorMessage((String)status.getMessage());
                    continue;
                }
                if (next instanceof ICICSRegionGroupDefinition) {
                    cSysGrp = (CICSRegionGroupDefinition)Platform.getAdapterManager().getAdapter(next, CICSRegionGroupDefinition.class);
                    if (cSysGrp != null) {
                        systemGroups.add(cSysGrp);
                        continue;
                    }
                    status = new Status(2, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("PackageResourcesHandler.warning.adaptResourceFailed"), new Object[]{((ICICSRegionGroupDefinition)next).getName()}));
                    UIActivator.getDefault().getLog().log((IStatus)status);
                    ViewHelper.setDeferredStatusErrorMessage((String)status.getMessage());
                    continue;
                }
                if (next instanceof IWorkloadSpecification) {
                    cmDef = (WorkloadSpecificationDefinition)Platform.getAdapterManager().getAdapter(next, WorkloadSpecificationDefinition.class);
                    if (cmDef != null) {
                        definitions.add((ICMDefinition2)cmDef);
                        continue;
                    }
                    status = new Status(2, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("PackageResourcesHandler.warning.adaptResourceFailed"), new Object[]{((IWorkloadSpecification)next).getName()}));
                    UIActivator.getDefault().getLog().log((IStatus)status);
                    ViewHelper.setDeferredStatusErrorMessage((String)status.getMessage());
                    continue;
                }
                if (next instanceof ICMDefinition2) {
                    definitions.add((ICMDefinition2)next);
                    continue;
                }
                if (next instanceof ResourceList) {
                    rl = (ResourceList)next;
                    if (!((String)rl.getConfiguration().getAttributes().get("FILETYPE")).equals("CSD")) continue;
                    resourceLists.add(rl);
                    continue;
                }
                if (!(next instanceof ICSDListDefinition) || (rl = (ResourceList)Platform.getAdapterManager().getAdapter(next, ResourceList.class)) == null) continue;
                resourceLists.add(rl);
            }
            if (!systemGroups.isEmpty()) {
                defs = new ArrayList<ResourceDefinition>();
                wizard = new ChangePackageTopologyWizard(systemGroups, this.targetPackage);
                dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    if (wizard.getDefinitions() != null) {
                        defs.addAll(wizard.getDefinitions());
                    }
                    wizard.dispose();
                }
                for (ICMDefinition def : defs) {
                    definitions.add((ICMDefinition2)def);
                }
            }
        }
        if (definitions.size() > 0 && (defsByConfig = CMUtilities.mapCMObjectByConfigurations(definitions)).keySet().size() > 0) {
            configs = defsByConfig.keySet();
            for (Configuration nextCon : configs) {
                list = (List)defsByConfig.get(nextCon);
                cmDefs = new ArrayList<ICMDefinition2>();
                for (E o : list) {
                    cmDefs.add((ICMDefinition2)o);
                }
                addException = null;
                try {
                    this.targetPackage.addDefinitions(cmDefs, nextCon);
                }
                catch (CMServerAddException e) {
                    addException = e;
                    PackageResourcesHandler.logger.logp(Level.WARNING, PackageResourcesHandler.class.getName(), "execute", "Failed to package resources " + this.resolveResourceNames(definitions), e);
                }
                if (addException == null) {
                    status = new Status(1, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("PackageResourcesHandler.message.addedResources"), new Object[]{this.resolveResourceNames(definitions), this.targetPackage.getName()}));
                    UIActivator.getDefault().getLog().log((IStatus)status);
                    ViewHelper.setDeferredStatusInformationMessage((String)status.getMessage());
                    continue;
                }
                if (addException.isPartialAddSuccess()) {
                    listResponse = null;
                    listResponse = (ActionMessageResponse)addException.getMessageResponse();
                    objects = listResponse.getObjects();
                    addedObjects = new ArrayList<Map<String, String>>();
                    failedObjects = new ArrayList<Map>();
                    while (objects.hasNext()) {
                        next = (Map)objects.next();
                        if (Integer.valueOf((String)next.get("RETURNCODE")) == 0) {
                            addedObjects.add(next);
                            continue;
                        }
                        failedObjects.add(next);
                    }
                    stati = new ArrayList<Status>();
                    for (Map next : failedObjects) {
                        stati.add(new Status(4, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("PackageResourcesHandler.message.failedResources"), new Object[]{this.resolveSingleResourceFromMap(next), this.targetPackage.getName(), MessageResponse.getReadableReasonCode((String)((String)next.get("REASONCODE")))})));
                    }
                    stati.add(new Status(1, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("PackageResourcesHandler.message.addedResources"), new Object[]{this.resolveResourceNamesFromRawMaps(addedObjects), this.targetPackage.getName()})));
                    status = new MultiStatus("com.ibm.cics.cm.ui", 0, (IStatus[])stati.toArray(new Status[stati.size()]), MessageFormat.format(Messages.getString("PackageResourcesHandler.warning.addResourcesFailed"), new Object[]{addException.getMessageResponse().getReadableReasonCode()}), (Throwable)addException);
                    UIActivator.getDefault().getLog().log((IStatus)status);
                    ViewHelper.setDeferredStatusErrorMessage((String)status.getMessage());
                    continue;
                }
                listResponse = null;
                listResponse = (ActionMessageResponse)addException.getMessageResponse();
                objects = listResponse.getObjects();
                stati = new ArrayList<Status>();
                while (objects.hasNext()) {
                    next = (Map)objects.next();
                    stati.add(new Status(4, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("PackageResourcesHandler.message.failedResources"), new Object[]{this.resolveSingleResourceFromMap(next), this.targetPackage.getName(), MessageResponse.getReadableReasonCode((String)((String)next.get("REASONCODE")))})));
                }
                status = new MultiStatus("com.ibm.cics.cm.ui", 0, (IStatus[])stati.toArray(new Status[stati.size()]), MessageFormat.format(Messages.getString("PackageResourcesHandler.warning.addResourcesFailed"), new Object[]{addException.getMessageResponse().getReadableReasonCode()}), (Throwable)addException);
                UIActivator.getDefault().getLog().log((IStatus)status);
                ViewHelper.setDeferredStatusErrorMessage((String)status.getMessage());
            }
        }
        if (resourceLists.size() > 0 && (listsByConfig = CMUtilities.mapCMObjectByConfigurations(resourceLists)).keySet().size() > 0) {
            configs = listsByConfig.keySet();
            for (Configuration nextCon : configs) {
                block39: {
                    list = (List)listsByConfig.get(nextCon);
                    lists = new ArrayList<ResourceList>();
                    for (E o : list) {
                        lists.add((ResourceList)o);
                    }
                    addException = null;
                    try {
                        this.targetPackage.addResourceLists(lists, nextCon);
                        break block39;
                    }
                    catch (CMServerAddException e) {
                        addException = e;
                        sb = new StringBuffer();
                        ** for (next : lists)
                    }
lbl-1000:
                    // 1 sources

                    {
                        sb.append("RESDESC(" + next.getName() + "),");
                        continue;
                    }
lbl159:
                    // 1 sources

                    sb.deleteCharAt(sb.lastIndexOf(","));
                    PackageResourcesHandler.logger.logp(Level.WARNING, PackageResourcesHandler.class.getName(), "execute", "Failed to package resources " + this.resolveResourceNames(definitions), e);
                }
                if (addException == null) {
                    status = new Status(1, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("PackageResourcesHandler.message.addedResources"), new Object[]{this.resolveResourceNames(definitions), this.targetPackage.getName()}));
                    UIActivator.getDefault().getLog().log((IStatus)status);
                    ViewHelper.setDeferredStatusInformationMessage((String)status.getMessage());
                    continue;
                }
                if (addException.isPartialAddSuccess()) {
                    listResponse = null;
                    listResponse = (ActionMessageResponse)addException.getMessageResponse();
                    objects = listResponse.getObjects();
                    addedObjects = new ArrayList<E>();
                    failedObjects = new ArrayList<E>();
                    while (objects.hasNext()) {
                        next = (Map)objects.next();
                        if (Integer.valueOf((String)next.get("RETURNCODE")) == 0) {
                            addedObjects.add(next);
                            continue;
                        }
                        failedObjects.add(next);
                    }
                    sb = new StringBuffer();
                    sb.append(MessageFormat.format(Messages.getString("PackageResourcesHandler.warning.addListsFailed"), new Object[]{addException.getMessageResponse().getReadableReasonCode()}));
                    sb.append("\n");
                    sb.append(MessageFormat.format(Messages.getString("PackageResourcesHandler.message.addedResources"), new Object[]{this.resolveResourceNamesFromRawMaps(addedObjects), this.targetPackage.getName()}));
                    for (Map next : failedObjects) {
                        sb.append("\n");
                        sb.append(MessageFormat.format(Messages.getString("PackageResourcesHandler.message.failedResources"), new Object[]{this.resolveSingleResourceFromMap(next), this.targetPackage.getName(), MessageResponse.getReadableReasonCode((String)((String)next.get("REASONCODE")))}));
                    }
                    status = new Status(2, "com.ibm.cics.cm.ui", sb.toString(), (Throwable)addException);
                    UIActivator.getDefault().getLog().log((IStatus)status);
                    ViewHelper.setDeferredStatusErrorMessage((String)status.getMessage());
                    continue;
                }
                status = new Status(2, "com.ibm.cics.cm.ui", Messages.getString("PackageResourcesHandler.warning.addListsFailed"), (Throwable)addException);
                UIActivator.getDefault().getLog().log((IStatus)status);
                ViewHelper.setDeferredStatusErrorMessage((String)status.getMessage());
            }
        }
        return null;
    }

    private String resolveResourceNames(List<ICMDefinition2> resources) {
        StringBuffer sb = new StringBuffer();
        for (ICMDefinition2 next : resources) {
            String name = next.getName();
            String type = next.getType();
            if (next instanceof ICMDefinition && type.equals("CSYSGRP")) {
                name = ((ICMDefinition)next).getResourceGroupName();
            }
            sb.append(String.valueOf(type) + "(" + name + "),");
        }
        if (resources.size() > 0) {
            sb.deleteCharAt(sb.lastIndexOf(","));
        }
        return sb.toString();
    }

    private String resolveResourceNamesFromRawMaps(List<Map<String, String>> resources) {
        StringBuffer sb = new StringBuffer();
        for (Map<String, String> next : resources) {
            sb.append(String.valueOf(this.resolveSingleResourceFromMap(next)) + ",");
        }
        if (resources.size() > 0) {
            sb.deleteCharAt(sb.lastIndexOf(","));
        }
        return sb.toString();
    }

    private String resolveSingleResourceFromMap(Map<String, String> map) {
        return String.valueOf(map.get("OBJTYPE")) + "(" + map.get("OBJNAME") + ")";
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }
}

