/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.editors;

import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.model.ResourceList;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.editors.AbstractAddToPackageHandler;
import com.ibm.cics.cm.ui.editors.PackageCommandsDialog;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICSDGroupDefinition;
import com.ibm.cics.model.ICSDListDefinition;
import com.ibm.cics.model.IResourceGroupDefinition;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PackageCommandsHandler
extends AbstractAddToPackageHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private static IEclipseContext getActiveContext() {
        IEclipseContext parentContext = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        return parentContext.getActiveLeaf();
    }

    @Override
    public Object execute(ExecutionEvent event) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        Object selection = PackageCommandsHandler.getActiveContext().get("activeMenuSelection");
        super.execute(event);
        if (this.targetPackage == null) {
            return null;
        }
        ArrayList<ICMDefinition> definitions = new ArrayList<ICMDefinition>();
        ArrayList<ResourceDefinitionGroup> groups = new ArrayList<ResourceDefinitionGroup>();
        ArrayList<ResourceList> resourceLists = new ArrayList<ResourceList>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSel = (IStructuredSelection)selection;
            for (Object next : structSel.toList()) {
                ResourceList rl;
                ResourceDefinitionGroup cmGroupDef;
                if (next instanceof ICICSDefinition) {
                    ICMDefinition cmDef = (ICMDefinition)Platform.getAdapterManager().getAdapter(next, ICMDefinition.class);
                    if (cmDef != null) {
                        definitions.add(cmDef);
                        continue;
                    }
                    Status status = new Status(2, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("PackageResourcesHandler.warning.adaptResourceFailed"), ((ICICSDefinition)next).getName()));
                    UIActivator.getDefault().getLog().log((IStatus)status);
                    ViewHelper.setDeferredStatusErrorMessage((String)status.getMessage());
                    continue;
                }
                if (next instanceof ICMDefinition) {
                    definitions.add((ICMDefinition)next);
                    continue;
                }
                if (next instanceof ResourceDefinitionGroup) {
                    groups.add((ResourceDefinitionGroup)next);
                    continue;
                }
                if (next instanceof ICSDGroupDefinition) {
                    cmGroupDef = (ResourceDefinitionGroup)Platform.getAdapterManager().getAdapter(next, ResourceDefinitionGroup.class);
                    if (cmGroupDef == null) continue;
                    groups.add(cmGroupDef);
                    continue;
                }
                if (next instanceof IResourceGroupDefinition) {
                    cmGroupDef = (ResourceDefinitionGroup)Platform.getAdapterManager().getAdapter(next, ResourceDefinitionGroup.class);
                    if (cmGroupDef == null) continue;
                    groups.add(cmGroupDef);
                    continue;
                }
                if (next instanceof ResourceList) {
                    rl = (ResourceList)next;
                    if (!((String)rl.getConfiguration().getAttributes().get("FILETYPE")).equals("CSD")) continue;
                    resourceLists.add(rl);
                    continue;
                }
                if (!(next instanceof ICSDListDefinition) || (rl = (ResourceList)Platform.getAdapterManager().getAdapter(next, ResourceList.class)) == null) continue;
                resourceLists.add(rl);
            }
        }
        ArrayList<ICMObject> inputObjects = new ArrayList<ICMObject>();
        if (definitions.size() > 0) {
            inputObjects.addAll(definitions);
        } else if (groups.size() > 0) {
            inputObjects.addAll(groups);
        } else if (resourceLists.size() > 0) {
            inputObjects.addAll(resourceLists);
        }
        PackageCommandsDialog dialog = new PackageCommandsDialog(shell, this.targetPackage, inputObjects);
        dialog.open();
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }
}

