/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.editors;

import com.ibm.cics.cm.model.MigrationPath;
import com.ibm.cics.cm.model.MigrationScheme;
import com.ibm.cics.cm.model.TransformationVariable;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.composites.MigrationPathsComposite;
import com.ibm.cics.cm.ui.composites.NameDescriptionComposite;
import com.ibm.cics.cm.ui.composites.TransformationVariablesComposite;
import com.ibm.cics.cm.ui.editors.MigrationSchemeEditor;
import com.ibm.cics.cm.ui.editors.MigrationSchemeEditorInput;
import com.ibm.cics.cm.utilities.ListeningArrayList;
import com.ibm.cics.core.ui.UIHelper;
import com.ibm.cics.eclipse.common.editor.HelpAction;
import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class MigrationSchemeOverviewPage
extends FormPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String PAGE_ID = "overviewpage";
    private FormEditor editor;
    private MigrationScheme scheme;
    private boolean errorsOnPage = false;
    private Text descText;
    private Button approval;
    private MigrationPathsComposite paths;
    private TransformationVariablesComposite vars;
    private boolean refreshing;

    public MigrationSchemeOverviewPage(MigrationSchemeEditor editor) {
        super((FormEditor)editor, PAGE_ID, Messages.getString("ConfigurationOverviewPage.title"));
        this.initialize(editor);
        this.editor = editor;
        if (this.editor != null && this.editor.getEditorInput() instanceof MigrationSchemeEditorInput) {
            this.scheme = ((MigrationSchemeEditorInput)editor.getEditorInput()).getMigrationScheme();
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        IManagedForm mForm = managedForm;
        FormToolkit toolkit = mForm.getToolkit();
        Form form = mForm.getForm().getForm();
        Composite body = form.getBody();
        GridLayout layout = new GridLayout(1, false);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        body.setLayout((Layout)layout);
        toolkit.decorateFormHeading(form);
        form.setText(Messages.getString("ConfigurationOverviewPage.title"));
        form.setImage(this.editor.getTitleImage());
        HelpAction helpAction = new HelpAction(this.getHelpContextID());
        form.getToolBarManager().add((IAction)helpAction);
        form.updateToolBar();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, this.getHelpContextID());
        Section genInfoSection = toolkit.createSection(body, 320);
        genInfoSection.setText(Messages.getString("MigrationSchemeEditor.section.geninfo.title"));
        genInfoSection.setLayoutData((Object)new GridData(4, -1, true, false));
        Composite genInfoArea = toolkit.createComposite((Composite)genInfoSection, 0);
        layout = new GridLayout(1, false);
        layout.horizontalSpacing = 15;
        genInfoArea.setLayout((Layout)layout);
        genInfoSection.setClient((Control)genInfoArea);
        genInfoArea.setLayoutData((Object)new GridData(4, -1, true, false));
        NameDescriptionComposite nameDesc = new NameDescriptionComposite(genInfoArea, 0, this.scheme.getName());
        nameDesc.setLayoutData(new GridData(4, -1, true, false));
        this.descText = nameDesc.descText;
        this.descText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MigrationSchemeOverviewPage.this.setDirty(true);
                MigrationSchemeOverviewPage.this.validateInputs();
            }
        });
        this.approval = new Button(genInfoArea, 32);
        this.approval.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.approval.setText(Messages.getString("MigrationSchemeWizardPage.field.approval"));
        this.approval.setToolTipText(Messages.getString("MigrationSchemeWizardPage.field.approval.description"));
        this.approval.setSelection(false);
        this.approval.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MigrationSchemeOverviewPage.this.setDirty(true);
                MigrationSchemeOverviewPage.this.validateInputs();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Section migrationPathsSection = toolkit.createSection(body, 320);
        migrationPathsSection.setText(Messages.getString("MigrationSchemeEditor.section.paths.title"));
        migrationPathsSection.setLayoutData((Object)new GridData(4, -1, true, false));
        Composite migrationPathsArea = toolkit.createComposite((Composite)migrationPathsSection, 0);
        layout = new GridLayout(1, false);
        layout.horizontalSpacing = 15;
        migrationPathsArea.setLayout((Layout)layout);
        migrationPathsSection.setClient((Control)migrationPathsArea);
        migrationPathsArea.setLayoutData((Object)new GridData(4, -1, true, false));
        this.paths = new MigrationPathsComposite(migrationPathsArea, 0);
        this.paths.setLayoutData(new GridData(4, 4, true, true));
        ArrayList<MigrationPath> migrationPaths = this.paths.getMigrationPaths();
        if (migrationPaths instanceof ListeningArrayList) {
            ListeningArrayList lMigrationPaths;
            ListeningArrayList listeningArrayList = lMigrationPaths = (ListeningArrayList)migrationPaths;
            listeningArrayList.getClass();
            lMigrationPaths.addListener(new ListeningArrayList.ArrayListListener(listeningArrayList, lMigrationPaths){

                @Override
                public void notify(boolean changed, ListeningArrayList<?> source) {
                    MigrationSchemeOverviewPage.this.setDirty(true);
                    MigrationSchemeOverviewPage.this.validateInputs();
                }
            });
        }
        Section transformationVariablesSection = toolkit.createSection(body, 320);
        transformationVariablesSection.setText(Messages.getString("MigrationSchemeEditor.section.vars.title"));
        transformationVariablesSection.setLayoutData((Object)new GridData(4, -1, true, false));
        Composite transformationVariablesArea = toolkit.createComposite((Composite)transformationVariablesSection, 0);
        layout = new GridLayout(1, false);
        layout.horizontalSpacing = 15;
        transformationVariablesArea.setLayout((Layout)layout);
        transformationVariablesSection.setClient((Control)transformationVariablesArea);
        transformationVariablesArea.setLayoutData((Object)new GridData(4, -1, true, false));
        this.vars = new TransformationVariablesComposite(transformationVariablesArea, 0);
        this.vars.setLayoutData(new GridData(4, 4, true, true));
        ArrayList<TransformationVariable> transformationVariables = this.vars.getTransformationVariables();
        if (transformationVariables instanceof ListeningArrayList) {
            ListeningArrayList lTransformationVariables;
            ListeningArrayList listeningArrayList = lTransformationVariables = (ListeningArrayList)transformationVariables;
            listeningArrayList.getClass();
            lTransformationVariables.addListener(new ListeningArrayList.ArrayListListener(listeningArrayList, lTransformationVariables){

                @Override
                public void notify(boolean changed, ListeningArrayList<?> source) {
                    MigrationSchemeOverviewPage.this.setDirty(true);
                    MigrationSchemeOverviewPage.this.validateInputs();
                }
            });
        }
        this.refresh();
    }

    private String getHelpContextID() {
        return "com.ibm.cics.cm.ui.editor_migrationscheme";
    }

    protected boolean hasErrors() {
        return this.errorsOnPage;
    }

    private void validateInputs() {
        if (!this.refreshing) {
            if (this.paths == null || this.paths.getMigrationPaths().isEmpty()) {
                String shortErrorMessage = Messages.getString("MigrationSchemeWizardPage.errorMessage.noMigrationPaths");
                String longErrorMessage = Messages.getString("MigrationSchemeWizardPage.errorMessage.noMigrationPaths");
                this.setErrorMessage((Control)this.paths.viewer.getTable(), shortErrorMessage, longErrorMessage);
            } else {
                this.clearErrorMessage((Control)this.paths.viewer.getTable());
            }
            ((MigrationSchemeEditor)this.editor).refreshDirty();
        }
    }

    private void setErrorMessage(Control control, String shortMessage, String longMessage) {
        ScrolledForm form = this.getManagedForm().getForm();
        IStatusLineManager status = this.getEditorSite().getActionBars().getStatusLineManager();
        UIHelper.errorControl((Control)control, (String)longMessage);
        form.setMessage(shortMessage, 3);
        status.setErrorMessage(UIActivator.getImage(UIActivator.IMGD_ERROR), longMessage);
        this.errorsOnPage = true;
        status.update(true);
    }

    private void clearErrorMessage(Control control) {
        ScrolledForm form = this.getManagedForm().getForm();
        IStatusLineManager status = this.getEditorSite().getActionBars().getStatusLineManager();
        if (control != null) {
            UIHelper.clearError((Control)control);
        }
        form.setMessage(null, -1);
        status.setErrorMessage(null);
        this.errorsOnPage = false;
        status.update(true);
    }

    private void setDirty(boolean value) {
        ((MigrationSchemeEditor)this.editor).setDirty(value);
    }

    protected void refresh() {
        this.refreshing = true;
        this.descText.setText(this.scheme.getDescription());
        this.approval.setSelection(this.scheme.getApproval());
        this.paths.setInput(this.scheme.getMigrationPaths());
        this.vars.setInput(this.scheme.getTranformationVariables());
        this.setDirty(false);
        this.refreshing = false;
        this.validateInputs();
    }

    protected String getDescription() {
        return this.descText.getText();
    }

    public boolean getApproval() {
        return this.approval.getSelection();
    }

    public ArrayList<MigrationPath> getMigrationPaths() {
        return this.paths.getMigrationPaths();
    }

    public ArrayList<TransformationVariable> getTransformationVariables() {
        return this.vars.getTransformationVariables();
    }
}

