/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.editors;

import com.ibm.cics.cm.model.MigrationScheme;
import com.ibm.cics.cm.model.runtime.MessageResponse;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.editors.MigrationSchemeEditorInput;
import com.ibm.cics.cm.ui.editors.MigrationSchemeOverviewPage;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MigrationSchemeEditor
extends FormEditor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2023 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ID = "com.ibm.cics.cm.ui.scheme.editor";
    private MigrationScheme.MigrationSchemeListener schemeListener;
    private MigrationSchemeOverviewPage overviewPage;
    private MigrationScheme scheme;
    private boolean dirty;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setPartName(MessageFormat.format(Messages.getString("MigrationSchemeEditor.partname"), input.getName()));
        this.setTitleImage(UIActivator.getImage(UIActivator.IMGD520_MIGRATION_SCHEME));
    }

    public FormToolkit getToolkit() {
        if (super.getToolkit() == null) {
            super.createToolkit(Display.getCurrent());
        }
        return super.getToolkit();
    }

    protected void addPages() {
        try {
            this.overviewPage = new MigrationSchemeOverviewPage(this);
            this.addPage((IFormPage)this.overviewPage);
            IEditorInput input = this.getEditorInput();
            if (input instanceof MigrationSchemeEditorInput) {
                MigrationScheme scheme;
                MigrationScheme migrationScheme = scheme = ((MigrationSchemeEditorInput)input).getMigrationScheme();
                migrationScheme.getClass();
                this.schemeListener = new MigrationScheme.MigrationSchemeListener(migrationScheme, scheme){

                    public void notify(boolean changed, MigrationScheme source) {
                        if (source.isDeleted()) {
                            MigrationSchemeEditor.this.closeEditor();
                        } else {
                            MigrationSchemeEditor.this.refreshEditor(changed);
                        }
                    }
                };
                scheme.addListener(this.schemeListener);
                this.scheme = scheme;
            }
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }

    private void closeEditor() {
        final MigrationSchemeEditor editor = this;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)editor, false);
            }
        });
    }

    private void refreshEditor(boolean changed) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean refreshOK = true;
                if (MigrationSchemeEditor.this.dirty) {
                    MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 196);
                    messageBox.setText(Messages.getString("MigrationSchemeEditor.message.refreshDirtyEditor.title"));
                    messageBox.setMessage(Messages.getString("MigrationSchemeEditor.message.refreshDirtyEditor.description"));
                    if (messageBox.open() == 128) {
                        refreshOK = false;
                    }
                }
                if (refreshOK) {
                    MigrationSchemeEditor.this.overviewPage.refresh();
                    MigrationSchemeEditor.this.setDirty(false);
                }
            }
        });
    }

    public void doSave(IProgressMonitor monitor) {
        this.scheme.setDescription(this.overviewPage.getDescription());
        this.scheme.setApproval(this.overviewPage.getApproval());
        this.scheme.setMigrationPaths(this.overviewPage.getMigrationPaths());
        this.scheme.setTransformationVariables(this.overviewPage.getTransformationVariables());
        MessageResponse lastResponse = this.scheme.update();
        if (lastResponse != null) {
            Status status = this.getStatusToLog(lastResponse);
            UIActivator.getDefault().getLog().log((IStatus)status);
        }
        this.setDirty(false);
    }

    private Status getStatusToLog(MessageResponse mr) {
        int logLevel = 1;
        switch (mr.returnCode) {
            case 0: {
                logLevel = 0;
                break;
            }
            case 4: {
                logLevel = 2;
                break;
            }
            case 8: {
                logLevel = 4;
                break;
            }
            case 12: {
                logLevel = 4;
                break;
            }
            case 16: {
                logLevel = 4;
                break;
            }
            default: {
                logLevel = 1;
            }
        }
        String message = MessageFormat.format(Messages.getString("MigrationSchemeEditor.status.saved"), this.scheme.getName(), mr.getReadableReturnCode());
        MultiStatus status = new MultiStatus("com.ibm.cics.cm.ui", logLevel, message, null);
        if (logLevel != 0) {
            status.add((IStatus)new Status(logLevel, "com.ibm.cics.cm.ui", mr.getReadableReasonCode()));
        }
        return status;
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        this.scheme.removeListener(this.schemeListener);
        this.schemeListener.dispose();
        super.dispose();
    }

    public boolean isDirty() {
        return this.dirty && !this.overviewPage.hasErrors();
    }

    protected void setDirty(boolean value) {
        this.dirty = value;
        this.firePropertyChange(257);
    }

    protected void refreshDirty() {
        this.firePropertyChange(257);
    }
}

